<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('popular_airlines', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('name');
            $table->string('url');
            $table->tinyInteger('status');
            $table->string('title')->nullable();
            $table->string('arabic_title')->nullable();
            $table->string('sub_title')->nullable();
            $table->string('arabic_sub_title')->nullable();
            $table->string('banner_title')->nullable();
            $table->string('arabic_banner_title')->nullable();
            $table->string('banner_sub_title')->nullable();
            $table->string('arabic_banner_sub_title')->nullable();
            $table->string('banner')->nullable();
            $table->longText('content')->nullable();
            $table->longText('arabic_content')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('popular_airlines');
    }
};
