<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('seo_trending_flights', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->char('from_airport_id', 36);
            $table->string('from_airport_name');
            $table->string('from_airport');
            $table->string('from_airport_city_en');
            $table->string('from_airport_city_ar');
            $table->char('to_airport_id', 36);
            $table->string('to_airport_name');
            $table->string('to_airport');
            $table->string('to_airport_city_en');
            $table->string('to_airport_city_ar');
            $table->tinyInteger('status');
            $table->longText('content')->nullable();
            $table->longText('arabic_content')->nullable();
            $table->string('title')->nullable();
            $table->string('arabic_title')->nullable();
            $table->string('sub_title')->nullable();
            $table->string('arabic_sub_title')->nullable();
            $table->string('banner_title')->nullable();
            $table->string('arabic_banner_title')->nullable();
            $table->string('banner_sub_title')->nullable();
            $table->string('arabic_banner_sub_title')->nullable();
            $table->string('banner')->nullable();
            $table->timestamp('created_at')->useCurrentOnUpdate()->useCurrent();
            $table->timestamp('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('seo_trending_flights');
    }
};
