<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('summer_offers', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('offer_title')->nullable();
            $table->string('offer_title_ar')->nullable();
            $table->string('offer_content')->nullable();
            $table->string('offer_content_ar')->nullable();
            $table->string('offer_link')->nullable();
            $table->string('offer_image');
            $table->tinyInteger('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('summer_offers');
    }
};
