<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('supplier_log', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('log_id')->index('log_id');
            $table->string('log_parent_id')->nullable();
            $table->string('type');
            $table->string('supplier');
            $table->string('supplier_reference')->nullable();
            $table->char('ama_client_ref', 36)->nullable();
            $table->string('log_type');
            $table->char('customer_id', 36)->nullable();
            $table->char('booking_id', 36)->nullable();
            $table->longText('request');
            $table->longText('response');
            $table->timestamp('created_at')->useCurrentOnUpdate()->useCurrent();
            $table->timestamp('updated_at')->default('0000-00-00 00:00:00');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('supplier_log');
    }
};
