<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trending_flights', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->char('from_airport_id', 36);
            $table->string('from_airport_name');
            $table->string('from_airport');
            $table->string('from_airport_city_en');
            $table->string('from_airport_city_ar');
            $table->char('to_airport_id', 36);
            $table->string('to_airport_name');
            $table->string('to_airport');
            $table->string('to_airport_city_en');
            $table->string('to_airport_city_ar');
            $table->date('from_date');
            $table->date('to_date');
            $table->string('trip_type');
            $table->string('trip_class');
            $table->integer('adult');
            $table->integer('child');
            $table->integer('infant');
            $table->tinyInteger('status');
            $table->timestamp('created_at')->useCurrentOnUpdate()->useCurrent();
            $table->timestamp('updated_at')->default('0000-00-00 00:00:00');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('trending_flights');
    }
};
