<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('airline_i18ns_back', function (Blueprint $table) {
            $table->foreign(['language_code'], 'airline_i18ns_language_code_foreign')->references(['language_code'])->on('core_languages')->onUpdate('CASCADE')->onDelete('CASCADE');
            $table->foreign(['airline_id'], 'airline_i18ns_airline_id_foreign')->references(['id'])->on('airlines_back')->onUpdate('CASCADE')->onDelete('CASCADE');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('airline_i18ns_back', function (Blueprint $table) {
            $table->dropForeign('airline_i18ns_language_code_foreign');
            $table->dropForeign('airline_i18ns_airline_id_foreign');
        });
    }
};
