@extends('admin.layout.main')
@section('title',$header['title'])
@section('content')
<style>
    textarea.select2-search__field {
        width: 40.50em !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        color: #000 !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
        margin-top: -0.8rem;
    }

    .select2-container--default.select2-container--focus .select2-selection--multiple {
        margin-top: 7px;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice__display {
        margin-left: 5px !important;
    }
</style>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
                <h1 class="m-0">{{ $header['title'] }}</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">@lang('coupons.dashboard') </a></li>
                    <li class="breadcrumb-item"><a href="{{ route('coupons.index') }}">@lang('coupons.moduleHeading')</a></li>
                    <li class="breadcrumb-item active">@lang('coupons.edit')</li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->

<section class="content">
    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            <div class="card pb-4 pt-3 px-3 w-100">
                <form method="post" action="{{route('coupons.update',$couponDetail['id'])}}" id="dataForm" class="form row mb-0 validate" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <input type="hidden" name="redirects_to" id="redirects_to" value="{{ URL::previous() }}">
                    <input type="hidden" name="coupon_id" id="coupon_id" value="{{$couponDetail['id']}}" />

                    <!-- <div class="brdr-btm row"> -->

                    <div class="col-md-6">
                        <div class="form-item input-group mb-3">
                            <input type="text" id="random_number" name="coupon_code" class="form-control bg-white" aria-label="Generate Offer Code" aria-describedby="basic-addon2" value="{{ $couponDetail['coupon_code'] }}">
                            <div class="input-group-append">
                                <button class="btn btn-info btn-flat" id="button" type="button" onclick="randomString()">Generate Offer Code</button>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-6">
                        <div class="form-item form-float-style">
                            <textarea id="description" name="description" autocomplete="off" required class="is-valid">{{ $couponDetail['description'] }}</textarea>
                            <label for="firstname">Description <span class="req-star">*</span></label>
                        </div>
                    </div>


                    <!-- <div class="col-md-6">
                        <div class="form-item form-float-style">
                            <input type="text" id="coupon_amount" name="coupon_amount" autocomplete="off" required class="is-valid" value="{{ $couponDetail['coupon_amount'] }}">
                            <label for="firstname">@lang('coupons.couponAmount') <span class="req-star">*</span></label>
                        </div>
                    </div> -->
                    <div class="col-md-6">
                        <div class="select top-space-rem after-drp form-item form-float-style">
                            <select data-live-search="true" id="discount_type" name="discount_type" class="order-td-input selectpicker select-text height_drp is-valid">
                                <option value="">Select Discount Type</option>
                                <option @if($couponDetail['discount_type']=='amount' ) selected="selected" @endif value="amount">Amount </option>
                                <option @if($couponDetail['discount_type']=='percentage' ) selected="selected" @endif value="percentage">Percentage </option>
                            </select>
                            <label for="Discount Type">Discount Type<span class="req-star">*</span></label>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <button type="button" class="btn btn-primary add-field " style="margin-top: 5px">
                            <i class="fas fa-plus"></i> Add Range
                        </button>
                    </div>

                    @php
                    // Extract and split values from database
                    $minimumDiscount = isset($couponDetail['minimum_spend']) ? explode(',', $couponDetail['minimum_spend']) : [];
                    $maximumDiscount = isset($couponDetail['maximum_spend']) ? explode(',', $couponDetail['maximum_spend']) : [];
                    $couponAmounts = isset($couponDetail['coupon_amount']) ? explode(',', $couponDetail['coupon_amount']) : [];

                    // Get the highest count to loop through
                    $count = max(count($minimumDiscount), count($maximumDiscount), count($couponAmounts));
                    @endphp

                    <div id="discountContainer">
                        @for ($i = 0; $i < $count; $i++)
                            <div class="row discount-row">
                            <!-- Minimum Spend -->
                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input type="text" name="minimum_spend[]" autocomplete="off" required class="is-valid"
                                        value="{{ $minimumDiscount[$i] ?? '' }}">
                                    <label>Minimum Spend <span class="req-star">*</span></label>
                                </div>
                            </div>

                            <!-- Maximum Spend -->
                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input type="text" name="maximum_spend[]" autocomplete="off" required class="is-valid"
                                        value="{{ $maximumDiscount[$i] ?? '' }}">
                                    <label>Maximum Spend <span class="req-star">*</span></label>
                                </div>
                            </div>

                            <!-- Discount Value -->
                            <div class="col-md-3">
                                <div class="form-item form-float-style">
                                    <input type="text" name="coupon_amount[]" autocomplete="off" required class="is-valid"
                                        value="{{ $couponAmounts[$i] ?? '' }}">
                                    <label>Discount Value <span class="req-star">*</span></label>
                                </div>
                            </div>

                            <!-- Remove Button -->
                            <div class="col-md-1">
                                <button type="button" class="btn btn-danger remove-field" style="margin-top:4px">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                    </div>
                    @endfor

                    <!-- Empty Row for Adding New Fields -->
                    <div class="row discount-row">
                        <div class="col-md-4">
                            <div class="form-item form-float-style">
                                <input type="text" name="minimum_spend[]" autocomplete="off" required class="is-valid">
                                <label>Minimum Spend <span class="req-star">*</span></label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-item form-float-style">
                                <input type="text" name="maximum_spend[]" autocomplete="off" required class="is-valid">
                                <label>Maximum Spend <span class="req-star">*</span></label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style">
                                <input type="text" name="coupon_amount[]" autocomplete="off" required class="is-valid">
                                <label>Discount Value <span class="req-star">*</span></label>
                            </div>
                        </div>

                    </div>
            </div>

            <div class="col-md-6">
                <div class="form-item form-float-style">
                    <input type="text" class="datepicker is-valids is-valid" name="from_date" id="from_date" placeholder="dd/MM/YYYY" autocomplete="off" class="is-valid" value="{{ $couponDetail['from_date'] }}">
                    <label for="datepicker">From Date<span class="req-star">*</span></label>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-item form-float-style">
                    <input type="text" class="datepicker is-valids is-valid" name="to_date" id="to_date" placeholder="dd/MM/YYYY" autocomplete="off" class="is-valid" value="{{ $couponDetail['to_date'] }}">
                    <label for="datepicker">To Date<span class="req-star">*</span></label>
                </div>
            </div>


            <!-- <div class="col-md-6">
                        <div class="form-item form-float-style">
                            <input type="text" id="minimum_spend" name="minimum_spend" autocomplete="off" required class="is-valid" value="{{ $couponDetail['minimum_spend'] }}">
                            <label for="firstname">Minimum Spend <span class="req-star">*</span></label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-item form-float-style">
                            <input type="text" id="maximum_spend" name="maximum_spend" autocomplete="off" required class="is-valid" value="{{ $couponDetail['maximum_spend'] }}">
                            <label for="firstname">Maximum Spend <span class="req-star">*</span></label>
                        </div>
                    </div> -->





            <div class="col-md-6">
                <div class="form-item form-float-style">
                    <input type="text" id="limit_per_coupon" name="limit_per_coupon" autocomplete="off" required class="is-valid" value="{{ $couponDetail['limit_per_coupon'] }}">
                    <label for="firstname">Limit Per Coupon <span class="req-star">*</span></label>
                </div>
            </div>


            <div class="col-md-6">
                <div class="select top-space-rem after-drp form-item form-float-style">
                    <select data-live-search="true" id="status" name="status" class="order-td-input selectpicker select-text height_drp is-valid">
                        <option value="">Select status</option>
                        <option value="active" {{ $couponDetail['status'] == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="expired" {{ $couponDetail['status'] == 'expired' ? 'selected' : '' }}>Expired</option>
                        <option value="inactive" {{ $couponDetail['status'] == 'inactive' ? 'selected' : '' }}>Inactive</option>
                        <option value="used_up" {{ $couponDetail['status'] == 'used_up' ? 'selected' : '' }}>Used Up</option>
                    </select>
                    <label for="status">Select Status<span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-item form-float-style">
                    <input type="text" id="bank_name" name="bank_name" autocomplete="off" class="is-valid" value="{{ $couponDetail['bank_name'] ?? '' }}">
                    <label for="bank_name">Bank Name Card</label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-item form-float-style">
                    <input type="text" id="bank_card_number" name="bank_card_number" autocomplete="off" class="is-valid" value="{{ $couponDetail['bank_card_number'] ?? '' }}">
                    <label for="bank_card_number">Bank Card Number</label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="select top-space-rem after-drp form-item form-float-style">
                    <select data-live-search="true" id="product" required name="product" class="order-td-input selectpicker select-text height_drp is-valid">
                        <option value="">Select Product</option>
                        <option value="flight" {{ $couponDetail['product'] == 'flight' ? 'selected' : '' }}>Flight</option>
                        <option value="hotel" {{ $couponDetail['product'] == 'hotel' ? 'selected' : '' }}>Hotel</option>
                        <option value="general" {{ $couponDetail['product'] == 'general' ? 'selected' : '' }}>General</option>
                        <option value="package" {{ $couponDetail['product'] == 'package' ? 'selected' : '' }}>Package</option>
                        <option value="tours" {{ $couponDetail['product'] == 'tours' ? 'selected' : '' }}>Tours</option>
                        <option value="car_rental" {{ $couponDetail['product'] == 'car_rental' ? 'selected' : '' }}>Car Rental</option>
                    </select>
                    <label for="product">Product<span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-item form-float-style">
                    <input type="text" id="airline_name" name="airline_name" autocomplete="off" class="is-valid" value="{{ $couponDetail['airline_name'] ?? '' }}">
                    <label for="airline_name">Airline Name</label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-item form-float-style">
                    <input type="text" id="airline_cabin_class" name="airline_cabin_class" autocomplete="off" class="is-valid" value="{{ $couponDetail['airline_cabin_class'] ?? '' }}">
                    <label for="airline_cabin_class">Airline Cabin Class</label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-item form-float-style">
                    <input type="text" id="hotel_name" name="hotel_name" autocomplete="off" class="is-valid" value="{{ $couponDetail['hotel_name'] ?? '' }}">
                    <label for="hotel_name">Hotel Name</label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-item form-float-style">
                    <input type="text" id="hotel_city" name="hotel_city" autocomplete="off" class="is-valid" value="{{ $couponDetail['hotel_city'] ?? '' }}">
                    <label for="hotel_city">Hotel City</label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="select top-space-rem after-drp form-item form-float-style">
                    <select data-live-search="true" id="domestic_product" name="domestic_product" class="order-td-input selectpicker select-text height_drp is-valid">
                        <option value="">Select Product</option>
                        <option value="domestic_flights" {{ $couponDetail['domestic_product'] == 'domestic_flights' ? 'selected' : '' }}>Domestic Flights</option>
                        <option value="hotels_saudi" {{ $couponDetail['domestic_product'] == 'hotels_saudi' ? 'selected' : '' }}>Hotels in Saudi Arabia</option>
                    </select>
                    <label for="domestic_product">Domestic Product</label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="select top-space-rem after-drp form-item form-float-style">
                    <select data-live-search="true" id="international_product" name="international_product" class="order-td-input selectpicker select-text height_drp is-valid">
                        <option value="">Select status</option>
                        <option value="international_flights" {{ $couponDetail['international_product'] == 'international_flights' ? 'selected' : '' }}>International Flights</option>
                        <option value="hotels" {{ $couponDetail['international_product'] == 'hotels' ? 'selected' : '' }}>Hotels</option>
                    </select>
                    <label for="international_product">International Product</label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="select top-space-rem after-drp form-item form-float-style">
                    <select data-live-search="true" id="payment_method" name="payment_method" class="order-td-input selectpicker select-text height_drp is-valid">
                        <option value="">Select Discount Type</option>
                        <option value="credit_card" {{ $couponDetail['payment_method'] == 'credit_card' ? 'selected' : '' }}>Credit Card</option>
                        <option value="visa" {{ $couponDetail['payment_method'] == 'visa' ? 'selected' : '' }}>Visa</option>
                        <option value="stc_pay" {{ $couponDetail['payment_method'] == 'stc_pay' ? 'selected' : '' }}>STC Pay</option>
                        <option value="saddad" {{ $couponDetail['payment_method'] == 'saddad' ? 'selected' : '' }}>Saddad</option>
                        <option value="qitaf" {{ $couponDetail['payment_method'] == 'qitaf' ? 'selected' : '' }}>Qitaf</option>
                        <option value="installment" {{ $couponDetail['payment_method'] == 'installment' ? 'selected' : '' }}>Installment</option>
                        <option value="apple_pay" {{ $couponDetail['payment_method'] == 'apple_pay' ? 'selected' : '' }}>Apple Pay</option>
                        <option value="mobile_pay" {{ $couponDetail['payment_method'] == 'mobile_pay' ? 'selected' : '' }}>Mobile Pay</option>
                    </select>
                    <label for="payment_method">Payment of Method</label>
                </div>
            </div>


            <!-- Added New Field -->
            <div class="col-md-6">
                <div class="form-check form-switch">
                    <input type="checkbox" class="form-check-input" id="flexSwitchCheckDefault" id="is_new" name="is_new" value="1" {{ ($couponDetail['is_new'] == 1) ? 'checked' : ''; }}>
                    <label for="is_new" class="form-label text-dark">Is New ?</label>
                </div>
            </div>


            <div class="col-md-6">
                <div class="select top-space-rem after-drp form-item form-float-style">
                    <select data-live-search="true" id="coupon_type" name="coupon_type" class="order-td-input selectpicker select-text height_drp is-valid">
                        <option value="">Select Coupon Type </option>
                        <option value="discount coupon" {{ $couponDetail['coupon_type'] == 'discount coupon' ? 'selected' : '' }}>Discount Coupon</option>
                        <option value="cashback coupon" {{ $couponDetail['coupon_type'] == 'cashback coupon' ? 'selected' : '' }}>Cashback Coupon</option>
                    </select>
                    <label for="Coupon Type">Coupon Type<span class="req-star">*</span></label>
                </div>
            </div>




            <div class="col-md-6" id="expiry_date_container">
                <div class="form-item form-float-style">
                    <input type="date" id="expiry_date" name="expiry_date" autocomplete="off" class="datepicker is-valids is-valid" placeholder="dd/MM/YYYY" value="{{ $couponDetail['expiry_date'] ?? '' }}">
                    <label for="expiry_date">Expiry Date <span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-6" id="thumbnail_container">
                <div class="form-item form-float-style">
                    <input type="file" id="thumbnail" name="thumbnail" autocomplete="off" class="is-valid">
                    <label for="thumbnail">Upload Thumbnail</label>
                </div>
            </div>

            <div class="col-md-6" id="banner_container">
                <div class="form-item form-float-style">
                    <input type="file" id="banner" name="banner" autocomplete="off" class="is-valid">
                    <label for="banner">Upload Banner</label>
                </div>
            </div>

            @if($couponDetail['thumbnail'] != null)
            <div class="col-md-3">


                <button type="button" class="btn btn-primary btn-sm mt-2" data-bs-toggle="modal" data-bs-target="#imageModal" onclick="viewImage('{{ asset('storage/' . $couponDetail['thumbnail']) }}')">View Thumbnail</button>
            </div>
            @endif

            @if($couponDetail['banner'] != null)
            <div class="col-md-3">



                <button type="button" class="btn btn-primary btn-sm mt-2" data-bs-toggle="modal" data-bs-target="#imageModal" onclick="viewImage('{{ asset('storage/' . $couponDetail['banner']) }}')">View Banner</button>
            </div>
            @endif


            <div class="col-md-6">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="{{ $couponDetail['banner_title'] ?? '' }}" id="banner_title" name="banner_title" autocomplete="off" class="is-valid">
                    <label for="to_date">Banner Title <span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="{{ $couponDetail['arabic_banner_title'] ?? '' }}" id="arabic_banner_title" name="arabic_banner_title" autocomplete="off" class="is-valid" dir="rtl">
                    <label for="to_date">Banner Arabic Title <span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="{{ $couponDetail['banner_sub_title'] ?? '' }}" id="banner_sub_title" name="banner_sub_title" autocomplete="off" class="is-valid">
                    <label for="to_date">Banner Sub Title <span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="{{ $couponDetail['arabic_banner_sub_title'] ?? '' }}" id="arabic_banner_sub_title" name="arabic_banner_sub_title" autocomplete="off" class="is-valid" dir="rtl">
                    <label for="to_date">Banner Arabic Sub Title <span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-12 row">
                <div class="col-md-12">
                    <div class="form-item form-float-style">
                        <label for="content">Terms and Conditions (English)</label>
                        <textarea name="terms_en" id="editor_en" minlength="1">{{ $couponDetail['terms_en'] }}</textarea>
                        @error('terms_en')
                        <span id="content-error" class="error invalid-feedback ">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="col-md-12 row">
                <div class="col-md-12">
                    <div class="form-item form-float-style">
                        <label for="content">Terms and Conditions (Arabic)</label>
                        <textarea name="terms_ar" id="editor_ar" minlength="1" dir="rtl">{{ $couponDetail['terms_ar'] }}</textarea>
                        @error('terms_ar')
                        <span id="content-error" class="error invalid-feedback ">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
            </div>

        </div>


        <div class="col-md-6">

            <div id='profile_image_sectionsss'>
                <img data-toggle="popover" id="croppedImagePreview" height="150" width="150" src="" alt="no-image" style="display: none;">
            </div>
        </div>





        <div class="cards-btn mt-3">
            <button type="submit" id="disBtn" class="btn btn-success form-btn-success">@lang('coupons.submit')</button>
            <a href="{{ route('coupons.index') }}" type="button" class="btn btn-danger form-btn-danger">@lang('coupons.cancel')</a>
        </div>
        </form>
        <!-- </div> -->
        <!--/. container-fluid -->

        <!-- Image Modal -->
        <div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="imageModalLabel">Image Preview</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <img id="modalImage" src="" class="img-fluid" style="max-height: 500px;">
                    </div>
                </div>
            </div>
        </div>
</section>
@endsection
@section('js')
<script>
    $("#agency").select2();
    $("#customer").select2();

    $(document).ready(function domReady() {
        $(".js-select2").select2({
            placeholder: "Select Airlines",
            theme: "material"
        });

        $(".select2-selection__arrow")
            .addClass("material-icons")
            .html("arrow_drop_down");
    });
    //show hide by customer(b2c) and agency(b2b)
    $("#agencyShowHide").hide();
    $('#customer_type').on('change', function() {
        var moduleType = $(this).val();
        if (moduleType == 'B2B') {
            $("#agencyShowHide").show();
            $("#customerShowHide").hide();
        } else if (moduleType == 'B2C') {
            $("#agencyShowHide").hide();
            $("#customerShowHide").show();
        } else {
            $("#agencyShowHide").hide();
            $("#customerShowHide").show();
        }
    });
    $('#customer_type').trigger('change');


    $(document).ready(function() {
        $('.js-example-basic-multiple').select2();
    });
</script>

<!-- Page specific script -->
<script>
    function randomString() {
        var chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";
        var string_length = 6;
        var randomstring = '';
        for (var i = 0; i < string_length; i++) {
            var rnum = Math.floor(Math.random() * chars.length);
            randomstring += chars.substring(rnum, rnum + 1);
        }
        //display the generated string   
        document.getElementById("random_number").value = randomstring;
    }

    //make GST value uppercase
    $('#usergstno').keyup(function() {
        $(this).val($(this).val().toUpperCase());
    });
    $('#userpackeg-gst').keyup(function() {
        $(this).val($(this).val().toUpperCase());
    });

    //on change profile set old_profile_image blank
    $('#upload-profile').change(function() {
        $("#old_profile_image").val('');
    });
    //on change profile set old_gst_certificate blank
    $('#upload-gst-cert').change(function() {
        $("#old_gst_certificate").val('');
    });
    //on change profile set old_company_certificate blank
    $('#upload-comp-cert').change(function() {
        $("#old_company_certificate").val('');
    });

    //remove profile image
    function removeProfileImage() {
        $('#profile_image_section').hide();
        $("#old_profile_image").val('');
    }

    //address readonly event script



    $(function() {
        $('.datepicker').datepicker({
            dateFormat: 'yy-mm-dd',
            changeYear: true,
            yearRange: '1900:2100', // Specify a range of selectable years

        });
        $.validator.addMethod("dateComparison", function(value, element) {
            var fromDate = $("#from_date").val();
            var toDate = $("#to_date").val();

            // Perform date comparison
            return new Date(fromDate) <= new Date(toDate);
        }, "To Date must be greater than or equal to From Date");
        $.validator.addMethod("minMaxComparison", function(value, element) {
            var minimum_spend = $("#minimum_spend").val();
            var maximum_spend = $("#maximum_spend").val();
            // Perform date comparison
            return parseFloat(minimum_spend) < parseFloat(maximum_spend);
        }, "Maximum Spend must be greater than Minimum Spend");

        //jquery Form validation
        $('#dataForm').validate({
            onkeyup: false,
            rules: {
                // upload_image: {
                //     accept: "image/jpg,image/jpeg,image/png",
                //     maxsize: 1000000,
                // },
                // 'coupon_names[0][coupon_name]': {
                //     required: true,
                // },
                // 'coupon_names[1][coupon_name]': {
                //     required: true,
                // },
                // customer_type: {
                //     required: true,
                // },
                coupon_amount: {
                    number: true,
                    noSpace: true,
                    maxlength: 100,
                },
                discount_type: {
                    required: true,
                },
                from_date: {
                    required: true,
                },


                to_date: {
                    required: true,
                    dateComparison: true
                },
                minimum_spend: {
                    noSpace: true,
                    required: true,
                    number: true,
                },
                maximum_spend: {
                    noSpace: true,
                    required: true,
                    number: true,
                    minMaxComparison: true,
                },
                // service_type: {
                //     required: true,
                // },
                limit_per_coupon: {
                    noSpace: true,
                    required: true,
                    number: true,
                },
                status: {
                    required: true,
                },
                // limit_per_customer: {
                //     noSpace: true,
                //     required: true,
                //     number: true,
                // },
                coupon_type: {
                    required: true,
                },
                expiry_date: {
                    required: true,
                },
                banner_title: {
                    required: true,
                },
                arabic_banner_title: {
                    required: true,
                },
                banner_sub_title: {
                    required: true,
                },
                arabic_banner_sub_title: {
                    required: true,
                },

            },


            messages: {
                // 'coupon_names[0][coupon_name]': {
                //     required: "Please enter a Coupon Name English"
                // },
                // 'coupon_names[1][coupon_name]': {
                //     required: "Please enter a Coupon Name Arabic"
                // },
                // customer_type: {
                //     required: "Please select a Customer Type"
                // },
                coupon_code: {
                    required: "Please enter a Coupon Code",
                    remote: "Coupon Code is already taken"
                },
                coupon_amount: {
                    required: "Please enter a Coupon Amount",
                },
                discount_type: {
                    required: "Please select a Discount Type",
                },
                from_date: {
                    required: "Please select a From Date",
                },
                to_date: {
                    required: "Please Select a To Date",
                },
                // upload_image: {
                //     accept: "Please select image format must be .jpg, .jpeg or .png.",
                //     maxsize: "Please upload image size less than 1MB"
                // },
                maximum_spend: {
                    required: "Please select a Maximum Spend"
                },
                minimum_spend: {
                    required: "Please select a Minimum Spend"
                },
                // service_type: {
                //     required: "Please select a Service Type"
                // },
                // customer: {
                //     required: "Please select a customer",
                // },
                limit_per_coupon: {
                    required: "Please enter a Limit Per Coupon"
                },
                status: {
                    required: "Please select the status"
                },
                coupon_type: {
                    required: "Please select the coupon type"
                },
                expiry_date: {
                    required: "Please select the expiry date"
                },
                banner_title: {
                    required: "Please enter Banner Title (English)"
                },
                arabic_banner_title: {
                    required: "Please enter Banner Title (Arabic)"
                },
                banner_sub_title: {
                    required: "Please enter Banner Subtitle (English)"
                },
                arabic_banner_sub_title: {
                    required: "Please enter Banner Subtitle (English)"
                },
            },
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-item').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
            submitHandler: function(form) {
                $("#disBtn").attr("disabled", true);
                form.submit();
            }
        })
    });
</script>
<script>
    $(document).ready(function() {
        var checkbox = document.getElementById('allCustomer');
        var mySelect = document.getElementById('customer');
        $("#allCustomer").change(function() {

            if (checkbox.checked == true) {
                $("#customer").val(null).trigger("change");
                document.getElementById("allCust").style.pointerEvents = "none";

            } else {

                document.getElementById("allCust").style.pointerEvents = "auto";
            }
        });
        $("#allCustomer").trigger("change");
    });
    $(document).ready(function() {
        var checkboxacg = document.getElementById('allAgency');
        var mySelectacg = document.getElementById('agency');
        $("#allAgency").change(function() {

            if (checkboxacg.checked == true) {
                document.getElementById("allAgen").style.pointerEvents = "none";
                $("#agency").val(null).trigger("change");

            } else {

                document.getElementById("allAgen").style.pointerEvents = "auto";
            }
        });
        $("#allAgency").trigger("change");
    });
</script>
<script>
    document.getElementById('coupon_type').addEventListener('change', function() {
        let expiryContainer = document.getElementById('expiry_date_container');
        let expiryInput = document.getElementById('expiry_date');

        if (this.value === "cashback coupon") {
            let currentDate = new Date();
            currentDate.setMonth(currentDate.getMonth() + 3); // Add 3 months
            let formattedDate = currentDate.toISOString().split('T')[0];
            expiryInput.value = formattedDate;
            expiryContainer.style.display = "block";
        } else if (this.value === "discount coupon") {
            expiryInput.value = "";
            expiryContainer.style.display = "block";
        } else {
            expiryContainer.style.display = "none";
        }
    });
</script>


<!-- JavaScript to Change Modal Image -->
<script>
    function viewImage(imageSrc) {
        document.getElementById('modalImage').src = imageSrc;
    }
</script>


<script>
    document.addEventListener("DOMContentLoaded", function() {
        const container = document.getElementById("discountContainer");
        const addButton = document.querySelector(".add-field"); // Select the Add button next to Discount Type

        // Event listener for dynamically added buttons inside discountContainer
        container.addEventListener("click", function(e) {
            if (e.target.closest(".add-field")) {
                addNewFields();
            } else if (e.target.closest(".remove-field")) {
                e.target.closest(".discount-row").remove();
            }
        });

        // Event listener for the Add button next to Discount Type
        addButton.addEventListener("click", function() {
            addNewFields();
        });

        function addNewFields() {
            const newRow = document.createElement("div");
            newRow.classList.add("row", "discount-row");
            newRow.innerHTML = `
                <div class="col-md-4">
                    <div class="form-item form-float-style">
                        <input type="text" name="minimum_spend[]" autocomplete="off" required class="is-valid">
                        <label>Minimum Spend <span class="req-star">*</span></label>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-item form-float-style">
                        <input type="text" name="maximum_spend[]" autocomplete="off" required class="is-valid">
                        <label>Maximum Spend <span class="req-star">*</span></label>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-item form-float-style">
                        <input type="text" name="coupon_amount[]" autocomplete="off" required class="is-valid">
                        <label>Discount Value <span class="req-star">*</span></label>
                    </div>
                </div>
                <div class="col-md-1 ">
                    <button type="button" class="btn btn-danger remove-field" style="margin-top:5px">
                        <i class="fas fa-trash"></i>
                    </button>
                </div>
            `;
            container.appendChild(newRow);
        }
    });
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

@append