@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<style>
  .form-item input.is-valids+label {
    font-size: 11px;
    top: -5px;
  }

  .hidden {
    display: none;
  }

  .dark-mode .select2-container .select2-search--inline .select2-search__field {
    color: #222 !important;
  }

  .select2-container--default .select2-selection--multiple .select2-selection__choice {
    color: #222 !important;
    padding-left: 25px !important;
  }
</style>

<style>
  textarea.select2-search__field {
    width: 40.50em !important;
  }

  .select2-container--default .select2-selection--multiple .select2-selection__choice {
    color: #000 !important;
  }

  .select2-container--default .select2-selection--multiple .select2-selection__choice__display {
    margin-left: 5px;
  }
</style>


<!-- /.Start content-header -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-4 mt-2">
      <div class="col-sm-12 d-flex breadcrumb-style">
        <h1 class="m-0">Block Flights - Edit</h1>
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
          <li class="breadcrumb-item"><a href="{{ route('block-flight.index') }}">Block Flights</a></li>
          <li class="breadcrumb-item active">Edit</li>
        </ol>
      </div><!-- /.col -->

    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.End content-header -->



<!-- Main content -->
<section class="content">
  <!-- Start container fluid -->
  <div class="container-fluid">
    <!-- Start Row Div -->
    <div class="row">
      <form id="basicForm" class="form validate mb-3 ml-0 mr-0 mt-0" action="{{ route('block-flight.update',$blockedFlightDetails['id']) }}" method="post" enctype="multipart/form-data">
   
        <div class="card pb-4 pt-4 px-3 w-100">

          <div class="col-md-12">
            <div class="form-group">
              @if (session('success'))
              <div class="alert alert-success" role="alert">
                <?php echo session('success'); ?>
              </div>
              @endif
              @if (session('error'))
              <div class="alert alert-danger" role="alert">
                {{ session('error') }}
              </div>
              @endif
              @if (isset($error))
              <div class="alert alert-danger" role="alert">
                {{ $error }}
              </div>
              @endif
            </div>
          </div>

          <div class="row mb-3">
            @csrf
            @method('PUT')
            <div class="col-md-6">
              <div class="col-md-12">
                <div class="form-floating form-item mb-0">
                  <div class="form-item form-float-style serach-rem mb-0">
                    <div class="select top-space-rem after-drp form-float-style form-group">
                      <select data-live-search="true" id="airlines" name="airlines" class="order-td-input select-text height_drp is-valid" style="width: 100%;" required>
                        <option value="{{$blockedFlightDetails->airline_id}}">{{ $blockedFlightDetails->airline_name }} {{$blockedFlightDetails->airline_name_arabic}}</option>
                      </select>
                      <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Airlines</label>
                    </div>
                  </div>
                </div>
              </div>
            </div>


            <div class="col-md-6">
              <div class="form-floating form-float-style form-group required mb-3">
                <div class="form-item form-float-style serach-rem mb-3">
                  <div class="select top-space-rem after-drp form-float-style form-group">
                    <select data-live-search="true" name="status" id="status" class="order-td-input selectpicker select-text height_drp is-valid select-validate" required>
                      <option value="" selected>Select Status</option>
                      <option value="Blocked Flight" @if($blockedFlightDetails->status == 'Blocked Flight') selected @endif>Block Flight</option>
                      <option value="Stop Issue Ticket" @if($blockedFlightDetails->status == 'Stop Issue Ticket') selected @endif>Stop Issue Ticket</option>

                    </select>
                    <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">@lang('adminUser.status') <span class="text-red">*</span></label>
                  </div>
                </div>
              </div>


            </div><!-- End general information div-->







            <div class="col-md-6 discount">
              <div class="cards-btn">
                <button type="submit" id="disBtn" class="btn btn-success form-btn-success">Submit</button>
                <a href="{{ route('block-flight.index') }}" class="btn btn-danger form-btn-danger">Cancel</a>
              </div>

            </div>
      </form>

    </div>
  </div>
  </div>
  </div>
  </div>
  </div>



  </div>
  <!-- /.row -->
  </div>
  <!-- End Row Div -->

  </div>

  <!-- End container fluid -->
</section>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

<script>
  ;

  $('#airlines').select2({
    ajax: {
      url: "{{ route('markups.fetchAirlines') }}",
      dataType: 'json',
      delay: 250,
      data: function(params) {
        return {
          term: params.term,
          page: params.page || 1,
          "_token": '{{ csrf_token() }}'
        };
      },
      processResults: function(data) {
        var mappedData = $.map(data, function(airline) {
          return {
            id: airline.id,
            text: airline.airname
          };
        });

        return {
          results: mappedData,
          pagination: {
            more: mappedData.length >= 10
          }
        };
      },
      cache: true
    },
    minimumInputLength: 0
  });
</script>

@append