@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<style>
  .form-item input.is-valids+label {
    font-size: 11px;
    top: -5px;
  }
</style>


<!-- /.Start content-header -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-4 mt-2">
      <div class="col-sm-12 d-flex breadcrumb-style">
        <h1 class="m-0">Edit API Details</h1>
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
          <li class="breadcrumb-item"><a href="{{ route('api-list.index') }}">API List</a></li>
          <li class="breadcrumb-item active">Edit</li>
        </ol>
      </div><!-- /.col -->

    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.End content-header -->


<!-- Main content -->
<section class="content">
  <!-- Start container fluid -->
  <div class="container-fluid">
    <!-- Start Row Div -->
    <div class="row">
      <div class="card pb-4 pt-4 px-3 w-100">
        <div class="col-md-12">
          <div class="form-group">
            @if (session('success'))
            <div class="alert alert-success" role="alert">
              <?php echo session('success'); ?>
            </div>
            @endif
            @if (session('error'))
            <div class="alert alert-danger" role="alert">
              {{ session('error') }}
            </div>
            @endif
            @if (isset($error))
            <div class="alert alert-danger" role="alert">
              {{ $error }}
            </div>
            @endif
          </div>
        </div>
        <form id="basicForm" class="form validate mb-3 ml-0 mr-0 mt-0" action="{{ route('api-list.update',$apiDetails['id']) }}" method="post" enctype="multipart/form-data">
          @csrf
        @method('PUT')
            <input type="hidden" name="redirects_to" id="redirects_to" value="{{ URL::previous() }}">
            <input type="hidden" name="id" id="id" value="{{ $apiDetails['id'] }}">
            <input type="hidden" name="saved_offer_image" id="saved_offer_image" value="{{ $apiDetails['offer_image'] }}">
            <div class="row mb-3">
                <div class="col-md-12 discount">
                    <h5 class="setting-title">API Details</h5>
                    <div class="form-floating form-float-style form-group required mb-3">
                        <div class="form-item form-float-style serach-rem mb-3">
                            <div class="select top-space-rem after-drp form-float-style form-group">
                                <select name="api_category" id="api_category" class="select-text height_drp">
                                    <option value="B2C"<?php echo ($apiDetails['api_category'] == 'B2C' ? ' selected': ''); ?>>B2C</option>
                                    <option value="Core"<?php echo ($apiDetails['api_category'] == 'Core' ? ' selected': ''); ?>>Core</option>
                                    <option value="Customer"<?php echo ($apiDetails['api_category'] == 'Customer' ? ' selected': ''); ?>>Customer</option>
                                    <option value="Flights"<?php echo ($apiDetails['api_category'] == 'Flights' ? ' selected': ''); ?>>Flights</option>
                                    <option value="Geography"<?php echo ($apiDetails['api_category'] == 'Geography' ? ' selected': ''); ?>>Geography</option>
                                    <option value="Hotels"<?php echo ($apiDetails['api_category'] == 'Hotels' ? ' selected': ''); ?>>Hotels</option>
                                    <option value="Login/Signup"<?php echo ($apiDetails['api_category'] == 'Login/Signup' ? ' selected': ''); ?>>Login/Signup</option>
                                    <option value="Profile"<?php echo ($apiDetails['api_category'] == 'Profile' ? ' selected': ''); ?>>Profile</option>
                                    <option value="Flight Bookings"<?php echo ($apiDetails['api_category'] == 'Flight Bookings' ? ' selected': ''); ?>>Flight Bookings</option>
                                </select>
                                <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">API Category <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>
                    <div class="form-floating form-float-style form-group required mb-3">
                        <div class="form-item form-float-style serach-rem mb-3">
                            <div class="select top-space-rem after-drp form-float-style form-group">
                                <select name="api_method" id="api_method" class="select-text height_drp">
                                <option value="GET"<?php echo $apiDetails['api_method'] == 'GET' ? ' selected': ''; ?>>GET</option>
                                <option value="POST"<?php echo $apiDetails['api_method'] == 'POST' ? ' selected': ''; ?>>POST</option>
                                <option value="PUT"<?php echo $apiDetails['api_method'] == 'PUT' ? ' selected': ''; ?>>PUT</option>
                                <option value="DELETE"<?php echo $apiDetails['api_method'] == 'DELETE' ? ' selected': ''; ?>>DELETE</option>
                                </select>
                                <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">API Method <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>
                    <div class="form-item form-float-style form-group">
                        <input type="text" value="<?php echo $apiDetails['api_title']; ?>" id="api_title" name="api_title" autocomplete="off" class="is-valid">
                        <label for="api_title">API Title <span class="req-star">*</span></label>
                    </div>
                    <div class="form-item form-float-style form-group">
                        <input type="text" value="<?php echo $apiDetails['api_url']; ?>" id="api_url" name="api_url" autocomplete="off" class="is-valid">
                        <label for="api_title">API URL <span class="req-star">*</span></label>
                    </div>
                    <div class="form-floating form-float-style form-group required mb-3">
                        <div class="form-item form-float-style serach-rem mb-3">
                            <div class="select top-space-rem after-drp form-float-style form-group">
                                <select name="is_header_auth" id="is_header_auth" class="select-text height_drp">
                                <option value="yes"<?php echo $apiDetails['is_header_auth'] == 'yes' ? ' selected': ''; ?>>Yes</option>
                                <option value="no"<?php echo $apiDetails['is_header_auth'] == 'no' ? ' selected': ''; ?>>No</option>
                                </select>
                                <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Auth Header need? <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>
                    <div class="form-item form-float-style form-group">
                        <textarea name="request_payload" id="request_payload" rows="12" cols="50" style="height:350px;"><?php echo $apiDetails['request_payload']?></textarea>
                        <label for="request_payload">Request Payload<span class="req-star">*</span></label>
                    </div>
                    <div class="form-item form-float-style form-group">
                        <textarea name="success_response" id="success_response" rows="12" cols="50" style="height:350px;"><?php echo $apiDetails['success_response']?></textarea>
                        <label for="success_response">Success Response<span class="req-star">*</span></label>
                    </div>
                    <div class="form-item form-float-style form-group">
                        <textarea name="error_response" id="error_response" rows="8" cols="50" style="height:220px;"><?php echo $apiDetails['error_response']?></textarea>
                        <label for="error_response">Error Response<span class="req-star">*</span></label>
                    </div>
                    <div class="form-item form-float-style form-group">
                        <textarea name="description" id="description" rows="8" cols="50" style="height:220px;"><?php echo $apiDetails['description']?></textarea>
                        <label for="description">Description</label>
                    </div>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-md-12 discount">
                    <div class="cards-btn">
                        <button type="submit" class="btn btn-success form-btn-success">Submit</button>
                        <a href="{{ route('api-list.index') }}" class="btn btn-danger form-btn-danger">Cancel</a>
                    </div>
                </div>
            </div>
        </form>
      </div>
    </div>
  </div>
  </div>
  </div>
  </div>
  <!-- /.row -->
  </div>
  <!-- End Row Div -->

  </div>

  <!-- End container fluid -->
</section>
@endsection

@section('js')

@append
