@extends('admin.layout.app')
@section('title', @trans('login.title'))
<style>
  .swal2-close:focus {
    box-shadow: none !important;
  }

  /* Spinner Container */
  #loadingSpinner {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    z-index: 9999;
    color: #EE3137;
  }

  /* Spinner Centering */
  #loadingSpinner .overlay {
    position: absolute;
    top: 50%;
    left: 50%;
    transform: translate(-50%, -50%);
  }

  /* Spinner Size */
  .spinner-border {
    width: 4.5rem;
    height: 4rem;
    border-width: 5px;
  }
</style>

<!-- Toastr CSS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css" rel="stylesheet">



<!-- Loading Spinner -->

<div id="loadingSpinner">
  <div class="overlay">
    <div class="spinner-border" role="status" style="color: #EE3137;">
      <span class="visually-hidden">Loading...</span>
    </div>
  </div>
</div>


@section('content')
<div class="bg-clr">
  @if (session('success'))
  <div class="alert alert-success" role="alert">
    <?php echo session('success'); ?>
  </div>
  @endif
  @if (session('error'))
  <div class="alert alert-danger" role="alert">
    {{ session('error') }}
  </div>
  @endif
  @if (isset($error))
  <div class="alert alert-danger" role="alert">
    {{ $error }}
  </div>
  @endif
  <div class="logo-login">
    @php
    @$logo = App\Models\Setting::where('config_key', 'general|basic|colorLogo')->get('value')[0]['value'];
    @$value = App\Models\Setting::where('config_key', 'general|basic|siteName')->get('value')[0]['value'];
    @endphp
    <a href="{{ route('admin.login') }}">
      @if($logo)
      <!-- <img src="{{@$logo}}" alt=""> -->
      <img src="{{ URL::asset('assets/images/rehtle_logo.png') }}" alt="">
      @elseif($value)
      <h1>{{ $value }}</h1>
      @else
      <img src="{{ URL::asset('assets/images/rehtle_logo.png') }}" alt="">
      @endif
    </a>
  </div>
  <h2>@lang('login.loginHeading')</h2>

  <form action="{{ route('adminLogin') }}" method="post" class="form row mx-0 validate" name="loginForm" id="loginForm">
    @csrf



    <!--Errors variable used from form validation -->
    @if($errors->any())
    <div class="alert alert-light text-danger">
      <ul>
        @foreach($errors->all() as $error)
        <li class="text-red">{{ $error }}</li>
        @endforeach
      </ul>
    </div>
    @endif

    <div class="login-page p-0">
      <div class="form-item form-float-style form-group">
        <input type="text" id="login_mobileno" class="is-valid" name="mobile" autocomplete="off" required>
        <label for="login_mobileno">Email Address</label>
      </div>


      <!-- Send OTP Button -->
      <div class="form-item form-float-style form-group">
        <button type="button" class="btn btn-danger" id="send-otp-btn" onclick="sendOTP()">Send OTP</button>
      </div>

      <!-- OTP Login method -->
      <div class="form-item form-float-style form-group">
        <input type="text" id="otp_code" class="is-valid" name="otp_code" autocomplete="off" required>
        <label for="otp_code">Enter OTP</label>
        <span id="otp-error" class="text-danger" style="display:none;">Please enter a valid OTP.</span>
      </div>



      <!-- Resend OTP Button
        <div class="form-item form-float-style form-group" style="display:none;" id="resend-otp-container">
            <button type="button" class="btn btn-secondary" id="resend-otp-btn" onclick="resendOTP()">Resend OTP</button>
            <span id="otp-timer">You can resend OTP in <span id="countdown"></span> seconds.</span>
        </div> -->

      <div class="g-recaptcha mt-4" data-sitekey={{config('services.recaptcha.key')}}></div>

      <div class="form-check filter-check sub-check mt-2">
        <input class="form-check-input" type="checkbox" id="flexCheckDefault1">
        <label class="form-check-label" for="flexCheckDefault1">
          @lang('login.rememberMe')
        </label>
      </div>
    </div>

    @if(session()->has('error'))
    <div class="row mt-3">
      <div class="col-md-12 text-center alert alert-light text-danger" role="alert">
        {{ session()->get('error') }}
      </div>
    </div>
    @endif
    @if (session('login-success'))
    <div class="row mt-3">
      <div class="col-md-12 alert alert-success" role="alert">
        <button class="close" data-dismiss="alert">x</button>
        {{ session('login-success') }}
      </div>
    </div>
    @endif

    <div class="login-bottom">
      <button type="submit" class="btn login-btn">@lang('login.login')</button>
      <a href="{{ route('admin.forgot-password') }}" type="submit" class="btn forgot-btn">@lang('login.forgotPassword')</a>
    </div>
  </form>
  <!-- Toastr JS -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>



  <!-- Bootstrap Modal -->
  <div class="modal fade" id="messageModal" tabindex="-1" aria-labelledby="messageModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="messageModalLabel">Message Title</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <p id="messageModalBody">Message content goes here.</p>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>

  <script>
    // Function to show the modal with a dynamic message
    function showMessageModal(type, title, message) {
      // Update modal title and body
      const modalTitle = document.getElementById('messageModalLabel');
      const modalBody = document.getElementById('messageModalBody');

      // Set title and message
      modalTitle.innerText = title;
      modalBody.innerText = message;

      // Add dynamic classes based on the type (success, error, etc.)
      const modalHeader = document.querySelector('.modal-header');
      modalHeader.classList.remove('bg-success', 'bg-danger', 'bg-info', 'bg-warning');
      modalHeader.classList.add(
        type === 'success' ? 'bg-success' :
        type === 'error' ? 'bg-danger' :
        type === 'info' ? 'bg-info' :
        type === 'warning' ? 'bg-warning' : ''
      );

      // Show the modal
      const messageModal = new bootstrap.Modal(document.getElementById('messageModal'));
      messageModal.show();
    }


    toastr.options = {
      "closeButton": true,
      "debug": false,
      "newestOnTop": false,
      "progressBar": true,
      "positionClass": "toast-top-right", // Position of the toast
      "preventDuplicates": true,
      "onclick": null,
      "showDuration": "300", // Show animation duration in ms
      "hideDuration": "1000", // Hide animation duration in ms
      "timeOut": "5000", // Duration for which the toast is visible
      "extendedTimeOut": "1000"
    };

    let otpSent = false;
    let countdownTimer;
    let countdownTime = 60;

    function sendOTP() {
      const mobile = document.getElementById('login_mobileno').value;

      // Validate email address
      const emailRegex = /\b[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b/i;
      if (!mobile || !emailRegex.test(mobile)) {
        showMessageModal('error', 'Error', 'Please enter a valid email address.');
        return;
      }

      // Show the spinner
      document.getElementById('loadingSpinner').style.display = 'block';

      // Send AJAX request to send OTP to the backend
      $.ajax({
        url: "{{ route('send.otp') }}", // Laravel route to send OTP
        type: "POST",
        data: {
          _token: "{{ csrf_token() }}", // CSRF token for security
          mobile: mobile
        },
        success: function(response) {
          // Hide the spinner
          document.getElementById('loadingSpinner').style.display = 'none';

          if (response.success) {
            showMessageModal('success', 'Success', 'OTP has been sent to your email.');
            otpSent = true;
            document.getElementById('resend-otp-container').style.display = 'block';
            startCountdown();
          } else {
            showMessageModal('error', 'Error', 'No users found with this email address.');
          }
        },
        error: function(xhr, status, error) {
          // Hide the spinner
          document.getElementById('loadingSpinner').style.display = 'none';

          showMessageModal('error', 'Error', 'An error occurred while sending the OTP. Please try again.');
        }
      });
    }


    // function resendOTP() {
    //     if (!otpSent) {
    //         sendOTP();
    //     } else {
    //         showMessageModal('warning', 'Warning', 'You can only resend the OTP after the countdown.');
    //     }
    // }

    // Countdown timer function
    function startCountdown() {
      countdownTimer = setInterval(function() {
        document.getElementById('countdown').innerText = countdownTime;
        countdownTime--;

        if (countdownTime < 0) {
          clearInterval(countdownTimer);
          document.getElementById('resend-otp-btn').disabled = false;
          document.getElementById('countdown').innerText = "00";
        }
      }, 1000);

      document.getElementById('resend-otp-btn').disabled = true; // Disable resend button during countdown
    }

    // Function to validate OTP
    function validateOTP() {
      const otp = document.getElementById('otp_code').value;

      if (!otp || otp.length !== 6 || isNaN(otp)) {
        toastr.error("Please enter a valid OTP.", "Error");
        return false;
      }

      return true;
    }

    // jQuery form validation
    $(function() {
      $.validator.addMethod("email_regex", function(value, element, regexpr) {
        return this.optional(element) || regexpr.test(value);
      }, "Please enter a valid Email Address.");

      $('#loginForm').validate({
        rules: {
          mobile: {
            required: true,
            email: true,
            email_regex: /\b[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b/i
          },
          otp_code: {
            required: true,
            minlength: 6,
            maxlength: 6,
            digits: true
          }
        },
        messages: {
          mobile: {
            required: "Please enter an Email Address",
          },
          otp_code: {
            required: "Please enter the OTP",
            minlength: "OTP must be 6 digits",
            maxlength: "OTP must be 6 digits",
            digits: "OTP must only contain numbers"
          }
        },
        errorElement: 'span',
        errorPlacement: function(error, element) {
          error.addClass('invalid-feedback');
          element.closest('.form-group').append(error);
        },
        highlight: function(element, errorClass, validClass) {
          $(element).addClass('is-invalid');
        },
        unhighlight: function(element, errorClass, validClass) {
          $(element).removeClass('is-invalid');
        }
      });
    });
  </script>

  <script async src="https://www.google.com/recaptcha/api.js"></script>

  @endsection