@extends('admin.layout.main')


@section('content')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.5/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.min.css">
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<link href="
https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.css
" rel="stylesheet">
<style>
    .dt-input {
        font-size: 14px;
        /* Optional: smaller label */
    }

    .dt-search input {
        width: 200px;
        height: 40px;
        padding: 3px 5px;
        font-size: 14px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }

    div.dataTables_filter {
        text-align: right;
        margin-bottom: 10px;
    }

    div.dataTables_filter input {
        width: 200px !important;
        display: inline-block;
    }

    #log_filter_form .form-group {
        margin-bottom: 10px;
    }

    #log_filter_form .form-control {
        padding: 5px 10px;
    }

    #log_filter_form {
        margin-bottom: 15px;
    }

    #log_filter_form .card-footer {
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }

    .dataTables_wrapper .row {
        margin: 0;
    }

    .table thead th {
        white-space: nowrap;
        background-color: #343A40;
        color: white;
        text-align: center;
    }

    .table tbody tr td {
        font-size: 14px;
    }
</style>


<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-9 d-flex breadcrumb-style">
                <h1 class="m-0">Booking Customer Logs</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="#">Booking Customer Logs</a></li>
                </ol>
            </div><!-- /.col -->
            <div class="col-sm-3 d-flex breadcrumb-style">
                <div class="breadcrumb-btn">
                    <button class="btn btn-primary" id="show-hide-filters">
                        Show Filters
                    </button>&nbsp;
                </div>
            </div><!-- /.col -->

        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="col-md-12 filter-container d-none">
    <!-- general form elements -->
    <div class="card card-primary">
        <!-- form start -->
        <form id="log_filter_form">
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label style="color:black">Customer Name</label>
                            <input type="text" class="form-control is-valids" name="customer_name" id="customer_name" value="  " class="is-valid" placeholder="Enter Customer Name" autocomplete="off" style="color: white;">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <!-- select -->
                        <div class="form-group">
                            <label style="color:black">Select Service Name</label>
                            <select class="form-control" id="booking_type" name="booking_type" style="color: white;">
                                <option value="" style="color: white;">Select Service Name</option>
                                <option value="Hotel" style="color: white;">Hotel</option>
                                <option value="Flight" style="color: white;">Flight</option>

                            </select>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <!-- select -->
                        <div class="form-group">
                            <label style="color:black">Select Status</label>
                            <select class="form-control" id="status" name="status" style="color: white;">
                                <option value="" style="color: white;">Select Status</option>
                                <option value="confirmed" style="color: white;">Confirmed</option>
                                <option value="reached_payment" style="color: white;">Incomplete Booking</option>
                                <option value="failed" style="color: white;">Failed Booking</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label style="color:black">Select Date</label>
                            <input type="date" class="form-control is-valids" name="date" id="date" value="  " class="is-valid" placeholder="" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label style="color:black">From Price Range</label>
                            <input type="text" class="form-control is-valids" name="from_price" id="from_price" value="  " class="is-valid" placeholder="" autocomplete="off">
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label style="color:black">To Price Range</label>
                            <input type="text" class="form-control is-valids" name="to_price" id="to_price" value="  " class="is-valid" placeholder="" autocomplete="off">
                        </div>
                    </div>

                </div>
            </div>
            <div class="card-footer">
                <button type="button" id="search" class="btn btn-primary float-right" style="margin-left: 5px;">
                    <span class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true" id="search-spinner"></span>
                    Search
                </button>

                <button type="button" id="clear" class="btn btn-warning float-right">Clear</button>
            </div>
        </form>
    </div>
</div>
<section class="content">
    <div class="container-fluid">

        <div class="row">
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="bookingLogTable">

                    <thead>
                        <th>S.No</th>
                        <th>Service Name</th>
                        <th>Customer Name</th>
                        <th>Email</th>
                        <th>Contact No</th>
                        <th>Amount</th>
                        <th>Status</th>
                        <th>Created At</th>
                        <th>View</th>
                    </thead>

                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>

@endsection
@section('js')
<script src="https://code.jquery.com/jquery-3.7.1.js"></script>
<script src="https://cdn.datatables.net/2.2.2/js/dataTables.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script>
    $(document).ready(function() {
        var bookingTable = $('#bookingLogTable').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("admin.get-booking-logs") }}',
                method: 'GET',
                data: function(d) {

                    console.log(d);
                    d.customer_name = $('#customer_name').val().trim();
                    d.booking_type = $('#booking_type').val().trim();
                    d.status = $('#status').val();
                    d.from_price = $('#from_price').val();
                    d.to_price = $('#to_price').val();
                    d.date = $('input[name="date"]').val();
                }
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    title: 'S.No',
                    orderable: false,
                    searchable: false,
                },
                {
                    data: 'booking_type',
                    name: 'booking_type'
                },
                {
                    data: 'customer_id',
                    name: 'customer_id'
                },
                {
                    data: 'email',
                    name: 'email'
                },
                {
                    data: 'phone_no',
                    name: 'phone_no'
                },
                {
                    data: 'amount',
                    name: 'amount'
                },
                {
                    data: 'status',
                    name: 'status'
                },
                {
                    data: 'created_at',
                    name: 'created_at'
                },
                {
                    data: 'id',
                    name: 'id'
                },
            ],
            drawCallback: function(settings) {
                $('#search-spinner').addClass('d-none');
                $('html, body').animate({
                    scrollTop: $('#bookingLogTable').offset().top - 100
                }, 'slow');
            }
        });

        // Search button: re-fetch with current filters
        $('#search').on('click', function() {
            $('#search-spinner').removeClass('d-none');
            bookingTable.ajax.reload();
        });

        // Clear button: reset form and reload table
        $('#clear').on('click', function() {
            $('#log_filter_form')[0].reset(); // Reset form
            bookingTable.ajax.reload();
        });
    });
</script>
<script>
    $(function() {
        $('input[type="date"]').datepicker({
            dateFormat: 'yy-mm-dd'
        });
    });
    $(document).ready(function() {


        $('#show-hide-filters').on('click', function() {
            //table.draw();
            if ($('.filter-container').hasClass("d-none")) {
                $('.filter-container').removeClass("d-none");
                $('#show-hide-filters').html('Hide Filters');
            } else {
                $('.filter-container').addClass("d-none");
                $('#show-hide-filters').html('Show Filters');
            }
        });
    });
</script>
@endsection