@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')


<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" />
<style>
    .form-item input.is-valids+label {
        font-size: 11px;
        top: -5px;
    }

    .list-group a:hover {
        background-color: #335476 !important;
        color: white !important;
    }

    input[readonly] {
        background-color: #f5f5f5;
        color: #999;

        cursor: not-allowed;
    }

    .dataTables_filter label {
        font-size: 14px;
    }

    .dataTables_filter input {
        width: 200px;
        height: 40px;
        padding: 3px 5px;
        font-size: 14px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }
</style>
<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
                <h1 class="m-0">Booking Status Logs</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="/booking ">Booking</a></li>
                    <li class="breadcrumb-item active">Booking Status Log</li>
                </ol>
            </div><!-- /.col -->

        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">

        <table class="table table-striped table-bordered" id="booking_status_table">
            <thead>
                <tr>
                    <th style="background-color: #343A40; color: white;">S.No</th>
                    <th style="background-color: #343A40; color: white;">Rehlte Trip ID</th>
                    <th style="background-color: #343A40; color: white;">Booking Status</th>
                    <th style="background-color: #343A40; color: white;">Description</th>
                    <th style="background-color: #343A40; color: white;">Modified By</th>
                    <th style="background-color: #343A40; color: white;">Created At</th>
                </tr>
            </thead>

            <tbody>

            </tbody>
        </table>



        <!-- /.row -->
    </div>
    <!--/. container-fluid -->

    @endsection

    @section('js')




    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

    <script>
        $(document).ready(function() {


            $('#booking_status_table').DataTable({
                "processing": true,
                "serverSide": true,
                "ajax": {
                    "url": "{{ route('admin.booking_status_log', $booking_id) }}",
                    "type": "GET"
                },

                "columns": [{
                        data: null,
                        name: "serial_no",
                        render: function(data, type, row, meta) {
                            return meta.row + 1;
                        }
                    },
                    {
                        data: 'booking_id',
                        name: 'booking_id'
                    },
                    {
                        data: 'booking_status',
                        name: 'booking_status'
                    },
                    {
                        data: 'booking_status_description',
                        name: 'booking_status_description'
                    },
                    {
                        data: 'modified_by',
                        name: 'modified_by'
                    },
                    {
                        data: 'created_at',
                        name: 'created_at'
                    },
                ]

            });
        });
    </script>
    @endsection

    @section('js')