<html lang="en">

<head>
  <meta charset="UTF-8">
  <title>Invoice Template</title>

  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">

  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.1/css/all.min.css" integrity="sha512-5Hs3dF2AEPkpNAR7UiOHba+lRSJNeM2ECkwxUIxC1Q/FLycGTbNapWXB4tP889k5T5Ju8fs4b1P5z/iB4nMfSQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />


  <style>
    @import url(https://fonts.googleapis.com/css?family=Roboto:100,300,400,900,700,500,300,100);

    * {
      margin: 0;
      box-sizing: border-box;

    }


    @media all {
      .page-break {
        display: block;
        page-break-after: always;
        clear: both;
      }
    }

    @media print {
      .print-content {
        width: 100%;
        margin: 27px;
      }

      .page-break {
        display: block;
        page-break-before: always;
        clear: both;
      }
    }

    body {
      background: #E0E0E0;
      font-family: 'Roboto', sans-serif;
      background-image: url('');
      background-repeat: repeat-y;
      background-size: 100%;
    }

    ::selection {
      background: #f31544;
      color: #FFF;
    }

    ::moz-selection {
      background: #f31544;
      color: #FFF;
    }

    h1 {
      font-size: 1.5em;
      color: #222;
    }

    h2 {
      font-size: .9em;
    }

    h3 {
      font-size: 1.2em;
      font-weight: 300;
      line-height: 2em;
    }

    p {
      font-size: .7em;
      color: #666;
      line-height: 1.2em;
    }

    #invoiceholder {
      width: 100%;
      hieght: 100%;
      padding-top: 50px;
    }

    #headerimage {
      z-index: -1;
      position: relative;
      top: -50px;
      height: 350px;

      background-attachment: fixed;
      background-size: 1920px 80%;
      background-position: 50% -90%;
    }

    #invoice {
      position: relative;
      top: -290px;
      margin: 0 auto;
      width: 700px;
      background: #FFF;
    }

    [id*='invoice-'] {
      /* Targets all id with 'col-' */
      border-bottom: 1px solid #EEE;
      padding: 30px;
    }

    #invoice-top {
      min-height: 120px;
    }

    #invoice-mid {
      min-height: 120px;
    }

    #invoice-bot {
      min-height: 250px;
    }

    .logo {
      width: 60px;
      height: 60px;
      background-size: cover;
      display: inline-block;
      vertical-align: middle;
    }


    .info {
      display: block;
      float: left;
      margin-left: 20px;
    }

    .title {
      float: right;
    }

    .title p {
      text-align: right;
    }

    #project {
      margin-left: 52%;
    }

    table {
      width: 100%;
      border-collapse: collapse;
    }

    td {
      padding: 5px 0 5px 15px;
      border: 1px solid #EEE
    }

    .tabletitle {
      padding: 5px;
      background: #fff;
    }

    .service {
      border: 1px solid #EEE;
    }

    .item {
      width: 50%;
    }

    .itemtext {
      font-size: 15px;
    }

    #legalcopy {
      margin-top: 30px;
    }

    form {
      float: right;
      margin-top: 30px;
      text-align: right;
    }


    .effect2 {
      position: relative;
    }

    .effect2:before,
    .effect2:after {
      z-index: -1;
      position: absolute;
      content: "";
      bottom: 15px;
      left: 10px;
      width: 50%;
      top: 80%;
      max-width: 300px;
      background: #777;
      -webkit-box-shadow: 0 15px 10px #777;
      -moz-box-shadow: 0 15px 10px #777;
      box-shadow: 0 15px 10px #777;
      -webkit-transform: rotate(-3deg);
      -moz-transform: rotate(-3deg);
      -o-transform: rotate(-3deg);
      -ms-transform: rotate(-3deg);
      transform: rotate(-3deg);
    }

    .effect2:after {
      -webkit-transform: rotate(3deg);
      -moz-transform: rotate(3deg);
      -o-transform: rotate(3deg);
      -ms-transform: rotate(3deg);
      transform: rotate(3deg);
      right: 10px;
      left: auto;
    }


    .legal {
      width: 70%;
    }

    .info p {
      line-height: 1.4;
      margin-bottom: 5px;
      font-size: 12px !important;
    }

    .title h1 {
      font-size: 40px;
      font-weight: 800;
    }

    .title h1.first {
      color: #005C8B;
      line-height: 28px;
    }

    .title h1.second {
      color: #CC0000;
      line-height: 47px;
    }

    #invoice-top {
      margin: 0 auto;
      padding: 15px;
      border: none;
    }

    #invoice-top hr {
      color: #253D34;
      height: 3px;
    }


    thead {
      white-space: nowrap;
    }

    th,
    td {
      font-size: 15px;
    }

    .guest p {
      color: #121212;
      font-weight: 400;
      font-size: 18px;
    }

    .guest h2 {
      color: #005C8B;
      font-size: 18px;
      font-weight: 700;

    }

    .clr_cls {
      color: #005C8B;
    }

    .table-bordered {
      border-color: none;
    }

    .table-bordered td,
    .table-bordered th {
      border: none;
    }

    .table-bordered>:not(caption)>* {
      border: none;
    }

    .prod {
      padding: 20px;
      border-radius: 9px;
      border: 1px solid #E9EAEC;
    }

    .prod img {
      width: 180px;
      height: 170px;
      border-radius: 9px;
    }

    .prod p {
      color: #7E8389;
      font-size: 12px;
      margin-bottom: 1;
    }

    .prod button {
      border-radius: 5px;
      color: #7E8389;
      font-size: 14px;
      font-weight: 500;
      border: 1px solid #f0f0f0;
      padding: 5px 12px;
      line-height: 1;
    }

    li {
      color: #7E8389;
      margin-bottom: 10;
    }

    .tabletitle {

      border-bottom: 1px solid #000;

    }



    .user_info {
      margin-bottom: 100px;
    }

    .user_info p {
      line-height: 1.6em;
      font-size: 17px;
      color: #050505;
      margin-bottom: 25;

    }

    .no-border,
    .no-border td,
    tfoot {
      border: none;
    }

    td strong,
    td {
      font-size: 13px;
    }

    tfoot {
      white-space: nowrap;
    }

    .qr-footer {
      border: 1px dotted #000;

    }
  </style>

  <script>
    window.console = window.console || function(t) {};
  </script>



</head>

<body translate="no">


  <?php

  $booking_detailsArrdata = json_decode($bookingDetail->booking_details);
  $booking_detailsArr = json_decode($bookingDetail->service_provider_response);
  $booking_detailsArr = $booking_detailsArr->booking;
  $roomsArr = $booking_detailsArr->hotel->rooms;

  $hotel_details = $booking_detailsArrdata->hotelDetails;
  $hotel_name = $hotel_details->hotelDetails->name->content;
  $hotel_image = $hotel_details->hotelDetails->image->original;

  $payment_details = $booking_detailsArrdata->processedPrice;


  //   print_r($payment_details);


  $checkoutdate = strtotime($booking_detailsArr->hotel->checkOut);
  $checkindate = strtotime($booking_detailsArr->hotel->checkIn);
  $datediff = $checkoutdate - $checkindate;

  $numberofdatyes =  round($datediff / (60 * 60 * 24));
  $adult = 0;
  $child = 0;
  $room = 0;
  $roomtype = "";
  $boardName = "";
  $rateCommment = "";
  $childAges = "";

  foreach ($roomsArr as $rkey => $rvalue) {
    $roomtype .= $rvalue->name . '  ';
    $ratesArr = $rvalue->rates;
    foreach ($ratesArr as $rakey => $ravalue) {

      $adult += $ravalue->adults;
      $child += $ravalue->children;
      $room += $ravalue->rooms;
      $boardName .= $ravalue->boardName . "  ";
      $rateCommment .= $ravalue->rateComments . "  ";
    }
  }


  // Accessing occupancies
  $occupancies = $booking_detailsArrdata->hotelDetails->searchDetails->occupancies;

  foreach ($occupancies as $index => $occupancy) {
    $rooms = $occupancy->rooms;
    $adults = $occupancy->adults;
    $children = $occupancy->children;
    $quantity = $adults + $children;
  }



  $occupancyD = $booking_detailsArrdata->hotelDetails->searchDetails->occupancies;
  if ($occupancyD) {
    foreach ($occupancyD as $key => $value) {
      if ($value->children > 0) {
        $paxesAge = $value->paxes;
        if ($paxesAge) {
          foreach ($paxesAge as $pkey => $pvalue) {
            $childAges .= "Child " . ($pkey + 1) . ":: Age " . $pvalue->age;
          }
        }
      }
    }
  }

  $phone = '';
  $phoneArr = $booking_detailsArrdata->hotelDetails->hotelDetails->phones;
  if ($phoneArr) {
    foreach ($phoneArr as $key => $value) {
      $phone .= $value->phoneNumber;
      break;
    }
  }






  ?>

  <div id="invoiceholder">

    <div id="headerimage"></div>
    <div id="invoice" class="effect2">

      <div id="invoice-top" class="row">
        <!-- Logo Section -->
        <div class="col-md-3">
          <div class="logo">

            <img src="{{ URL::asset('assets/images/rehtle_logo.png') }}" alt="Logo">

          </div>
        </div>

        <div class="col-md-5">
          <div class="info">
            <h2 class="mb-1 fs-5">Rehlte For Tourism LLC</h2>

            <p><strong>Address:</strong> Abu Bakr Siddiq Road, Al Nahdah District, Buraydah, Saudi Arabia 52389</p>
            <p><strong>Country:</strong> KSA</p>
            <p><strong>Email:</strong> Operations@Rehlte.com</p>
          </div>
        </div>

        <div class="col-md-4">
          <div class="title">
            <h1 class="first">Tax</h1>
            <h1 class="second">Invoice</h1>
          </div>
        </div>

        <div class="col-md-6 guest mt-5">
          <p class="mb-1">Lead Customer Name</p>
          <h2 class="mb-1">{{ $booking_detailsArr->holder->name}} &nbsp;&nbsp;{{ $booking_detailsArr->holder->surname}}</h2>
          <div class="cus_box">
            <table class="table table-bordered table-sm">
              <tbody>
                <!-- <tr>
                    <td>Booking Reference:</td>
                    <td>{{ $bookingDetail->supplier_booking_associated_ref}}  </td>
                </tr> -->
              </tbody>
            </table>
          </div>
        </div>

        <div class="col-md-6 guest mt-5">
          <div class="cus_box">
            <table class="table table-bordered table-sm">
              <tbody>
                <tr>
                  <td><strong>Booking Reference:</strong></td>
                  <td>{{ $bookingDetail->supplier_booking_associated_ref}} </td>
                </tr>
                <tr>
                  <td><strong>Hotel Confirmation No:</strong></td>
                  <td>{{ $bookingDetail->booking_ref}}</td>
                </tr>
                <tr>
                  <td><strong>Print Date:</strong></td>
                  <td> <?php echo date("d/m/Y"); ?></td>
                </tr>

                <tr>
                  <td><strong>Net Amount:</strong></td>
                  <td> {{$booking_detailsArr->hotel->totalNet}} SAR</td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>



        <div class="col-md-12">


          <table class="table mt-5 invoice_table">
            <thead>
              <tr class="tabletitle">
                <th class="text-left">Hotel Name</th>
                <th class="text-center">Address</th>

                <th class="text-center">Category</th>
                <th class="text-center">Check In</th>
                <th class="text-center">Check Out</th>
              </tr>
            </thead>
            <tbody>
              <tr class="no-border">
                <td class="text-left">
                  <p class="itemtext">{{ $hotel_name }}</p>
                </td>
                <td class="text-center">
                  <p class="itemtext">{{ $booking_detailsArrdata->hotelDetails->hotelDetails->address->street }} </p>
                </td>

                <td class="text-center">
                  <p class="itemtext"> {{ $booking_detailsArrdata->hotelDetails->hotelDetails->categoryName   }} </p>
                </td>
                <td class="text-center">
                  <p class="itemtext">{{ $booking_detailsArrdata->hotelDetails->searchDetails->stay->checkIn }}</p>
                </td>
                <td class="text-center">
                  <p class="itemtext">{{ $booking_detailsArrdata->hotelDetails->searchDetails->stay->checkOut }}</p>
                </td>
              </tr>

            </tbody>
          </table>



          <!--  -->

          <table class="table mt-5 invoice_table">
            <thead>
              <tr class="tabletitle">
                <th class="text-left">Service</th>
                <th class="text-center">Hotel Name</th>
                <th class="text-center">Customer Name</th>
                <th class="text-center">Quantity</th>
                <!-- <th class="text-center">Ticket No.</th> -->
                <th class="text-center">Amount</th>
              </tr>
            </thead>
            <tbody>
              <tr class="no-border">
                <td class="text-left">
                  <p class="itemtext">1</p>
                </td>
                <td class="text-center">
                  <p class="itemtext"> {{ $hotel_name }}</p>
                </td>
                <td class="text-center">
                  <p class="itemtext"> {{ $booking_detailsArr->holder->name}} &nbsp;&nbsp;{{ $booking_detailsArr->holder->surname}} </p>
                </td>
                <td class="text-center">
                  <p class="itemtext"> {{ $quantity   }} </p>
                </td>
                <!-- <td class="text-center">
                  <p class="itemtext">{{ $childAges }}</p>
                </td> -->
                <td class="text-center">
                  <p class="itemtext">{{ $booking_detailsArrdata->processedPrice->grandTotal }}</p>
                </td>
              </tr>

            </tbody>
            <tfoot>

              <tr class="no-border">

                <td colspan="4">Grant Total :</td>
                <td>Subtotal</td>
                <td> {{ $booking_detailsArrdata->processedPrice->currency }} {{ $booking_detailsArrdata->paymentDetails->subTotal }} </td>
              </tr>

              <tr class="no-border">

                <td colspan="4">{{ rupeesToWords($booking_detailsArrdata->processedPrice->grandTotal) }}</td>
                <td>VAT {{ $booking_detailsArrdata->processedPrice->vatPercentage }} %</td>
                <td> {{ $booking_detailsArrdata->processedPrice->currency }} {{ $booking_detailsArrdata->processedPrice->vat }} </td>
              </tr>


              <tr class="no-border">
                <td colspan="4"></td>
                <td>ServiceFee </td>
                <td>{{ $booking_detailsArrdata->processedPrice->currency }} {{ $booking_detailsArrdata->processedPrice->serviceFee }}</td>
              </tr>

              <tr class="no-border bg-gry">
                <td colspan="4"></td>
                <td>Grand Total </td>
                <td>{{ $booking_detailsArrdata->processedPrice->currency }} {{ $booking_detailsArrdata->processedPrice->grandTotal }}</td>
              </tr>



            </tfoot>
          </table>

          <!-- End of Table Invoice Content -->





        </div>


        <div class="col-md-12">

          <div class="row mb-5">

            <div class="col-md-8">
              <table class="tbNoBorder" border="0" width="100%" class="tbNoBorder">
                <thead>
                  <tr>
                    <td align="center" colspan="3" class="main-section tbNoBorder"><b>Supplier notes</b></td>

                  </tr>
                </thead>

                <tbody>
                  <tr>

                    <td align="left" class="value tbNoBorder ">
                      <p style="text-align: justify; padding:5px"><b class="phrase tbNoBorder">Dear Traveller,</b><br> The common check-in and check-out time at hotels varies depending on the
                        hotel’s policies, but generally you can check in after 2 PM and check out until
                        12 PM. These are the most common times for hotel check-in and check-out,
                        but you should always read through the rules of the hotel you’re staying at
                        and see the exact times they have listed.Some hotels may offer flexible check-in and check-out options, such as
                        self-check-in kiosks, mobile check-in apps, or setting your own times for an
                        extra fee. These options can help you avoid waiting in line at the front desk
                        or accommodate your travel schedule better.
                        If you arrive early or want to leave late, you can ask the hotel staff if they
                        can store your luggage for you or if they have any rooms available for early
                        check-in or late check-out. However, this may depend on the availability of
                        rooms and the hotel’s occupancy rate. Some hotels may charge you extra for
                        early check-in or late check-out, so be sure to check their policies before you
                        request them</p>
                    </td>


                  </tr>
                </tbody>


              </table>
            </div>

            <div class="col-md-2">
              <img src="{{ URL::asset('assets/images/footerlogo.png') }}" alt="Logo">
            </div>


            <div class="col-md-10">

            </div>

            <div class="col-md-2">
              <div class="qr-footer">
                <img src="{{ URL::asset('assets/images/qr.png') }}" alt="Logo">
              </div>
            </div>

          </div>

        </div>

      </div><!--End InvoiceTop-->




    </div><!--End Invoice-->
  </div><!-- End Invoice Holder-->



  <script>
    let map, infoWindow;

    function initMap() {
      map = new google.maps.Map(document.getElementById("map"), {
        center: {
          lat: -34.397,
          lng: 150.644
        },
        zoom: 6,
      });
      infoWindow = new google.maps.InfoWindow();

      const locationButton = document.createElement("button");

      locationButton.textContent = "Pan to Current Location";
      locationButton.classList.add("custom-map-control-button");
      map.controls[google.maps.ControlPosition.TOP_CENTER].push(locationButton);
      locationButton.addEventListener("click", () => {
        if (navigator.geolocation) {
          navigator.geolocation.getCurrentPosition(
            (position) => {
              const pos = {
                lat: position.coords.latitude,
                lng: position.coords.longitude,
              };

              infoWindow.setPosition(pos);
              infoWindow.setContent("Location found.");
              infoWindow.open(map);
              map.setCenter(pos);
            },
            () => {
              handleLocationError(true, infoWindow, map.getCenter());
            }
          );
        } else {
          handleLocationError(false, infoWindow, map.getCenter());
        }
      });
    }

    function handleLocationError(browserHasGeolocation, infoWindow, pos) {
      infoWindow.setPosition(pos);
      infoWindow.setContent(
        browserHasGeolocation ?
        "Error: The Geolocation service failed." :
        "Error: Your browser doesn't support geolocation."
      );
      infoWindow.open(map);
    }

    window.initMap = initMap;
  </script>

  <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCza1K-e_ZzydOuHY6nvJQUfkP7SOihZPA&callback=initMap" async defer></script>
</body>

</html>