<html lang="en">

<head>
  <meta charset="UTF-8">
  <title>Voucher</title>
  @include('admin.booking.includes.styles.voucher')
</head>

<body translate="no" style="margin:0; padding:0; background:#dce4f9;">


  @php


  if ($editedHotelDetails) {
  $editedHotelDetails = json_decode($editedHotelDetails);
  $editedBookingDetails = json_decode($editedHotelDetails[0]->booking_details);
  $userDetails = $editedBookingDetails->userDetails;
  $searchDetails = $editedBookingDetails->searchDetails;
  $hotelDetails = $editedBookingDetails->hotelDetails;
  $checkindate = strtotime($searchDetails->checkInDate ?? $searchDetails->stay->checkIn);
  $checkoutdate = strtotime($searchDetails->checkOutDate ?? $searchDetails->stay->checkOut);
  $cancellationPolicies = $hotelDetails->cancellationPolicy ?? [];
  $datediff = $checkoutdate - $checkindate;
  $numberofdays = round($datediff / (60 * 60 * 24));
  $adult = 0;
  $child = 0;
  $room = 0;
  $roomtype = "";
  $boardName = "";
  $rateCommment = "";
  $childAges = "";

  $occupancyD = $searchDetails->occupancies;

  $adult = $occupancyD[0]->adults ?? 0;
  $child = $occupancyD[0]->children ?? 0;
  $hotel_image = $hotelDetails->hotelDetails->Photos[0] ?? ($hotelDetails->hotelDetails->DefaultImage->FullSize ?? '');

  }


  @endphp


  <div class="voucher-frame">
    <!-- <div id="invoiceholder"> -->


    <!-- <div id="invoice" class=""> -->

    <div id="invoice-top" class="row">


      <table>
        <tr>
          <!-- Logo Section -->
          <td>
            <div class="col-md-3">
              <div class="logo">

                @if($invoiceSettings && isset($invoiceSettings->logo_en))
                <img src="{{ asset('storage/'.$invoiceSettings->logo_en) }}" alt="Logo">
                @else
                <img src="{{ URL::asset('assets/images/rehtle_logo.png') }}" alt="Logo">
                @endif

              </div>
            </div>
          </td>


          <td>
            <div class="col-md-5">
              <div class="info">
                <h1 class="mb-1 fs-6" style="color: black; font-weight:400">{{ $invoiceSettings->title_en ?? 'Rehlte For Tourism LLC' }}</h1>

                <p><strong>Address:</strong> {{ $invoiceSettings->address_en ?? 'Abu Bakr Siddiq Road, Al Nahdah District, Buraydah, Saudi Arabia 52389' }}</p>
                <p><strong>Country:</strong> {{ $invoiceSettings->city_en ?? 'KSA'  }}</p>
                <p><strong>Email:</strong> {{ $invoiceSettings->email ?? 'support@rehlte.com' }}</p>
              </div>
            </div>
          </td>

          <td>
            <div class="col-md-4">
              <div class="title">
                <h1 class="first">Hotel</h1>
                <h1 class="second">Voucher</h1>
              </div>
            </div>
          </td>

        </tr>
      </table>

      <table>
        <tr>
          <td>
            <div class="col-md-12">
              <hr style="border: 1px solid black;">
            </div>
          </td>
        </tr>
      </table>


      <table style="width:100%; border-collapse:collapse;">
        <tr>
          <td style="vertical-align: top; padding:0;">
            <div class="guest" style="padding-left:0;">

              <p style="margin:0; font-weight:500;">Guest Name</p>

              <h2 style="margin-top:15px; margin-left:0;">
                {{ ucwords($userDetails->title ?? '') }} {{ $userDetails->firstName ?? '' }} &nbsp;{{ $userDetails->lastName ?? ''}}
              </h2>

              <div class="cus_box" style="margin-top:20px; margin-left:0;">

                <h5 class="clr_cls mt-4" style="font-weight:700; color:#2b79a0; margin-left:0;">
                  Booking Voucher - Hotel
                </h5>

                <table class="table table-bordered table-sm" style="margin-left:0; width:100%; border-collapse:collapse;">
                  <tbody>
                    <tr>
                      <td style="font-weight:600;">Booking Reference:</td>
                      <td>{{ $bookingDetail->booking_ref ?? ''}}</td>
                    </tr>
                    <tr>
                      <td style="font-weight:600;">Vendor ID:</td>
                      <td>{{ $bookingDetail->supplier_booking_ref ?? ''}}</td>
                    </tr>
                    <tr>
                      <td style="font-weight:600;">Hotel Confirmation No:</td>
                      <td>To Be Advised</td>
                    </tr>
                    @if ($bookingDetail?->customer_language_code == App\Enums\Locale::English->value)
                    <tr>
                      <td style="font-weight:600;">Booking Date:</td>
                      <td>{{ \Carbon\Carbon::parse($bookingDetail->booking_date)->format('d-m-Y') ?? '' }}</td>
                    </tr>
                    @else
                    <tr>
                      <td style="font-weight:600;">Booking Date:</td>
                      <td>{{ $bookingDetail->booking_date ?? '' }}</td>
                    </tr>
                    @endif
                  </tbody>
                </table>

              </div>

            </div>
          </td>
        </tr>
      </table>




      <div class="col-md-12">
        <div class="prods">
          <table style="table-layout:auto;">
            <tr>
              <div class=" d-flex">

                <td style="padding-right:15px;">
                  <div style="position: relative; display: inline-block;">
                    <!-- Image -->
                    <img
                      src="{{ $hotel_image ?? '' }}"
                      style="width: 180px; height:170px; border-radius: 9px;"
                      alt="Logo">

                    <!-- Overlay badge -->
                    <span style="
                        position: absolute;
                        top: 8px;
                        right: 8px;
                        background: #e6f7ff;     
                        color: #0073aa;  
                        font-size: 12px;
                        font-weight: 600;
                        padding: 3px 8px;
                        border-radius: 12px;
                        box-shadow: 0 0 3px rgba(0,0,0,0.2);
                     ">
                      {{ $hotelDetails->hotelDetails->PropertyType ?? '' }}
                    </span>
                  </div>
                </td>


                <td>

                  <table>
                    <tr>
                      <td colspan="2">

                        <div class="col-md-8 prod">
                          @php
                          $starRating = $hotelDetails->hotelDetails->StarRating ?? 4;
                          @endphp

                          <h2 class="fs-4" style="color:black; font-weight:400;">
                            {{ $hotelDetails->hotelDetails->DisplayName ?? '' }}
                            @for ($i = 0; $i < $starRating; $i++)
                              <i class="fas fa-star" style="color: gold; font-size: 16px;"></i>
                              @endfor
                          </h2>

                          <p style="font-size: 14px">{{ $hotelDetails->hotelDetails->Address ?? ''}}</p>

                          <button style="margin-top: 6px; font-weight:bold;font-size: 16px">{{ ucwords($searchDetails->city) ?? '' }}</button>



                        </div>


                      </td>

                    </tr>
                    <tr>
                      <td>

                        <ul class="d-flex flex-wrap list-unstyled mt-3 mb-1">
                          <!-- Each li takes up 50% of the row (2 items per row) -->
                          <li style="white-space: nowrap;" class="col-6"><svg width="25" height="25" viewBox="0 0 15 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <path fill-rule="evenodd" clip-rule="evenodd" d="M4.375 10.5C4.375 10.1562 4.65625 9.875 5 9.875C5.34375 9.875 5.625 10.1562 5.625 10.5C5.625 10.8438 5.34375 11.125 5 11.125C4.65625 11.125 4.375 10.8438 4.375 10.5ZM7.5 9.875H10C10.3438 9.875 10.625 10.1562 10.625 10.5C10.625 10.8438 10.3438 11.125 10 11.125H7.5C7.15625 11.125 6.875 10.8438 6.875 10.5C6.875 10.1562 7.15625 9.875 7.5 9.875ZM11.25 13H3.75C3.40562 13 3.125 12.7194 3.125 12.375V8.625H11.875V12.375C11.875 12.7194 11.5944 13 11.25 13ZM3.75 4.25H4.375V4.875C4.375 5.21875 4.65625 5.5 5 5.5C5.34375 5.5 5.625 5.21875 5.625 4.875V4.25H9.375V4.875C9.375 5.21875 9.65625 5.5 10 5.5C10.3438 5.5 10.625 5.21875 10.625 4.875V4.25H11.25C11.5944 4.25 11.875 4.53063 11.875 4.875V7.375H3.125V4.875C3.125 4.53063 3.40562 4.25 3.75 4.25ZM11.25 3H10.625V2.375C10.625 2.03125 10.3438 1.75 10 1.75C9.65625 1.75 9.375 2.03125 9.375 2.375V3H5.625V2.375C5.625 2.03125 5.34375 1.75 5 1.75C4.65625 1.75 4.375 2.03125 4.375 2.375V3H3.75C2.71625 3 1.875 3.84125 1.875 4.875V12.375C1.875 13.4087 2.71625 14.25 3.75 14.25H11.25C12.2837 14.25 13.125 13.4087 13.125 12.375V4.875C13.125 3.84125 12.2837 3 11.25 3Z" fill="#B3B9C0" />
                            </svg>

                            @if ($bookingDetail?->customer_language_code == App\Enums\Locale::English->value)

                            {{'Check In:'}}
                            @if(!empty($searchDetails->checkInDate))
                            {{ \Carbon\Carbon::parse($searchDetails->checkInDate)->format('d-m-Y') }}
                            @else
                            {{ \Carbon\Carbon::parse($searchDetails->stay->checkIn)->format('d-m-Y') }}
                            @endif

                            @else
                            {{'Check In: '}} {{ $searchDetails->checkInDate ?? $searchDetails->stay->checkIn }}
                            @endif
                          </li>

                          <li style="white-space: nowrap;" class="col-6 "><svg width="25" height="25" viewBox="0 0 15 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <path fill-rule="evenodd" clip-rule="evenodd" d="M4.375 10.5C4.375 10.1562 4.65625 9.875 5 9.875C5.34375 9.875 5.625 10.1562 5.625 10.5C5.625 10.8438 5.34375 11.125 5 11.125C4.65625 11.125 4.375 10.8438 4.375 10.5ZM7.5 9.875H10C10.3438 9.875 10.625 10.1562 10.625 10.5C10.625 10.8438 10.3438 11.125 10 11.125H7.5C7.15625 11.125 6.875 10.8438 6.875 10.5C6.875 10.1562 7.15625 9.875 7.5 9.875ZM11.25 13H3.75C3.40562 13 3.125 12.7194 3.125 12.375V8.625H11.875V12.375C11.875 12.7194 11.5944 13 11.25 13ZM3.75 4.25H4.375V4.875C4.375 5.21875 4.65625 5.5 5 5.5C5.34375 5.5 5.625 5.21875 5.625 4.875V4.25H9.375V4.875C9.375 5.21875 9.65625 5.5 10 5.5C10.3438 5.5 10.625 5.21875 10.625 4.875V4.25H11.25C11.5944 4.25 11.875 4.53063 11.875 4.875V7.375H3.125V4.875C3.125 4.53063 3.40562 4.25 3.75 4.25ZM11.25 3H10.625V2.375C10.625 2.03125 10.3438 1.75 10 1.75C9.65625 1.75 9.375 2.03125 9.375 2.375V3H5.625V2.375C5.625 2.03125 5.34375 1.75 5 1.75C4.65625 1.75 4.375 2.03125 4.375 2.375V3H3.75C2.71625 3 1.875 3.84125 1.875 4.875V12.375C1.875 13.4087 2.71625 14.25 3.75 14.25H11.25C12.2837 14.25 13.125 13.4087 13.125 12.375V4.875C13.125 3.84125 12.2837 3 11.25 3Z" fill="#B3B9C0" />

                            </svg>
                            @if ($bookingDetail?->customer_language_code == App\Enums\Locale::English->value)

                            {{'Check Out:'}}
                            @if(!empty($searchDetails->checkOutDate))
                            {{ \Carbon\Carbon::parse($searchDetails->checkOutDate)->format('d-m-Y') }}
                            @else
                            {{ \Carbon\Carbon::parse($searchDetails->stay->checkOut)->format('d-m-Y') }}
                            @endif

                            @else
                            {{'Check Out: '}} {{ $searchDetails->checkOutDate ?? $searchDetails->stay->checkOut }}
                            @endif

                          </li>



                        </ul>

                      </td>
                      <td>

                        <ul class="d-flex flex-wrap list-unstyled mt-3 mb-1">
                          <li style="white-space: nowrap;" class="col-6 "><svg width="25" height="25" viewBox="0 0 15 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <path fill-rule="evenodd" clip-rule="evenodd" d="M6.88587 2.25098C3.9817 2.55763 1.71875 5.01455 1.71875 8C1.71875 11.1929 4.3071 13.7812 7.5 13.7812C10.4855 13.7812 12.9424 11.5183 13.249 8.61413C12.4198 9.66678 11.1329 10.3438 9.6875 10.3438C7.18496 10.3438 5.15625 8.31504 5.15625 5.8125C5.15625 4.36711 5.83322 3.08019 6.88587 2.25098ZM0.78125 8C0.78125 4.28934 3.78934 1.28125 7.5 1.28125C7.94789 1.28125 8.17212 1.63829 8.21053 1.92267C8.24747 2.19623 8.14635 2.54416 7.8319 2.73417C6.78916 3.36425 6.09375 4.50739 6.09375 5.8125C6.09375 7.79727 7.70273 9.40625 9.6875 9.40625C10.9926 9.40625 12.1357 8.71084 12.7658 7.6681C12.9558 7.35365 13.3038 7.25253 13.5773 7.28947C13.8617 7.32788 14.2188 7.55211 14.2188 8C14.2188 11.7107 11.2107 14.7188 7.5 14.7188C3.78934 14.7188 0.78125 11.7107 0.78125 8Z" fill="#B3B9C0" />
                            </svg>
                            Number of Nights: {{ $numberofdays ?? '' }} </li>

                          <li style="white-space: nowrap;" class="col-6"><svg width="25" height="25" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <g clip-path="url(#clip0_3588_34801)">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M9.375 2.91634C9.375 2.27201 9.93464 1.74967 10.625 1.74967C11.3154 1.74967 11.875 2.27201 11.875 2.91634C11.875 3.56067 11.3154 4.08301 10.625 4.08301C9.93464 4.08301 9.375 3.56067 9.375 2.91634ZM10.625 0.583008C9.24429 0.583008 8.125 1.62768 8.125 2.91634C8.125 4.20501 9.24429 5.24967 10.625 5.24967C12.0057 5.24967 13.125 4.20501 13.125 2.91634C13.125 1.62768 12.0057 0.583008 10.625 0.583008ZM8.4608 8.65279C8.51724 8.04811 9.08337 7.58301 9.76295 7.58301H11.4871C12.1666 7.58301 12.7328 8.04811 12.7892 8.65279L13.0659 11.6179C13.0977 11.958 12.7971 12.2497 12.4149 12.2497H8.83513C8.45291 12.2497 8.15231 11.958 8.18406 11.6179L8.4608 8.65279ZM7.15865 8.5559C7.27152 7.34655 8.40379 6.41634 9.76295 6.41634H11.4871C12.8462 6.41634 13.9785 7.34655 14.0914 8.5559L14.3681 11.521C14.4633 12.5413 13.5615 13.4163 12.4149 13.4163H8.83513C7.68845 13.4163 6.78668 12.5413 6.88191 11.521L7.15865 8.5559Z" fill="#B3B9C0" />
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.125 2.91634C3.125 2.27201 3.68464 1.74967 4.375 1.74967C5.06536 1.74967 5.625 2.27201 5.625 2.91634C5.625 3.56067 5.06536 4.08301 4.375 4.08301C3.68464 4.08301 3.125 3.56067 3.125 2.91634ZM4.375 0.583008C2.99429 0.583008 1.875 1.62768 1.875 2.91634C1.875 4.20501 2.99429 5.24967 4.375 5.24967C5.75571 5.24967 6.875 4.20501 6.875 2.91634C6.875 1.62768 5.75571 0.583008 4.375 0.583008ZM2.2108 8.65279C2.26724 8.04811 2.83337 7.58301 3.51295 7.58301H5.23705C5.56701 7.58301 5.87022 7.69265 6.10133 7.87467L6.81594 6.89028C6.37594 6.59215 5.82794 6.41634 5.23705 6.41634H3.51295C2.15379 6.41634 1.02152 7.34655 0.908649 8.5559L0.631906 11.521C0.536679 12.5413 1.43845 13.4163 2.58513 13.4163H6.25C5.9375 12.833 5.9375 12.5413 5.9375 12.2497H2.58513C2.20291 12.2497 1.90231 11.958 1.93406 11.6179L2.2108 8.65279Z" fill="#B3B9C0" />
                              </g>
                              <defs>
                                <clipPath id="clip0_3588_34801">
                                  <rect width="15" height="14" fill="white" />
                                </clipPath>
                              </defs>
                            </svg> Travellers: {{ $adult+$child }} </li>
                        </ul>

                      </td>
                    </tr>
                  </table>

                </td>
                <td>

                </td>


                <!--  <td>

          </td> -->

              </div>
            </tr>
          </table>
        </div>

        <table class="table invoice_table"
          style="margin-top: 3rem !important;
         border: 1px solid #EDF1FE !important;
         border-radius: 5px !important;
         border-collapse: collapse;
         width:100%;">

          <!-- Set column widths -->
          <colgroup>
            <col style="width: 8%;"> <!-- Units column small -->
            <col style="width: 42%;"> <!-- Room Types gets more space -->
            <col style="width: 10%;"> <!-- Adults -->
            <col style="width: 10%;"> <!-- Children -->
            <col style="width: 15%;"> <!-- Ages -->
            <col style="width: 15%;"> <!-- Meal Plan -->
          </colgroup>

          <thead>
            <tr class="tabletitle">
              <th>Units</th>
              <th>Room Types</th>
              <th>Adults</th>
              <th>Children</th>
              <th>Ages</th>
              <th>Meal Plan</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td style="text-align:center; font-size:15px; color:black;">
                1
              </td>
              <td style="font-size:15px; color:black;">
                <p class="itemtext" style="margin:0; font-size:15px; color:black;">
                  {{ $hotelDetails->selectedRooms->RoomType ?? 'N/A' }} -
                  {{ $hotelDetails->selectedRooms->RoomName ?? 'N/A' }} -
                  {{ $hotelDetails->selectedRooms->RoomClass ?? 'N/A' }}
                </p>
              </td>
              <td style="text-align:center; font-size:15px; color:black;">
                {{ $adult ?? 0 }}
              </td>
              <td style="text-align:center; font-size:15px; color:black;">
                {{ $child ?? 0 }}
              </td>
              <td style="text-align:center; font-size:15px; color:black;">
                {{ is_array($hotelDetails->selectedRooms->KidsAges ?? null) && count($hotelDetails->selectedRooms->KidsAges) > 0
            ? implode(', ', $hotelDetails->selectedRooms->KidsAges)
            : '-' }}
              </td>
              <td style="text-align:center; font-size:15px; color:black;">
                {{ $hotelDetails->selectedRooms->RoomBasis ?? 'N/A' }}
              </td>
            </tr>
          </tbody>
        </table>



        <table class="table invoice_table" style="margin-top: 3rem !important;border: 1px solid #EDF1FE !important;border-radius: 5px !important;padding: .5rem .5rem !important;">
          <thead>
            <tr class="tabletitle">
              <th style="text-align: left;" style="font-weight: 700;">Client's Remarks</th>
            </tr>
          </thead>
          <tbody>
            <tr>
              <td style="padding: 16px !important;">
                <p class="itemtext"> {{ '' }} </p>
              </td>
            </tr>

          </tbody>
        </table>


        <div class="cus_box">
          @php
          $bookingRemarks = '';
          $cancellationPolicies;
          if (!empty($cancellationPolicies) && !empty($cancellationPolicies->BookingRemarks)) {
          $bookingRemarks = $cancellationPolicies->BookingRemarks;
          }
          @endphp
          @if($bookingRemarks)
          <h5 class="clr_cls mt-4 fw-bold" style="font-weight: 700;">Important Information :</h5>

          <table class="table table-bordered table-sm">
            <tbody>
              <tr>
                <td style="line-height: 2em; font-size:16px"> {!! $bookingRemarks !!}</td>

              </tr>

            </tbody>
          </table>
          @endif

          <h5 class="clr_cls mt-4 fw-400 fs-6" style="font-weight: 600;">Map :</h5><br>

          <!-- <div id="maps">
              <img style="width:100%;" src="{{ URL::asset('assets/images/map.png') }}" alt="Map">
            </div> -->

          @php
          $latitude = $hotelDetails->hotelDetails->GeoLocation->Latitude ?? '';
          $longitude = $hotelDetails->hotelDetails->GeoLocation->Longitude ?? '';
          $googleMapKey = env('GOOGLE_MAP_KEY');
          $customMarkerUrl = asset('storage/images/general/map-marker2.png');
          $mapImageUrl = "https://maps.googleapis.com/maps/api/staticmap?center={$latitude},{$longitude}&zoom=14&size=600x300&&markers=icon:{$customMarkerUrl}%7C{$latitude},{$longitude}&key={$googleMapKey}";


          @endphp

          <img src="{{ $mapImageUrl }}" alt="Location Map" style="height: 400px; width: 100%; border-radius:25px">

          <input type="hidden" name="latitude" id="latitude" value="{{ $searchDetails->geolocation->latitude ?? '' }}" readonly>
          <input type="hidden" name="longitude" id="longitude" value="{{ $searchDetails->geolocation->longitude ?? '' }}" readonly>

          <br>
          <!-- <div id="map" style="height: 400px; width: 100%;"></div> -->

          <div class="user_info">
            <h5 class="clr_cls mt-4 fw-bold" style="font-weight: 600;">Useful info :</h5>

            <p style="text-align: justify; line-height: 2em; font-size:16px">{!! $pageDetails->page_content ?? '' !!}</p>

          </div>



        </div>


      </div>

    </div><!--End InvoiceTop-->




    <!-- </div>End Invoice -->
    <!-- </div> -->
  </div>
</body>

</html>