@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<link href="
https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.css
" rel="stylesheet">

<style>
    .form-item input.is-valids+label {
        font-size: 11px;
        top: -5px;
    }

    .list-group a:hover {
        background-color: #335476 !important;
        color: white !important;
    }


    .loader-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.5);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
    }

    .loader {
        width: 50px;
        height: 50px;
        border: 5px solid red;
        border-top: 5px solid transparent;
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }

    input[readonly] {
        background-color: #f5f5f5;
        color: #999;

        cursor: not-allowed;
    }

    .text-black {
        color: black;
    }
</style>
<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
                <h1 class="m-0">Booking Details - Edit</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="/booking ">Booking Details - Edit</a></li>
                    <li class="breadcrumb-item active">Edit Flight</li>
                </ol>

                <div class="col d-flex justify-content-end">
                    <button class="btn btn-primary" target="_blank">Booked At: {{ \Carbon\Carbon::parse($additional_details->created_at ?? '')->format('d M Y, h:i A') }}</button>
                </div>
            </div><!-- /.col -->

        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            <div class="card pb-4 pt-3 px-3 w-100">
                <form id="bookingForm" action="#" class="form row pt-3 mb-0 validate" enctype="multipart/form-data" method="post">
                    @method('PUT')
                    @csrf
                    <div class="row">
                        <!-- Sidebar -->
                        <div class="col-md-3">
                            <div class="list-group" style="position: sticky; top:60px;">
                                <a href="#customerDetails" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="background-color: #335476 !important; color: white !important">
                                    <i class="fas fa-user"></i> Customer Details
                                </a>
                                <a href="#flightDetails" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                    <i class="fas fa-plane-departure"></i> Flight Details
                                </a>

                                <a href="#passengerDetails" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                    <i class="fas fa-user-friends"></i> Passenger Details
                                </a>
                                <a href="#baggageDetails" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                    <i class="fas fa-suitcase-rolling"></i> Baggage Details
                                </a>
                                <a href="#seatDetails" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                    <i class="fas fa-chair economy-seat"></i> Seat Details
                                </a>
                                <a href="#travellerPriceDetails" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                    <i class="fas fa-users"></i> <i class="fas fa-money-bill-wave"></i> Traveller Price Details
                                </a>
                                <a href="#paymentDetails" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                    <i class="fas fa-credit-card"></i> Payment Details
                                </a>
                               

                                <a href="#cancellationpolicies" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                    <i class="fas fa-file-alt"></i> Cancellation Policies
                                </a>
                                @if($additional_details->booking_status == 'confirmed' && (now()->format('Y-m-d') <= $additional_details->booking_start_date))

                                    <a href="#" class="list-group-item list-group-item-action cancel-booking" data-id="{{ $additional_details->id }}" title="Cancel" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                        <i class="fas fa-times-circle"></i> Cancel Booking
                                    </a>
                                    @endif
                            </div>
                        </div>

                        <!-- Tab Content -->
                        <div class="col-md-9">
                            <div class="tab-content">
                                <!-- Customer Details Tab -->
                                <div class="tab-pane fade show active" id="customerDetails">
                                    <div class="row mb-4">
                                        <div class="col">
                                            <h5 class="m-0 text-start text-dark" style="color:black !important">Customer Details</h5>
                                        </div>
                                    </div>

                                    @php
                                    $serviceProviderResponse = $additionalBookingDetails->service_provider_booking_response ?? '{}';

                                    $airlinePnr = $gdsPnr = [];

                                    if (!empty($serviceProviderResponse) && isset($serviceProviderResponse['data']['associatedRecords'])) {
                                    $associatedRecords = $serviceProviderResponse['data']['associatedRecords'];

                                    foreach ($associatedRecords as $record) {
                                    if ($record['originSystemCode'] === 'GDS') {
                                    $gdsPnr[] = $record['reference'];
                                    } else {
                                    $airlinePnr[] = $record['reference'];
                                    }
                                    }
                                    }
                                    @endphp


                                    <div class="col-md-12 row mb-3">
                                        <!-- All customer detail fields -->
                                        <input type="hidden" name="edit_type" id="" value="customer_details" readonly>
                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="booking_ref" type="text" id="booking_ref" autocomplete="off" value="{{$additional_details->booking_ref  ?? ''}}" readonly>
                                                <label for="booking_ref">Rehlte Trip ID<span class="req-star">*</span></label>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="booking_type" type="text" id="booking_type" autocomplete="off" value="{{$additional_details->booking_type  ?? ''}}" readonly>
                                                <label for="booking_type">Service Name<span class="req-star">*</span></label>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="supplier_provider" type="text" id="supplier_provider" autocomplete="off" value="{{$supplier_provider->name ?? ''}}" readonly>
                                                <label for="supplier_provider">Supplier Provider<span class="req-star">*</span></label>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input
                                                    name="service_provider"
                                                    type="text"
                                                    id="service_provider"
                                                    autocomplete="off"
                                                    value="{{ !empty($gdsPnr) ? implode(',', $gdsPnr) : 'N/A' }}"
                                                    readonly>

                                                <label for="service_provider">GDS PNR<span class="req-star">*</span></label>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="supplier_booking_associated_ref" type="text" id="supplier_booking_associated_ref" autocomplete="off" value="{{ !empty($airlinePnr) ? implode(',', $airlinePnr) : 'N/A' }}" readonly>
                                                <label for="supplier_booking_associated_ref">AirLine PNR<span class="req-star">*</span></label>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="ticket_no" type="text" id="ticket_no" autocomplete="off" value="{{$additional_details->ticket_no  ?? ''}}">
                                                <label for="ticket_no">Ticket No<span class="req-star">*</span></label>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="supplier_id" type="text" id="supplier_id" autocomplete="off" value="{{ ucwords($additional_details->booking_status ?? '')}}" readonly>
                                                <label for="supplier_id" readonly>Booking Status<span class="req-star">*</span></label>
                                            </div>
                                        </div>

                                        {{--<div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="booking_date" type="date" id="booking_date" autocomplete="off" value="{{$existingBookingDetails->booking_date  ?? ''}}">
                                        <label for="booking_date">Booking Date<span class="req-star">*</span></label>
                                    </div>
                                </div>--}}

                                {{-- <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="booking_start_date" type="date" id="booking_start_date" autocomplete="off" value="{{$existingBookingDetails->booking_start_date ?? '' }}">
                                <label for="booking_start_date">Booking Start Date<span class="req-star">*</span></label>
                            </div>
                        </div>--}}

                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input name="first_name" type="text" id="first_name" autocomplete="off" value="{{$existingBookingDetails->first_name  ?? ''}}">
                                <label for="first_name">First Name<span class="req-star">*</span></label>
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input name="last_name" type="text" id="last_name" autocomplete="off" value="{{$existingBookingDetails->last_name  ?? ''}}">
                                <label for="last_name">Last Name<span class="req-star">*</span></label>
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input name="customer_email" type="text" id="customer_email" autocomplete="off" value="{{$existingBookingDetails->email  ?? ''}}">
                                <label for="customer_email">Customer Email<span class="req-star">*</span></label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-item form-float-style">
                                <input name="phoneNumber" type="text" id="customer_email" autocomplete="off" value="{{$customer_details['phoneNumber'] ?? ''}}">
                                <label for="phoneNumber">Customer Phone Number<span class="req-star">*</span></label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-item form-float-style">
                                <input name="nationality" type="text" id="nationality" autocomplete="off" value="{{$customer_details['country_name'] ?? ($customer_details['nationality'] ?? '')}}" readonly>
                                <label for="nationality">Nationality</label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-item form-float-style">
                                <input name="booking_date_time" type="text" id="booking_date_time" autocomplete="off"
                                    value="{{ \Carbon\Carbon::parse($additional_details->created_at ?? '')->format('d M Y, h:i A') }}" readonly>

                                <label for="booking_date_time">Booking Date and Time</label>
                            </div>
                        </div>
                        @php
                        $bookingFrom = '';
                        if(isset($additional_details->booking_from)){
                        $bookingVia = $additional_details->booking_from;
                        if($bookingVia == 'web'){
                        $bookingFrom = 'B2C Desktop';
                        } elseif($bookingVia == 'b2c_mobile_browser'){
                        $bookingFrom = 'B2C Mobile Browser';
                        } elseif($bookingVia == 'b2c_mobile_app'){
                        $bookingFrom = 'B2C Mobile App';
                        } else{
                        $bookingFrom = '';
                        }
                        }
                        @endphp
                        <div class="col-md-4">
                            <div class="form-item form-float-style">
                                <input name="booking_from" type="text" id="booking_from" autocomplete="off" value="{{ucwords($bookingFrom) ?? ''}}" readonly>
                                <label for="booking_from">Booking From</label>
                            </div>
                        </div>
                    </div>
                    <button type="button" class="btn btn-primary update-btn">Update Customer Details</button>
            </div>

            @php

            $flightInfo = $flight_details;
            $passengerDetails = $passenger_details;

            $paymentDetails = $processed_price;
            $billingDetails = $billing_details;

            $originalBookingDetail = json_decode($additional_details->booking_details) ?? new stdClass();
            $existingBookingFullData = json_decode($existingBookingDetails->booking_details) ?? new stdClass();

            $existingFlightDetails = $existingBookingFullData->flightDetails ?? new stdClass();
            $existingAirlineDetails = $existingFlightDetails->airlines ?? [];
            $cancellationPolicy = $originalBookingDetail->booking_details->cancellationPolicy ?? [];




            @endphp

            <!-- Flight Details Tab -->
            <div class="tab-pane fade" id="flightDetails">
                <div class="col-md-12 mb-4">
                    <h5 class="m-0 text-center text-dark" style="color:black !important">Flight Details</h5>
                </div>
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">

                            <button type="button" class="btn btn-primary">Flight Type: {{ ucwords($additional_details->additional_details ?? 'N/A' )}}</button>
                        </div>
                    </div>
                </div>
                <input type="hidden" value="flight_details" name="edit_type">
                <div class="accordion accordion-flush" id="accordionFlushExample" style="border: 1px solid lightgrey; margin-bottom:20px">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="flush-headingOne">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
                                Flight Details
                            </button>
                        </h2>
                        <div id="flush-collapseOne" class="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample">
                            <div class="accordion-body">
                                @php $i = 0; @endphp

                                @foreach ($existingAirlineDetails as $airline)
                                @foreach ($airline->flights as $flight)
                                @php
                                $segments = $flight->segments;
                                $numberOfStops = count($segments) - 1;

                                $firstSegment = $segments[0];
                                $lastSegment = $segments[count($segments) - 1];

                                $departureDateTime = new \DateTime(str_replace("T", " ", $firstSegment->departureDate));
                                $arrivalDateTime = new \DateTime(str_replace("T", " ", $lastSegment->arrivalDate));
                                @endphp



                                <table style="width: 100%; font-family: Arial, sans-serif; border-collapse: collapse; margin-bottom: 30px;">
                                    <tr>
                                        <td colspan="4" style="background-color: #09496d; color: white; padding: 10px; font-weight: bold; border-radius: 10px;">
                                            {{ $i % 2 == 0 ? 'Departure Flight' : 'Return Flight' }}
                                            ({{ $numberOfStops > 0 ? $numberOfStops . ' Stop' . ($numberOfStops > 1 ? 's' : '') : 'Non-Stop' }})
                                        </td>
                                    </tr>

                                    @foreach ($segments as $index => $segment)
                                    @php
                                    $departure = new \DateTime(str_replace("T", " ", $segment->departureDate));
                                    $arrival = new \DateTime(str_replace("T", " ", $segment->arrivalDate));
                                    @endphp

                                    <tr>
                                        <!-- Airline Info -->
                                        <td style="width: 18%; text-align: center; padding: 10px;">
                                            <img src="{{ $segment->airlineData->logo ?? '' }}" alt="{{ $segment->airlineData->name ?? '' }}" style="width: 60px; height: auto;">
                                            <div style="margin-top: 5px; font-size: 0.9em; color:black">
                                                {{ $segment->airlineData->name ?? '' }}<br>
                                                {{ $segment->aircraftData->name ?? '' }}<br>
                                                Flight: {{ $segment->carrierCode ?? '' }} {{ $segment->number ?? '' }}
                                            </div>
                                        </td>

                                        <!-- Departure Info -->
                                        <td style="width: 28%; text-align: left; padding: 10px;">
                                            <div style="font-size: 1.5em; font-weight: bold; color:black">
                                                {{ $departure->format('H:i') }}
                                            </div>
                                            <div style="font-size: 0.9em; color:black">
                                                <i class="fas fa-plane-departure" style="color: green;"></i>
                                                {{ $segment->departure->iataCode ?? '' }}<br>
                                                {{ $segment->departureAirportData->city_name ?? '' }},
                                                {{ $segment->departureAirportData->country_name ?? '' }}<br>
                                                {{ $departure->format('D, d M Y') }}<br>
                                                Terminal: {{ $segment->departure->terminal ?? '-' }}
                                            </div>
                                        </td>

                                        <!-- Duration Info -->
                                        <td style="width: 15%; text-align: center; vertical-align: middle; padding: 10px;">
                                            <i class="fas fa-plane" style="color: #09496d; font-size: 1.5em;"></i>
                                            <div style="font-size: 0.9em; margin-top: 5px; color:black">
                                                Segment {{ $index + 1 }}<br>
                                                {{ $segment->durationText ?? '' }}
                                            </div>
                                        </td>

                                        <!-- Arrival Info -->
                                        <td style="width: 28%; text-align: left; padding: 10px;">
                                            <div style="font-size: 1.5em; font-weight: bold; color:black">
                                                {{ $arrival->format('H:i') }}
                                            </div>
                                            <div style="font-size: 0.9em; color:black">
                                                <i class="fas fa-plane-arrival" style="color: red;"></i>
                                                {{ $segment->arrival->iataCode ?? '' }}<br>
                                                {{ $segment->arrivalAirportData->city_name ?? '' }},
                                                {{ $segment->arrivalAirportData->country_name ?? '' }}<br>
                                                {{ $arrival->format('D, d M Y') }}<br>
                                                Terminal: {{ $segment->arrival->terminal ?? '-' }}
                                            </div>
                                        </td>
                                    </tr>

                                    {{-- Layover Info --}}
                                    @if ($index < count($segments) - 1)
                                        @php
                                        $nextDeparture=new \DateTime(str_replace("T", " " , $segments[$index + 1]->departureDate));
                                        $layoverDuration = $arrival->diff($nextDeparture);
                                        @endphp
                                        <tr>
                                            <td colspan="4" style="text-align: center; font-size: 0.9em; color: #555; padding: 8px; background-color: #f5f5f5;">
                                                Layover at {{ $segment->arrivalAirportData->city_name }},
                                                {{ $segment->arrivalAirportData->country_name }} —
                                                {{ $layoverDuration->format('%h hrs %i mins') }}
                                            </td>
                                        </tr>
                                        @endif
                                        @endforeach
                                </table>

                                @php $i++; @endphp
                                @endforeach
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
                @foreach ($existingAirlineDetails as $airline)
                @foreach ($airline->flights as $flightIndex => $flight)
                @php
                $segmentCounter = 1;
                $segments = $flight->segments;
                @endphp
                @foreach ($segments as $index => $segment)
                @php
                $departureTime = new \DateTime(str_replace("T", " ", $segment->departureDate));
                $arrivalTime = new \DateTime(str_replace("T", " ", $segment->arrivalDate));
                $departure = $segment->departureDate;

                $arrival =$segment->arrivalDate;
                @endphp

                <div class="segment-box p-3 mb-4 border rounded">
                    <h5 class="mb-3 p-2" style="color: black;background-color: lightgray; border: 1px solid lightgrey">Flight Segment {{ $segmentCounter }}</h5>

                    {{-- Airline Info --}}
                    <h6 class="my-3" style="color: black;">Airline Information</h6>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-item form-float-style form-group">
                                <select data-live-search="true" id="airline_name_{{ $index }}" name="segments[{{ $flightIndex }}][{{ $index }}][airline_name]" class="order-td-input select-text height_drp is-valid selectDropDown" style="width: 100%;">
                                    <option value="{{ $segment->airlineData->name ?? '' }}">{{ $segment->airlineData->name ?? '' }}</option>
                                    @foreach ($airlineDetails as $airlines)
                                    <option value="{{ $airlines->airline_name_en }}">{{ $airlines->airline_name_en }}</option>
                                    @endforeach
                                </select>
                                <label for="airline_name_{{ $index }}" class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Airline Name <span class="req-star">*</span></label>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-item form-float-style">
                                <label for="aircraft_name_{{ $index }}">Aircraft</label>
                                <input type="text" name="segments[{{ $flightIndex }}][{{ $index }}][aircraft_name]" id="aircraft_name_{{ $index }}" value="{{ $segment->aircraftData->name ?? '' }}">
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-item form-float-style">
                                <label for="flight_number_{{ $index }}">Flight Number</label>
                                <input type="text" name="segments[{{ $flightIndex }}][{{ $index }}][flight_number]" id="flight_number_{{ $index }}" value="{{ $segment->carrierCode ?? '' }} {{ $segment->number ?? '' }}">
                            </div>
                        </div>
                    </div>

                    {{-- Departure Info --}}
                    <h6 class="my-3" style="color: black;">Departure Details</h6>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-item form-float-style">
                                <label for="departure_time_{{ $index }}">Departure Time</label>
                                <input type="datetime-local"
                                    class="departure-time"
                                    name="segments[{{ $flightIndex }}][{{ $index }}][departure_time]"
                                    id="departure_time_{{ $index }}"
                                    value="{{ \Carbon\Carbon::parse($departure)->format('Y-m-d\TH:i') }}">

                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style">
                                <label for="departure_iata_{{ $index }}">IATA Code</label>
                                <input type="text" name="segments[{{ $flightIndex }}][{{ $index }}][departure_iata]" id="departure_iata_{{ $index }}" value="{{ $segment->departure->iataCode ?? '' }}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <select data-live-search="true" name="segments[{{ $flightIndex }}][{{ $index }}][departure_city]" id="departure_city_{{ $index }}" class="order-td-input select-text height_drp is-valid select2 selectDropDown" style="width: 100%;">
                                    <option value="{{ $segment->departureAirportData->city_name ?? '' }}">{{ $segment->departureAirportData->city_name ?? '' }}</option>
                                    @foreach ($cityDetails as $city)
                                    <option value="{{ $city->city_name_en }}">{{ $city->city_name_en }}</option>
                                    @endforeach
                                </select>
                                <label for="departure_city_{{ $index }}" class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">City</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <select data-live-search="true" name="segments[{{ $flightIndex }}][{{ $index }}][departure_country]" id="departure_country_{{ $index }}" class="order-td-input select-text height_drp is-valid select2 selectDropDown" style="width: 100%;">
                                    <option value="{{ $segment->departureAirportData->country_name ?? '' }}">{{ $segment->departureAirportData->country_name ?? '' }}</option>
                                    @foreach ($countryDetails as $country)
                                    <option value="{{ $country->country_name_en }}">{{ $country->country_name_en }}</option>
                                    @endforeach
                                </select>
                                <label for="departure_country_{{ $index }}" class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Country</label>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-md-3">
                            <div class="form-item form-float-style">
                                <label for="departure_terminal_{{ $index }}">Terminal</label>
                                <input type="text" name="segments[{{ $flightIndex }}][{{ $index }}][departure_terminal]" id="departure_terminal_{{ $index }}" value="{{ $segment->departure->terminal ?? '-' }}">
                            </div>
                        </div>
                    </div>

                    {{-- Duration Info --}}
                    <h6 class="my-3" style="color: black;">Duration</h6>
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-item form-float-style">
                                <label for="duration_{{ $index }}">Flight Duration</label>
                                <input type="text" class="duration-field" name="segments[{{ $flightIndex }}][{{ $index }}][duration]" id="duration_{{ $index }}" value="{{ $segment->durationText ?? '' }}" readonly>
                            </div>
                        </div>
                    </div>

                    {{-- Arrival Info --}}
                    <h6 class="my-3" style="color: black;">Arrival Details</h6>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-item form-float-style">
                                <label for="arrival_time_{{ $index }}">Arrival Time</label>
                                <input type="datetime-local" class="arrival-time" name="segments[{{ $flightIndex }}][{{ $index }}][arrival_time]" id="arrival_time_{{ $index }}" value="{{ \Carbon\Carbon::parse($arrival)->format('Y-m-d\TH:i')  }}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style">
                                <label for="arrival_iata_{{ $index }}">IATA Code</label>
                                <input type="text" name="segments[{{ $flightIndex }}][{{ $index }}][arrival_iata]" id="arrival_iata_{{ $index }}" value="{{ $segment->arrival->iataCode ?? '' }}">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <select data-live-search="true" name="segments[{{ $flightIndex }}][{{ $index }}][arrival_city]" id="arrival_city_{{ $index }}" class="order-td-input select-text height_drp is-valid select2 selectDropDown" style="width: 100%;">
                                    <option value="{{ $segment->arrivalAirportData->city_name ?? '' }}">{{ $segment->arrivalAirportData->city_name ?? '' }}</option>
                                    @foreach ($cityDetails as $city)
                                    <option value="{{ $city->city_name_en }}">{{ $city->city_name_en }}</option>
                                    @endforeach
                                </select>
                                <label for="arrival_city_{{ $index }}" class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">City</label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <select data-live-search="true" name="segments[{{ $flightIndex }}][{{ $index }}][arrival_country]" id="arrival_country_{{ $index }}" class="order-td-input select-text height_drp is-valid select2 selectDropDown" style="width: 100%;">
                                    <option value="{{ $segment->arrivalAirportData->country_name ?? '' }}">{{ $segment->arrivalAirportData->country_name ?? '' }}</option>
                                    @foreach ($countryDetails as $country)
                                    <option value="{{ $country->country_name_en }}">{{ $country->country_name_en }}</option>
                                    @endforeach
                                </select>
                                <label for="arrival_country_{{ $index }}" class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Country</label>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-md-3">
                            <div class="form-item form-float-style">
                                <label for="arrival_terminal_{{ $index }}">Terminal</label>
                                <input type="text" name="segments[{{ $flightIndex }}][{{ $index }}][arrival_terminal]" id="arrival_terminal_{{ $index }}" value="{{ $segment->arrival->terminal ?? '-' }}">
                            </div>
                        </div>
                    </div>

                    {{-- Optional Layover Note --}}
                    @if ($index < count($segments) - 1)
                        @php
                        $nextDeparture=new \DateTime(str_replace("T", " " , $segments[$index + 1]->departureDate));
                        $layoverDuration = $arrivalTime->diff($nextDeparture);
                        @endphp
                        <div class="alert mt-4 text-center p-2" style="background-color: lightskyblue; color: black;">
                            <strong style="color: black;">Layover:</strong> {{ $segment->arrivalAirportData->city_name ?? '' }}, {{ $segment->arrivalAirportData->country_name ?? '' }} — {{ $layoverDuration->format('%h hrs %i mins') }}
                        </div>
                        @endif

                </div>
                @php $segmentCounter++; @endphp
                @endforeach
                @endforeach
                @endforeach


                <button type="button" class="btn btn-primary update-flight-btn">Update Flight Details</button>

            </div>

            @php
            $a = $ch = $in = 0;

            foreach ($passengerDetails as $passengerGroup) {
            if (isset($passengerGroup['traveler_type'])) {
            switch (strtolower($passengerGroup['traveler_type'])) {
            case 'adult':
            $a++;
            break;
            case 'child':
            case 'children':
            $ch++;
            break;
            case 'infant':
            $in++;
            break;
            }
            }
            }

            @endphp

            <!-- Passenger Details Tab -->
            <div class="tab-pane fade" id="passengerDetails">
                <div class="col-md-12 mb-4">
                    <h5 class="m-0 text-center text-dark" style="color:black !important">Passenger Details </h5> <span style="color: black;"><b>Travellers: </b>{{$a}} Adult , {{$ch}} Child , {{$in}} Infant</span>
                </div>



                <div class="col-md-12 row mb-3">
                    <input type="hidden" value="passenger_details" name="edit_type">
                    <!-- All passenger detail fields -->
                    @php $i = 1; @endphp
                    @foreach($passengerDetails as $passengerIndex => $passenger)
                    <h6 class="text-start text-dark p-2" style="color:black !important">Passenger {{ $i }}</h6>

                    @foreach($passenger as $key => $value)
                    @if(!in_array($key, ['id', 'country_id', 'nationality_id','passport_nationality', 'passport_issued_country']))


                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="passengers[{{ $passengerIndex }}][{{ $key }}]" type="text" id="sector_{{ $passengerIndex }}_{{ $key }}" autocomplete="off" value="{{ is_array($value) ? implode(', ', $value) : $value }}">
                            <label for="sector_{{ $passengerIndex }}_{{ $key }}">{{ ucwords(str_replace('_', ' ', $key)) }} <span class="req-star">*</span></label>
                        </div>
                    </div>
                    @else
                    <input type="hidden" name="passengers[{{ $passengerIndex }}][{{ $key }}]" value="{{ is_array($value) ? implode(', ', $value) : $value }}">


                    @endif
                    @endforeach
                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="gds_pnr" type="text" id="gds_pnr" autocomplete="off" value="{{ !empty($gdsPnr) ? implode(',', $gdsPnr) : 'N/A' }}" readonly>
                            <label for="gds_pnr">GDS PNR<span class="req-star">*</span></label>
                        </div>
                    </div>
                    <div class="col-md-5 mb-3">
                        <div class="form-item form-float-style">
                            <input name="airline_pnr" type="text" id="airline_pnr" autocomplete="off" value="{{ !empty($airlinePnr) ? implode(',', $airlinePnr) : 'N/A' }}" readonly>
                            <label for="airline_pnr">AirLine PNR<span class="req-star">*</span></label>
                        </div>
                    </div>

                    @php $i++; @endphp
                    <hr style="border: 1px solid #000; margin: 20px 0;">
                    @endforeach
                </div>


                <button type="button" class="btn btn-primary update-btn">Update Passenger Details</button>
            </div>


            <!-- Baggage Details -->
            @php
            $baggageDetails = $existingBookingFullData->flightDetails->additionalDetails->addBags->selectedBagDetails ?? [];


            @endphp

            <div class="tab-pane fade" id="baggageDetails">
                <div class="row mb-4">
                    <div class="col">
                        <h5 class="m-0 text-center text-dark" style="color:black !important">Baggage Details</h5>
                    </div>
                </div>

                <div class="col-md-12 row mb-3">
                    <input type="hidden" value="baggage_details" name="edit_type">
                    @if (is_array($baggageDetails) && count($baggageDetails) > 0)
                    @foreach ($baggageDetails as $index => $baggage)
                    @php
                    $segmentId = $baggage->segmentId ?? 'N/A';
                    $travelerId = $baggage->travelerId ?? 'N/A';
                    $bagName = $baggage->bag->name ?? 'N/A';
                    $bagQty = $baggage->bag->quantity ?? 'N/A';
                    $bagPrice = $baggage->bag->price->amount ?? 'N/A';
                    $currency = $baggage->bag->price->currencyCode ?? '';
                    $segmentIds = implode(', ', $baggage->bag->segmentIds ?? []);
                    $travelerIds = implode(', ', $baggage->bag->travelerIds ?? []);
                    @endphp

                    <input type="hidden" name="baggageDetails[{{ $index }}][segmentId]" value="{{ $segmentId }}">
                    <input type="hidden" name="baggageDetails[{{ $index }}][travelerId]" value="{{ $travelerId }}">
                    <h5 class="mb-3 p-2" style="font-size:medium;color: black;background-color: lightgray; border: 1px solid lightgrey">Flight Segment {{$index + 1}}</h5>
                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input type="text" name="baggageDetails[{{ $index }}][bag][name]" value="{{ $bagName }}">
                            <label>Bag Type</label>
                        </div>
                    </div>

                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input type="number" name="baggageDetails[{{ $index }}][bag][quantity]" value="{{ $bagQty }}">
                            <label>Quantity</label>
                        </div>
                    </div>

                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input type="text" name="baggageDetails[{{ $index }}][bag][price][amount]" value="{{ $bagPrice }}">
                            <label>Price</label>
                        </div>
                    </div>

                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input type="text" name="baggageDetails[{{ $index }}][bag][price][currencyCode]" value="{{ $currency }}">
                            <label>Currency</label>
                        </div>
                    </div>

                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input type="text" name="baggageDetails[{{ $index }}][bag][segmentIds]" value="{{ $segmentIds }}" readonly>
                            <label>Segment IDs</label>
                        </div>
                    </div>

                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input type="text" name="baggageDetails[{{ $index }}][bag][travelerIds]" value="{{ $travelerIds }}" readonly>
                            <label>Traveler IDs</label>
                        </div>
                    </div>
                    <hr style="border: 1px solid #000; margin: 20px 0;">
                    @endforeach
                    <div class="col-md-4">

                        <button type="button" class="btn btn-primary update-btn">Update Baggage Details</button>
                    </div>
                    @else
                    <div class="alert alert-warning" style="padding:10px; color: black">No Baggage Details Available</div>
                    @endif
                </div>
            </div>


            <!-- Seat Details -->

            <!-- Seat Details -->
            @php
            // Normalize seatDetails to a flat array of objects
            $seatDetailsRaw = $existingBookingFullData->flightDetails->seatDetails->seatDetails ?? [];
            $seatDetails = [];
            if (is_array($seatDetailsRaw)) {
            foreach ($seatDetailsRaw as $item) {
            // Case: [ {object} ] — unwrap single-item array
            if (is_array($item) && count($item) === 1 && isset($item[0]) && is_object($item[0])) {
            $seatDetails[] = $item[0];
            }
            // Case: array of arrays or array of objects
            elseif (is_array($item)) {
            foreach ($item as $inner) {
            $seatDetails[] = is_object($inner) ? $inner : (object) $inner;
            }
            }
            // Case: already an object
            elseif (is_object($item)) {
            $seatDetails[] = $item;
            }
            }
            }

            // Map segment info by segmentId
            $airlinesData = $existingBookingDetails->airlines ?? [];
            $segmentsMap = [];

            foreach ($airlinesData as $airlineGroup) {
            foreach ($airlineGroup->flights ?? [] as $flight) {
            foreach ($flight->segments ?? [] as $segment) {
            $segmentsMap[$segment->id] = $segment;
            }
            }
            }

            $renderedSegments = [];
            @endphp

            <div class="tab-pane fade" id="seatDetails">
                <div class="row mb-4">
                    <div class="col">
                        <h5 class="m-0 text-center text-dark" style="color:black !important">Seat Details</h5>
                    </div>
                </div>

                <div class="col-md-12 row mb-3">
                    <input type="hidden" value="seat_details" name="edit_type">

                    @if($seatDetails)

                    @foreach ($seatDetails as $index => $seat)
                    @if (!blank((array) $seat))
                    @php

                    $segmentId = $seat->segmentId ?? '';
                    $segment = $segmentsMap[$segmentId] ?? null;
                    @endphp

                    @if ($segment && !in_array($segmentId, $renderedSegments))
                    <!-- Flight Info Block -->
                    <div class="col-md-12 mb-3">
                        <div class="d-flex align-items-center gap-3 p-3 border rounded shadow-sm">
                            <div style="min-width: 100px;">
                                <img src="{{ $segment->airlineData?->logo }}" alt="{{ $segment->airlineData?->name }}" width="100" class="img-fluid">
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1 text-dark fw-bold" style="color:black !important">
                                    {{ $segment->carrierCode }} {{ $segment->number }}
                                    <span class="text-muted" style="color:black !important">({{ $segment->departure->iataCode }} → {{ $segment->arrival->iataCode }})</span>
                                </h6>
                                <p class="mb-1 text-secondary">{{ $segment->airlineData?->name ?? 'N/A' }}</p>
                                <small class="text-muted d-block">
                                    <strong>Departure:</strong> <span style="color:black">{{ \Carbon\Carbon::parse($segment->departure->at)->format('d M Y H:i A') }}</span><br>
                                    <strong>Arrival:</strong> <span style="color:black">{{ \Carbon\Carbon::parse($segment->arrival->at)->format('d M Y H:i A') }}</span><br>
                                    <strong>Aircraft:</strong> <span style="color:black">{{ $segment->aircraftData->name ?? 'N/A' }}</span>
                                </small>
                            </div>
                        </div>
                    </div>
                    @php $renderedSegments[] = $segmentId; @endphp
                    @endif

                    <!-- Traveler Seat Info -->
                    <div class="row border p-3 mb-4 rounded shadow-sm bg-white">
                        <div class="col-md-6 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" name="seatDetails[{{ $index }}][traveler_name]"
                                    value="{{ ($seat->first_name ?? '') . ' ' . ($seat->last_name ?? '') }}" readonly>
                                <label>Traveler Name</label>
                            </div>
                        </div>

                        <div class="col-md-3 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" name="seatDetails[{{ $index }}][ticket_details][seat_number]"
                                    value="{{ $seat->ticket_details->seat_number ?? '' }}">
                                <label>Seat Number</label>
                            </div>
                        </div>

                        <div class="col-md-12 mb-3">
                            <div class="form-item form-float-style">
                                <textarea name="seatDetails[{{ $index }}][ticket_details][seat_charateristics]" rows="2">{{ $seat->ticket_details->seat_charateristics ?? '' }}</textarea>
                                <label>Seat Characteristics</label>
                            </div>
                        </div>

                        <div class="col-md-3 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" name="seatDetails[{{ $index }}][segmentId]"
                                    value="{{ $segmentId }}" readonly>
                                <label>Segment ID</label>
                            </div>
                        </div>

                        <div class="col-md-3 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" name="seatDetails[{{ $index }}][price_details][price]"
                                    value="{{ $seat->price_details->price ?? '' }}">
                                <label>Price</label>
                            </div>
                        </div>

                        <div class="col-md-2 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" name="seatDetails[{{ $index }}][price_details][currency]"
                                    value="{{ $seat->price_details->currency ?? '' }}">
                                <label>Currency</label>
                            </div>
                        </div>
                    </div>
                    @endif
                    @endforeach

                    <div class="col-md-4">
                        <button type="button" class="btn btn-primary update-btn">Update Seat Details</button>
                    </div>
                    @else
                    <div class="alert alert-warning" style="padding:10px; color: black">
                        No Seat Details Available
                    </div>
                    @endif
                </div>
            </div>



            <!-- Passenger Price Details -->
            <div class="tab-pane fade" id="travellerPriceDetails">
                <div class="row mb-4">
                    <div class="col">
                        <h5 class="m-0 text-start text-dark" style="color:black !important">Traveller Price Details</h5>
                    </div>
                </div>

                @php
                $flightInfoDetails = $existingBookingFullData->flightDetails->flightInfo ?? [];
                @endphp

                @if (!empty($flightInfoDetails))
                @foreach ($flightInfoDetails as $flightIndex => $flightDetail)
                @if (!empty($flightDetail->travelerPricings))
                @foreach ($flightDetail->travelerPricings as $pricingIndex => $pricing)
                <div class="p-3 border rounded mb-4 shadow-sm bg-white">
                    <h6 class="fw-bold mb-3" style="color:black !important">
                        Traveler {{ $pricing->travelerId ?? ($pricingIndex + 1) }} - {{ $pricing->travelerType ?? 'N/A' }}
                    </h6>

                 
                   

                    {{-- Price Breakdown --}}
                    <div class="row">
                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" readonly value="{{ $pricing->travelerId ?? '-' }}">
                                <label>Traveler ID</label>
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" readonly value="{{ $pricing->fareOption ?? '-' }}">
                                <label>Fare Option</label>
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" readonly value="{{ $pricing->travelerType ?? '-' }}">
                                <label>Traveler Type</label>
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" readonly value="{{ $pricing->price->base ?? '-' }}">
                                <label>Base Price</label>
                            </div>
                        </div>

                        @if(!empty($pricing->price->taxes))
                        @foreach($pricing->price->taxes as $key => $tax)
                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" readonly value="{{ is_array($tax) ? ($tax['code'] ?? '-') . ' - ' . ($tax['amount'] ?? '-') : ($tax->code ?? '-') . ' - ' . ($tax->amount ?? '-') }}">
                                <label>Tax {{ $key + 1 }}</label>
                            </div>
                        </div>
                        @endforeach
                        @endif

                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" readonly value="{{ $pricing->price->markupValue ?? '-' }}">
                                <label>Markup</label>
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" readonly value="{{ $pricing->price->totalTaxAmount ?? '-' }}">
                                <label>Total Tax</label>
                            </div>
                        </div>

                        @if(isset($pricing->price->serviceFeeType))
                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" readonly value="{{ $pricing->price->serviceFeeType === 'per_passenger' ? 'Per Passenger' : 'From Total' }}">
                                <label>Service Fee Calculation</label>
                            </div>
                        </div>
                        @endif

                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" readonly value="{{ $pricing->price->serviceFee ?? '-' }}">
                                <label>Service Fee</label>
                            </div>
                        </div>

                        <div class="col-md-4 mb-3">
                            <div class="form-item form-float-style">
                                <input type="text" readonly value="{{ ($pricing->price->currency ?? '') . ' ' . ($pricing->price->total ?? '-') }}">
                                <label>Total Price</label>
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
                @endif
                @endforeach
                @endif
            </div>



            <!-- Payment Details Tab -->
            <div class="tab-pane fade" id="paymentDetails">
                <div class="col-md-12 mb-4">
                    <h5 class="m-0 text-center text-dark" style="color:black !important">Payment Details</h5>
                </div>
                @php
                if(!empty($search_details) && $search_details['searchType'] == 'round-trip')
                {
                $totalPrice = $paymentDetails['basePriceRemovedVAT'] ?? 0;
                }
                else{

                $totalPrice = $paymentDetails['totalPrice'] ?? 0;
                }
                @endphp

                <div class="col-md-12 row mb-3">
                    <input type="hidden" value="payment_details" name="edit_type">
                    <!-- All payment detail fields -->
                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="totalPrice" type="text" id="base_fare" autocomplete="off" value="{{$paymentDetails['basePriceRemovedVAT'] ?? ''}}" readonly>
                            <label for="base_fare">Base Fare<span class="req-star">*</span></label>
                        </div>
                    </div>

                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="vatPercentage" type="text" id="vatPercentage" autocomplete="off" value="{{$paymentDetails['vatPercentage'] ?? ''}}" readonly>
                            <label for="taxes_vat_percentage">Taxes Vat (%)<span class="req-star">*</span></label>
                        </div>
                    </div>

                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="vat" type="text" id="vat" autocomplete="off" value="{{$paymentDetails['vat'] ?? ''}}" readonly>
                            <label for="taxes_vat">Taxes Vat<span class="req-star">*</span></label>
                        </div>
                    </div>

                    @php

                    $originalFlightDetails = $existingBookingFullData->flightDetails->flightInfo[0] ?? '';
                    $travellerPricings = $originalFlightDetails->travelerPricings ?? '';

                    @endphp



                    {{-- Taxes Section --}}

                    @if(!empty($travellerPricings->price->taxes))
                    @foreach($travellerPricings->price->taxes as $index => $tax)
                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input
                                name="taxes[{{ $index }}]"
                                type="text"
                                id="tax_{{ $index }}"
                                autocomplete="off"
                                readonly
                                value="{{ ($tax->code ?? '') . ' - ' . ($tax->amount ?? '') }}">
                            <label for="tax_{{ $index }}">Tax {{ $index + 1 }}<span class="req-star">*</span></label>
                        </div>
                    </div>
                    @endforeach
                    @endif


                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="markup" type="text" id="markup" autocomplete="off" value="{{$paymentDetails['markupFee']   ?? ''}}" readonly>
                            <label for="markup">Markup Fee<span class="req-star">*</span></label>
                        </div>
                    </div>

                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="markupType" type="text" id="markupType" autocomplete="off" value="{{$paymentDetails['markupType']  ?? ''}}" readonly>
                            <label for="markup">Markup Type<span class="req-star">*</span></label>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="markupValue" type="text" id="markupValue" autocomplete="off" value="{{$paymentDetails['markupValue'] ?? ''}}" readonly>
                            <label for="markup">Markup Value<span class="req-star">*</span></label>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="totalTaxAmount" type="text" id="totalTaxAmount" autocomplete="off" value="{{$paymentDetails['totalTaxAmount']  ?? ''}}" readonly>
                            <label for="taxes_vat">Total Tax Amount<span class="req-star">*</span></label>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="serviceFee" type="text" id="serviceFee" autocomplete="off" value="{{$paymentDetails['serviceFee'] ?? ''}}" readonly>
                            <label for="serviceFee">Service Fee (Service Fee + Taxes Vat)<span class="req-star">*</span></label>
                        </div>
                    </div>

                    {{-- <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="markupServiceFee" type="text" id="markupServiceFee" autocomplete="off" value="{{$paymentDetails['markupServiceFee'] ?? ''}}" readonly>
                    <span class="text-danger fw-bold" style="font-size: 0.75em;">* MarkupFee + Service Fee</span>
                    <label for="markup_service_fees">Markup Service Fee<span class="req-star">*</span></label>
                </div>
            </div> --}}


            <div class="col-md-4 mb-3">
                <div class="form-item form-float-style">
                    <input name="couponAmount" type="text" id="couponAmount" autocomplete="off" value="{{$paymentDetails['couponAmount'] ?? ''}}" readonly>
                    <label for="couponAmount">Coupon Amount</label>
                </div>
            </div>

            <div class="col-md-4 mb-3">
                <div class="form-item form-float-style">
                    <input name="walletAmount" type="text" id="walletAmount" autocomplete="off" value="{{$paymentDetails['walletAmount'] ?? ''}}" readonly>
                    <label for="walletAmount">Wallet Amount</label>
                </div>
            </div>

            <div class="col-md-4 mb-3">
                <div class="form-item form-float-style">
                    <input name="redeemAmount" type="text" id="redeemAmount" autocomplete="off" value="{{$paymentDetails['redeemAmount'] ?? ''}}" readonly>
                    <label for="redeemAmount">Redeem Amount</label>
                </div>
            </div>


            <div class="col-md-4 mb-3">
                <div class="form-item form-float-style">
                    <input name="addonAmount" type="text" id="addonAmount" autocomplete="off" value="{{$paymentDetails['addOnAmount'] ?? ''}}" readonly>
                    <label for="redeemAmount">Addon Amount</label>
                </div>
            </div>

            <div class="col-md-4 mb-3">
                <div class="form-item form-float-style">
                    <input name="bagAmount" type="text" id="bagAmount" autocomplete="off" value="{{$paymentDetails['bagAmount'] ?? ''}}" readonly>
                    <label for="bagAmount">Baggage Amount</label>
                </div>
            </div>
            <div class="col-md-4 mb-3">
                <div class="form-item form-float-style">
                    <input name="chargeableSeatPrice" type="text" id="chargeableSeatPrice" autocomplete="off" value="{{$paymentDetails['selectedSeatsTotalPrice']   ?? ''}}" readonly>
                    <label for="chargeable_seat_price">Chargeable Seat Price<span class="req-star">*</span></label>
                </div>
            </div>


            <div class="col-md-4 mb-3">
                <div class="form-item form-float-style">
                    <input name="defaultMarkup" type="text" id="defaultMarkup" autocomplete="off" value="{{ ucwords($paymentDetails['defaultMarkup'] ?? '')}}" readonly>
                    <label for="defaultMarkup">Default Markup Applied</label>
                </div>
            </div>


            <div class="col-md-4 mb-3">
                <div class="form-item form-float-style">
                    <input name="payment_brand" type="text" id="payment_brand" autocomplete="off" value="{{ ucwords($payment->payment_brand ?? '')}}" readonly>
                    <label for="payment_brand">Paid By</label>
                </div>
            </div>


            <div class="col-md-4 mb-3">
                <div class="form-item form-float-style">
                    <input name="grandTotal" type="text" id="total_paid" autocomplete="off" value="{{$paymentDetails['grandTotal'] ?? ''}}" readonly>

                    <label for="total_paid">Grand Total<span class="req-star">*</span></label>

                </div>
            </div>


            @php
            $payment_status = '';
            if($additional_details->booking_status && $additional_details->booking_status == 'confirmed')
            {
            $payment_status = "Success";
            }
            else
            {
            $payment_status = "Failed";
            }

            @endphp

            <div class="col-md-4 mb-3">
                <div class="form-item form-float-style">
                    <input name="payment_status" type="text" id="payment_status" autocomplete="off" value="{{ ucwords( $payment_status ?? '')}}" readonly>
                    <label for="payment_status">Payment Status</label>
                </div>
            </div>
            <span class="text-danger fw-bold" style="font-size: 0.7em;">Note * Grand Total = Base Fare + Service Fee + Total Tax Amount + Baggage Amount + Seat Amount + Addon Amount - ( Coupon Amount + Wallet Amount + Redeem Amount)</span>

            <hr style="border: 1px solid #000; margin: 20px 0;">

            <div class="col-md-12 mb-4">
                <h5 class="m-0 text-center text-dark" style="color:black !important">Billing Details</h5>
            </div>

            <div class="col-md-12 row mb-3">
                @foreach($billingDetails as $index => $value)
                @if(ucwords($index) !== 'State_id' && ucwords($index) !== 'Country_id')
                <div class="col-md-4 mb-3">
                    <div class="form-item form-float-style">
                        <input
                            name="billing_{{$index}}"
                            type="text"
                            id="billing_{{$index}}"
                            autocomplete="off"
                            value="{{ is_array($value) ? implode(', ', $value) : $value }}">
                        <label for="billing_{{$index}}">{{ ucwords(str_replace('_', ' ', $index)) }}<span class="req-star">*</span></label>
                    </div>
                </div>
                @endif
                @endforeach

            </div>
        </div>
        <button type="button" class="btn btn-primary update-btn">Update Payment Details</button>
    </div>



    <!-- Cancellation Policies Tab -->
    <div class="tab-pane fade" id="cancellationpolicies">
        <div class="col-md-12 mb-4">
            <h5 class="m-0 text-center text-dark" style="color: black !important">Cancellation Policies</h5>
        </div>
        <div class="col-md-12 row mb-3">
            @php
            $cancellationPolicies = $cancellationPolicy;

            @endphp
            @if(isset($cancellationPolicy->fareBasis))
            @foreach($cancellationPolicies as $fare)
            <div class="col-md-12 mb-4">
                <h6 class="mb-2" style="color: black !important">
                    Fare: {{ $fare->fareBasis ?? 'N/A' }} - {{ $fare->fareName ?? '' }}
                </h6>

                <table class="table">
                    <thead style="background-color: #343A40; color: #fff;">
                        <tr>
                            <th>Type</th>
                            <th>Before Departure</th>
                            <th>No Show</th>
                            <th>After Departure</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach(['changes' => 'Change / Amend', 'cancellations' => 'Cancellation'] as $key => $label)
                        @php
                        $pen = $fare->penalties->$key ?? null;
                        @endphp
                        <tr>
                            <td style="color: black !important">{{ $label }}</td>
                            @foreach(['beforeDeparture', 'noShow', 'afterDeparture'] as $field)
                            @php
                            $val = $pen->$field ?? null;
                            @endphp
                            <td style="color: black !important">
                                @if(is_object($val))
                                {{ $val->amount ?? '-' }} {{ $val->currency ?? '' }}
                                @else
                                {{ $val ?? ($key === 'changes' ? 'Non-Amendable' : 'Non-Refundable') }}
                                @endif
                            </td>
                            @endforeach
                        </tr>
                        @endforeach
                    </tbody>
                </table>

                @if(isset($fare->originalText))
                <div class="accordion mt-2" id="accordionFare{{ $loop->index }}">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingFare{{ $loop->index }}">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFare{{ $loop->index }}" aria-expanded="false" aria-controls="collapseFare{{ $loop->index }}" style="font-weight: 500;">
                                Original Text
                            </button>
                        </h2>
                        <div id="collapseFare{{ $loop->index }}" class="accordion-collapse collapse" aria-labelledby="headingFare{{ $loop->index }}" data-bs-parent="#accordionFare{{ $loop->index }}">
                            <div class="accordion-body">
                                <pre style="white-space: pre-wrap;">{{ $fare?->originalText }}</pre>
                            </div>
                        </div>
                    </div>
                </div>

                @endif
            </div>
            @endforeach
            @else
            <div class="alert alert-warning">No Farebasis found!..</div>
            @endif




        </div>
    </div>



    </div>
    </div>
    </div>

    <!-- <div class="cards-btn mt-3">

                        <button type="button" id="updateButton" class="btn btn-success form-btn-success" data-bs-toggle="modal" data-bs-target="#confirmUpdateModal">Submit All</button>
                        <a href="{{ route('booking.index') }}" type="button" class="btn btn-danger form-btn-danger">Cancel</a>
                    </div> -->
    </form>
    </div>
    </div>
    </div>
    <!-- /.row -->
    </div>

    <!-- Modal -->
    <div class="modal fade" id="confirmUpdateModal" tabindex="-1" aria-labelledby="confirmUpdateModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmUpdateModalLabel">Confirm Update</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="color: black !important">
                    Are you sure you want to update all details?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="button" id="confirmUpdate" class="btn btn-success">Update</button>
                </div>
            </div>
        </div>
    </div>
    <!--/. container-fluid -->
</section>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/toastr@2.1.4/toastr.min.js"></script>




<style>
    /* Loader Styling */
    #loaderOverlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(190, 190, 190, 0.53);
        /* Red background with opacity */
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
        display: none;
        /* Initially hidden */

    }

    .loader {
        border: 6px solid #f3f3f3;
        border-top: 6px solid #000;
        /* Black loader */
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
</style>

<!-- Loader Overlay -->
<div id="loaderOverlay">
    <div class="loader"></div>
</div>





<script>
    document.addEventListener("DOMContentLoaded", function() {
        $('.selectDropDown').selectpicker();
        document.querySelectorAll(".update-btn, .update-flight-btn").forEach(button => {
            button.addEventListener("click", function() {
                let activeTab = this.closest(".tab-pane");
                let formData = new FormData();

                let csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute("content");
                formData.append('_token', csrfToken);

                activeTab.querySelectorAll("input, select, textarea").forEach(input => {
                    formData.append(input.name, input.value);
                });

                // Create and show loader
                let loader = document.createElement("div");
                loader.innerHTML = `
                <div class="loader-overlay">
                    <div class="loader"></div>
                </div>
            `;
                document.body.appendChild(loader);

                fetch("/update-flight-details/{{$booking_id}}", {
                        method: "POST",
                        body: formData,
                        headers: {
                            "X-CSRF-TOKEN": csrfToken
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        toastr.success('Flight Details Updated Successfully');
                        window.location.reload();

                    })
                    .catch(error => console.error("Error:", error))
                    .finally(() => {
                        // Remove loader after request completion
                        document.querySelector(".loader-overlay").remove();
                    });
            });
        });

    });
</script>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        const serviceFeeInput = document.getElementById("serviceFee");
        const markupInput = document.getElementById("markup");
        const markupServiceFeeInput = document.getElementById("markupServiceFee");

        function updateMarkupServiceFee() {
            let serviceFee = parseFloat(serviceFeeInput.value) || 0;
            let markup = parseFloat(markupInput.value) || 0;
            markupServiceFeeInput.value = (serviceFee + markup).toFixed(2);
        }

        serviceFeeInput.addEventListener("input", updateMarkupServiceFee);
        markupInput.addEventListener("input", updateMarkupServiceFee);
    });


    document.addEventListener("DOMContentLoaded", function() {

        const baseFareInput = document.getElementById("base_fare");
        const vatInput = document.getElementById("vat");
        const totalTaxAmountInput = document.getElementById("totalTaxAmount");
        const chargeableSeatPriceInput = document.getElementById("chargeableSeatPrice");
        const markupInput = document.getElementById("markup");
        const couponInput = document.getElementById("couponAmount");
        const addonInput = document.getElementById("addonAmount");
        const walletInput = document.getElementById("walletAmount");
        const redeemInput = document.getElementById("redeemAmount");
        const bagInput = document.getElementById('bagAmount');
        const serviceFeeInput = document.getElementById("serviceFee");
        const grandTotalInput = document.getElementById("total_paid");


        function safeParseFloat(value) {
            return value === "" || isNaN(parseFloat(value)) ? 0 : parseFloat(value);
        }


        function updateGrandTotal() {
            let baseFare = safeParseFloat(baseFareInput.value);
            let vat = safeParseFloat(vatInput.value);
            let totalTaxAmount = safeParseFloat(totalTaxAmountInput.value);

            let chargeableSeatPrice = safeParseFloat(chargeableSeatPriceInput.value);
            let markup = safeParseFloat(markupInput.value);
            let serviceFee = safeParseFloat(serviceFeeInput.value);
            let coupon = safeParseFloat(couponInput.value);
            let addon = safeParseFloat(addonInput.value);
            let wallet = safeParseFloat(walletInput.value);
            let redeem = safeParseFloat(redeemInput.value);
            let bag = safeParseFloat(bagInput.value);


            let grandTotal = baseFare + chargeableSeatPrice + markup + serviceFee + totalTaxAmount + addon + bag - (coupon + wallet + redeem);

            // Set correct value
            grandTotalInput.value = grandTotal.toFixed(2);
        }


        const inputs = [baseFareInput, chargeableSeatPriceInput, markupInput, serviceFeeInput, totalTaxAmountInput, bagInput, couponInput, addonInput, walletInput, redeemInput];

        inputs.forEach(input => {
            input.addEventListener("input", function() {

                if (this.value.trim() === "") {
                    this.value = "0";
                }
                updateGrandTotal();
            });

            input.addEventListener("change", updateGrandTotal);
        });


        //updateGrandTotal();
    });

    $('body').on('click', '.cancel-booking', function() {
        const id = $(this).attr('data-id');
        Swal.fire({
            title: "Are you sure to cancel this booking?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, Cancel it!"
        }).then((result) => {
            if (result.isConfirmed) {
                const currentUrl = new URL(location.href);
                location.href = `${currentUrl.origin}/booking/cancel-booking/${id}`;
            }
        });
        return false;
    });
</script>
<script>
    function toggleNote(noteId) {
        var shortText = document.getElementById(noteId + '_short');
        var fullText = document.getElementById(noteId + '_full');

        if (shortText && fullText) {
            // Toggle visibility of short and full text
            if (shortText.style.display === 'none') {
                shortText.style.display = 'inline';
                fullText.style.display = 'none';
            } else {
                shortText.style.display = 'none';
                fullText.style.display = 'inline';
            }
        }
    }
</script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        function calculateDuration(departureInput, arrivalInput, durationField) {
            const departureValue = departureInput.value;
            const arrivalValue = arrivalInput.value;

            if (departureValue && arrivalValue) {
                const departureTime = new Date(departureValue);
                const arrivalTime = new Date(arrivalValue);

                if (!isNaN(departureTime) && !isNaN(arrivalTime)) {
                    const diffMs = arrivalTime - departureTime;
                    if (diffMs >= 0) {
                        const diffMins = Math.floor(diffMs / 60000);
                        const hours = Math.floor(diffMins / 60);
                        const minutes = diffMins % 60;
                        durationField.value = `${hours} h ${minutes} m`;
                    } else {
                        durationField.value = "Invalid time range";
                    }
                } else {
                    durationField.value = "Invalid date input";
                }
            }
        }

        function calculateLayover(layoverBox) {
            const arrivalInputId = layoverBox.getAttribute('data-current-arrival-id');
            const nextDepartureInputId = layoverBox.getAttribute('data-next-departure-id');

            const arrivalInput = document.getElementById(arrivalInputId);
            const nextDepartureInput = document.getElementById(nextDepartureInputId);
            const layoverTextSpan = layoverBox.querySelector('.layover-duration');

            if (arrivalInput && nextDepartureInput && layoverTextSpan) {
                const arrivalTime = new Date(arrivalInput.value);
                const nextDepartureTime = new Date(nextDepartureInput.value);

                if (!isNaN(arrivalTime) && !isNaN(nextDepartureTime)) {
                    const diffMs = nextDepartureTime - arrivalTime;
                    if (diffMs >= 0) {
                        const diffMins = Math.floor(diffMs / 60000);
                        const hours = Math.floor(diffMins / 60);
                        const minutes = diffMins % 60;
                        layoverTextSpan.textContent = `${hours} hrs ${minutes} mins`;
                    } else {
                        layoverTextSpan.textContent = "Invalid layover";
                    }
                } else {
                    layoverTextSpan.textContent = "Invalid input";
                }
            }
        }

        const segmentBoxes = document.querySelectorAll('.segment-box');
        segmentBoxes.forEach(box => {
            const departureInput = box.querySelector('.departure-time');
            const arrivalInput = box.querySelector('.arrival-time');
            const durationField = box.querySelector('.duration-field');

            if (departureInput && arrivalInput && durationField) {
                const handler = () => {
                    calculateDuration(departureInput, arrivalInput, durationField);
                    updateAllLayovers();
                };

                departureInput.addEventListener('change', handler);
                arrivalInput.addEventListener('change', handler);
            }
        });

        function updateAllLayovers() {
            const layoverBoxes = document.querySelectorAll('.layover-box');
            layoverBoxes.forEach(calculateLayover);
        }

        updateAllLayovers();
    });
</script>




@append