@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">
<link href="
https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.css
" rel="stylesheet">

<style>
    .form-item input.is-valids+label {
        font-size: 11px;
        top: -5px;
    }

    .list-group a:hover {
        background-color: #335476 !important;
        color: white !important;
    }

    input[readonly] {
        background-color: #f5f5f5;
        color: #999;

        cursor: not-allowed;
    }
</style>
<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
                <h1 class="m-0">Booking Details - Edit</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="/booking ">Booking Details - Edit</a></li>
                    <li class="breadcrumb-item active">Edit Hotel</li>
                </ol>
                <!-- /.col -->

                <div class="col d-flex justify-content-end">
                    <button class="btn btn-primary" target="_blank">Booked At: {{ \Carbon\Carbon::parse($additional_details->created_at ?? '')->format('d M Y, h:i A') }}</button>
                </div>
            </div>
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            <div class="card pb-4 pt-3 px-3 w-100">
                <form id="bookingForm" action="#" class="form row pt-3 mb-0 validate" enctype="multipart/form-data" method="post">
                    @method('PUT')
                    @csrf
                    <div class="row">
                        <!-- Sidebar -->
                        <div class="col-md-3">
                            <div class="list-group" style="position: sticky; top:60px;">
                                <a href="#customerDetails" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="background-color: #335476 !important; color: white !important">
                                    <i class="fas fa-user"></i> Customer Details
                                </a>
                                <a href="#hotelDetails" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                    <i class="fas fa-hotel"></i> Hotel Details
                                </a>
                                <a href="#paymentDetails" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                    <i class="fas fa-credit-card"></i> Payment Details
                                </a>
                                <a href="#cancellationpolicies" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                    <i class="fas fa-file-alt"></i> Cancellation Policies
                                </a>
                                @if($additional_details->booking_status == 'confirmed' && now()->format('Y-m-d') < $booking_detail->booking_start_date)

                                    <a href="#" class="list-group-item list-group-item-action cancel-booking" data-id="{{ $additional_details->id }}" title="Cancel" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="color: white !important">
                                        <i class="fas fa-times-circle"></i> Cancel Booking
                                    </a>
                                    @endif


                            </div>
                        </div>

                        <!-- Tab Content -->
                        <div class="col-md-9 tab-content">
                            <!-- Customer Details Tab -->
                            <div class="tab-pane fade show active" id="customerDetails">
                                <div class="row mb-4">
                                    <div class="col">
                                        <h5 class="m-0 text-start text-dark" style="color:black !important">Customer Details</h5>
                                    </div>



                                </div>
                                <input type="hidden" name="edit_type" value="customer_details" readonly>

                                <div class="col-md-12 row mb-3">
                                    <div class="col-md-4">
                                        <div class="form-item form-float-style">
                                            <input name="booking_ref" type="text" id="booking_ref" autocomplete="off" value="{{$additional_details->booking_ref ?? ''}}" readonly>
                                            <label for="booking_ref">Rehlte Trip ID<span class="req-star">*</span></label>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-item form-float-style">
                                            <input name="booking_type" type="text" id="booking_type" autocomplete="off" value="{{ ucwords($additional_details->booking_type ?? '')}}" readonly>
                                            <label for="booking_type">Service Name<span class="req-star">*</span></label>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-item form-float-style">
                                            <input name="service_provider" type="text" id="service_provider" autocomplete="off" value="{{$additional_details->service_provider ?? ''}}" readonly>
                                            <label for="service_provider">GDS System<span class="req-star">*</span></label>
                                        </div>
                                    </div>

                                </div>

                                <div class="col-md-12 row mb-3">

                                    <div class="col-md-4">
                                        <div class="form-item form-float-style">
                                            <input name="supplier_provider" type="text" id="supplier_provider" autocomplete="off" value="{{$supplier_provider ?? 'N/A'}}" readonly>
                                            <label for="supplier_provider">Supplier Provider<span class="req-star">*</span></label>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-item form-float-style">
                                            <input name="supplier_booking_associated_ref" type="text" id="supplier_booking_associated_ref" autocomplete="off" value="{{$additional_details->supplier_booking_associated_ref ?? ''}}" readonly>
                                            <label for="supplier_booking_associated_ref">Supplier Reference<span class="req-star">*</span></label>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-item form-float-style">
                                            <input name="ticket_no" type="text" id="ticket_no" autocomplete="off" value="{{$additional_details->ticker_numbers ?? ''}}">
                                            <label for="ticket_no">Ticket Number<span class="req-star">*</span></label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-12 row mb-3">
                                    <div class="col-md-4">
                                        <div class="form-item form-float-style">
                                            <input name="supplier_id" type="text" id="supplier_id" autocomplete="off" value="{{ ucwords($additional_details->booking_status ?? '')}}" readonly>
                                            <label for="supplier_id" readonly>Booking Status<span class="req-star">*</span></label>
                                        </div>
                                    </div>

                                    {{--<div class="col-md-4">
                                        <div class="form-item form-float-style">
                                            <input name="booking_date" type="date" id="booking_date" autocomplete="off" value="{{$booking_detail->booking_date ?? ''}}">
                                    <label for="booking_date">Booking Date<span class="req-star">*</span></label>
                                </div>
                            </div>--}}

                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="first_name" type="text" id="first_name" autocomplete="off" value="{{$booking_detail->first_name}}">
                                    <label for="first_name">Customer First Name<span class="req-star">*</span></label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="last_name" type="text" id="last_name" autocomplete="off" value="{{$booking_detail->last_name ?? ''}}">
                                    <label for="last_name">Customer Last Name<span class="req-star">*</span></label>
                                </div>
                            </div>

                        </div>

                        <div class="col-md-12 row mb-3">


                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="customer_email" type="text" id="customer_email" autocomplete="off" value="{{$booking_detail->email ?? ''}}">
                                    <label for="customer_email">Customer Email<span class="req-star">*</span></label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="phoneNumber" type="text" id="customer_email" autocomplete="off" value="{{$customer_details['phoneNumber'] ?? ''}}">
                                    <label for="phoneNumber">Customer Phone Number<span class="req-star">*</span></label>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="nationality" type="text" id="nationality" autocomplete="off" value="{{$customer_details['country_name'] ?? ($customer_details['nationality'] ?? '')}}" readonly>
                                    <label for="nationality">Nationality</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="booking_date_time" type="text" id="booking_date_time" autocomplete="off"
                                        value="{{ \Carbon\Carbon::parse($additional_details->created_at ?? '')->format('d M Y, h:i A') }}" readonly>

                                    <label for="booking_date_time">Booking Date and Time</label>
                                </div>
                            </div>

                            @php
                            $bookingFrom = '';
                            if(isset($additional_details->booking_from)){
                            $bookingVia = $additional_details->booking_from;
                            if($bookingVia == 'web'){
                            $bookingFrom = 'B2C Desktop';
                            } elseif($bookingVia == 'b2c_mobile_browser'){
                            $bookingFrom = 'B2C Mobile Browser';
                            } elseif($bookingVia == 'b2c_mobile_app'){
                            $bookingFrom = 'B2C Mobile App';
                            } else{
                            $bookingFrom = '';
                            }
                            }
                            @endphp
                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="booking_from" type="text" id="booking_from" autocomplete="off" value="{{ucwords($bookingFrom) ?? ''}}" readonly>
                                    <label for="booking_from">Booking From</label>
                                </div>
                            </div>
                        </div>


                        @php
                        $specialRequests = $customer_details['specialRequests'] ?? [];

                        @endphp
                        @if(!empty($specialRequests))
                        <div class="row">
                            <div class="col my-4">
                                <h5 class="m-0 text-start text-dark" style="color:black !important">Special Request</h5>
                            </div>
                            @foreach($specialRequests as $specialRequest)

                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="{{ $specialRequest['special_request_name']}}" type="text" id="king_size_bed" autocomplete="off" value="{{isset($specialRequest['special_request_name']) ? 'Yes':'No'}}" readonly>
                                    <label for="{{ $specialRequest['special_request_name'] }}">{{ $specialRequest['special_request_name'] }}</label>
                                </div>
                            </div>
                            @endforeach
                        </div>
                        @endif


                        <div class="col-md-12 text-start">
                            <button type="button" class="btn btn-primary update-btn">Update Customer Details</button>
                        </div>
                    </div>

                    @php



                    $searchDetails = $search_details;
                    $hotelDetails = $hotel_details['hotelDetails'];

                    $roomDetails = $hotel_details['selectedRooms'];

                    $cancellationPolicies = $hotel_details['cancellationPolicy'] ?? [];

                    $paymentDetails = $processed_price;
                    $billingDetails = $billing_details;
                    @endphp

                    <?php
                    // echo "<pre>";
                    // print_r($cancellationPolicies);
                    // echo "</pre>";
                    // exit()

                    ?>

                    <!-- Hotel Details Tab -->
                    <div class="tab-pane fade" id="hotelDetails">
                        <div class="col-md-12 mb-4">
                            <h5 class="m-0 text-center text-dark" style="color: black !important;">Booking Hotel Details</h5>
                        </div>
                        <div class="col-md-12 mb-4">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6 style="color: black !important;">Hotel Details </h6>
                                </div>
                                <div class="col-md-6 text-right">
                                    <h6 style="color: black !important;">Hotel Name: {{$hotelDetails['DisplayName']}}</h6>
                                </div>
                            </div>
                            <div class="row">
                                <div class="border-0 shadow-sm mt-3">
                                    <div class="card-body">
                                        <div class="row g-3 align-items-start">
                                            <!-- Hotel Image -->
                                            <div class="col-md-3">
                                                <img src="{{$hotelDetails['DefaultImage']['FullSize'] ?? 'https://via.placeholder.com/300x200'}}"
                                                    alt="Hotel Image" class="img-fluid rounded shadow-sm">
                                            </div>

                                            <!-- Hotel Details -->
                                            <div class="col-md-9">
                                                <span class="badge bg-info text-light mb-2">{{$hotelDetails['PropertyType'] ?? 'Hotel'}}</span>
                                                <h5 class="fw-bold mb-1" style="color:black">
                                                    {{$hotelDetails['DisplayName'] ?? ''}}
                                                    <span class="text-warning fs-6">
                                                        @php
                                                        $starRating = $hotelDetails['StarRating'] ?? 0;
                                                        @endphp

                                                        @for ($i = 1; $i <= 5; $i++)
                                                            @if ($i <=$starRating)
                                                            <i class="bi bi-star-fill text-warning"></i>
                                                            @else
                                                            <i class="bi bi-star text-warning"></i>
                                                            @endif
                                                            @endfor
                                                    </span>
                                                </h5>
                                                <p class="mb-2 small" style="color:black">
                                                    {{$hotelDetails['Address'] ?? ''}}
                                                </p>
                                                @php
        

                                                $checkIn = isset($searchDetails['checkInDate'])
                                                ? \Carbon\Carbon::parse($searchDetails['checkInDate'])
                                                : \Carbon\Carbon::parse($searchDetails['stay']['checkIn'] ?? null);

                                                $checkOut = isset($searchDetails['checkOutDate'])
                                                ? \Carbon\Carbon::parse($searchDetails['checkOutDate'])
                                                : \Carbon\Carbon::parse($searchDetails['stay']['checkOut'] ?? null);

                                                $nights = $checkIn && $checkOut ? $checkIn->diffInDays($checkOut) : 0;
                                                @endphp
                                                <div class="d-flex flex-wrap gap-3 text-muted small">
                                                    <div style="color:black"><i class="bi bi-calendar-check"></i> <strong>Check In:</strong> {{$checkIn->format('d/m/Y')}}</div>
                                                    <div style="color:black"><i class="bi bi-calendar-x"></i> <strong>Check Out:</strong> {{$checkOut->format('d/m/Y')}}</div>
                                                    <div style="color:black"><i class="bi bi-moon"></i> <strong>Number of Nights:</strong> {{ $nights }}</div>
                                                    <div style="color:black"><i class="bi bi-people"></i> <strong>Persons:</strong> {{$roomDetails['AdultsCount'] ?? ''}}</div>
                                                </div>

                                                <p class="mt-3 mb-3 small" style="color:black">
                                                    <strong>Room Type:</strong> {{$roomDetails['RoomBasis'] ?? ''}}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <input type="hidden" name="edit_type" value="hotel_details" readonly>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="hotel_name" type="text" id="hotel_name" autocomplete="off" value="{{$hotelDetails['DisplayName'] ?? ''}}">
                                    <label for="hotel_name">Hotel Name</label>
                                </div>
                                <div class="form-item form-float-style form-group">
                                    <select data-live-search="true" name="city" id="city" class="order-td-input select-text height_drp is-valid select2 selectDropDown" style="width: 100%;">
                                        <option value="{{$searchDetails['city'] ?? ''}}">{{$searchDetails['city'] ?? ''}}</option>
                                        @foreach ($cityDetails as $city)
                                        <option value="{{ $city->city_name_en }}">{{ $city->city_name_en }}</option>
                                        @endforeach
                                    </select>
                                    <label for="city" class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">City</label>
                                </div>

                                <div class="form-item form-float-style">
                                    <input name="children" type="number" id="children" autocomplete="off" value="{{$searchDetails['occupancies'][0]['children'] ?? 0}}">
                                    <label for="children">Children</label>
                                </div>



                            </div>

                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="Address" type="text" id="hotel_address" autocomplete="off" value="{{$hotelDetails['Address'] ?? ''}}">
                                    <label for="hotel_address">Hotel Address</label>
                                </div>


                                <div class="form-item form-float-style form-group">
                                    <select data-live-search="true" name="country" id="country" class="order-td-input select-text height_drp is-valid select2 selectDropDown" style="width: 100%;">
                                        <option value="{{$searchDetails['nationality'] ?? ''}}">{{$searchDetails['nationality'] ?? ''}}</option>
                                        @foreach ($countryDetails as $country)
                                        <option value="{{ $country->country_name_en }}">{{ $country->country_name_en }}</option>
                                        @endforeach
                                    </select>
                                    <label for="city" class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Country</label>
                                </div>

                                <div class="form-item form-float-style">
                                    <input name="check_in" type="date" id="check_in" autocomplete="off" value="{{$searchDetails['checkInDate'] ?? $searchDetails['stay']['checkIn']}}">
                                    <label for="check_in">Check In</label>
                                </div>


                            </div>

                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="HotelId" type="text" id="HotelId" autocomplete="off" value="{{$roomDetails['HotelId'] ?? ''}}" readonly>
                                    <label for="HotelId">Hotel ID</label>
                                </div>
                                <div class="form-item form-float-style">
                                    <input name="adult" type="number" id="adult" autocomplete="off" value="{{$searchDetails['occupancies'][0]['adults'] ?? 0}}">
                                    <label for="adult">Adult</label>
                                </div>
                                <div class="form-item form-float-style">
                                    <input name="check_out" type="date" id="check_out" autocomplete="off" value="{{$searchDetails['checkOutDate'] ?? $searchDetails['stay']['checkOut']}}">
                                    <label for="check_out">Check Out</label>
                                </div>


                            </div>

                            <hr style="border: 1px solid #000; margin: 20px 0;">
                            @if(!empty($searchDetails['occupancies']) && is_array($searchDetails['occupancies']))
                            <div class="row">
                                <div class="col-md-6">
                                    <h6 style="color: black !important;">Occupancy Details </h6>
                                </div>
                            </div>

                            <div class="row">
                                @foreach($searchDetails['occupancies'] as $index => $room)
                                <div class="col-md-6 mb-4">
                                    <div class="card p-3 bg-white text-dark shadow-sm border rounded h-100">
                                        <h6 class="mb-2" style="color: black;">Room {{ $index + 1 }}</h6>
                                        <ul class="mb-0">

                                            <li><strong>Adults:</strong> <span style="color: black;">{{ $room['adults'] ?? 0 }}</span></li>
                                            <li><strong>Children:</strong> <span style="color: black;">{{ $room['children'] ?? 0 }}</span></li>

                                            @if(!empty($room['paxes']) && is_array($room['paxes']))
                                            <li><strong>Children Ages:</strong>
                                                @foreach($room['paxes'] as $pax)
                                                @if(($pax['type'] ?? '') === 'CH')
                                                <span class="badge badge-secondary">{{ $pax['age'] ?? 'N/A' }} yrs</span>
                                                @endif
                                                @endforeach
                                            </li>
                                            @endif
                                            <li><strong>Nationality:</strong> <span style="color: black;">{{$customer_details['country_name'] ?? ($customer_details['nationality'] ?? '')}}</span></li>
                                        </ul>
                                    </div>
                                </div>
                                @endforeach
                            </div>

                            @else
                            <p>No room details available.</p>
                            @endif
                            <hr style="border: 1px solid #000; margin: 20px 0;">
                            <!-- Room Details -->
                            <div class="col-md-12 mb-4">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 style="color: black !important;">Room Details </h6>
                                    </div>
                                    <div class="col-md-6 text-right">
                                        <h6 style="color: black !important;">Hotel Name: {{$hotelDetails['DisplayName']}}</h6>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="RoomName" type="text" id="RoomName" autocomplete="off" value="{{$roomDetails['RoomName'] ?? ''}}" readonly>
                                    <label for="RoomName">Room Name</label>
                                </div>

                                <div class="form-item form-float-style">
                                    <input name="RoomBasis" type="text" id="RoomClass" autocomplete="off" value="{{$roomDetails['RoomClass'] ?? ''}}" readonly>
                                    <label for="RoomClass">Room Class</label>
                                </div>

                            </div>
                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="RoomBasis" type="text" id="RoomBasis" autocomplete="off" value="{{$roomDetails['RoomBasis'] ?? ''}}" readonly>
                                    <label for="RoomBasis">Room Basis</label>
                                </div>
                                <div class="form-item form-float-style">
                                    <input name="BedType" type="text" id="RoomBasis" autocomplete="off" value="{{$roomDetails['BedType'] ?? ''}}" readonly>
                                    <label for="BedType">Bed Type</label>
                                </div>

                            </div>

                            <div class="col-md-4">
                                <div class="form-item form-float-style">
                                    <input name="RoomType" type="text" id="RoomType" autocomplete="off" value="{{$roomDetails['RoomType'] ?? ''}}" readonly>
                                    <label for="RoomType">Room Type</label>
                                </div>
                                <div class="form-item form-float-style">
                                    <input name="TargetRoomKey" type="text" id="TargetRoomKey" autocomplete="off" value="{{$roomDetails['TargetRoomKey'] ?? ''}}" readonly>
                                    <label for="TargetRoomKey">Room Key</label>
                                </div>
                            </div>

                        </div>
                        <div class="col-md-12 text-start">
                            <button type="button" class="btn btn-primary update-btn">Update Hotel Details</button>
                        </div>
                    </div>

                    <!-- Payment Details Tab -->
                    <div class="tab-pane fade" id="paymentDetails">
                        <div class="col-md-12 mb-4">
                            <h5 class="m-0 text-center text-dark" style="color:black !important">Payment Details</h5>
                        </div>


                        <div class="col-md-12 row mb-3">
                            <input type="hidden" value="payment_details" name="edit_type">
                            <!-- All payment detail fields -->
                            <div class="col-md-4 mb-3">
                                <div class="form-item form-float-style">
                                    <input name="totalPrice" type="text" id="base_fare" autocomplete="off" value="{{($paymentDetails['beforePrice'] == 0 || $paymentDetails['beforePrice'] == '') ? $paymentDetails['totalPrice'] : $paymentDetails['beforePrice']}}" readonly>
                                    <label for="base_fare">Base Fare<span class="req-star">*</span></label>
                                </div>
                            </div>

                            {{-- <div class="col-md-4 mb-3">
                                        <div class="form-item form-float-style">
                                            <input name="vatPercentage" type="text" id="vatPercentage" autocomplete="off" value="{{$paymentDetails['vatPercentage'] ?? ''}}" readonly>
                            <label for="taxes_vat_percentage">Taxes Vat (%)<span class="req-star">*</span></label>
                        </div>
                    </div>

                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="vat" type="text" id="vat" autocomplete="off" value="{{$paymentDetails['vat'] ?? ''}}" readonly>
                            <label for="taxes_vat">Taxes Vat<span class="req-star">*</span></label>
                        </div>
                    </div>

                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="totalTaxAmount" type="text" id="totalTaxAmount" autocomplete="off" value="{{$paymentDetails['totalTaxAmount']  ?? ''}}" readonly>
                            <label for="taxes_vat">Total Tax Amount<span class="req-star">*</span></label>
                        </div>
                    </div> --}}



                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="markupType" type="text" id="markupType" autocomplete="off" value="{{$paymentDetails['markupFee'] == 0 ? 'N/A' : $paymentDetails['markupType']  ?? ''}}" readonly>
                            <label for="markup">Markup Type<span class="req-star">*</span></label>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="markupValue" type="text" id="markupValue" autocomplete="off" value="{{$paymentDetails['markupValue'] ?? ''}}" readonly>
                            <label for="markup">Markup Value<span class="req-star">*</span></label>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="markup" type="text" id="markup" autocomplete="off" value="{{$paymentDetails['markupFee']   ?? ''}}" readonly>
                            <label for="markup">Markup Fee<span class="req-star">*</span></label>
                        </div>
                    </div>
                    <div class="col-md-4 mb-3">
                        <div class="form-item form-float-style">
                            <input name="serviceFee" type="text" id="serviceFee" autocomplete="off" value="{{$paymentDetails['serviceFee'] ?? ''}}" readonly>
                            <label for="serviceFee">Service Fee<span class="req-star">*</span></label>
                        </div>
                    </div>

                    {{--<div class="col-md-4 mb-3">
                                        <div class="form-item form-float-style">
                                            <input name="markupServiceFee" type="text" id="markupServiceFee" autocomplete="off" value="{{$paymentDetails['markupServiceFee'] ?? ''}}" readonly>
                    <span class="text-danger fw-bold" style="font-size: 0.75em;">* MarkupFee + Service Fee</span>
                    <label for="markup_service_fees">Markup Service Fee<span class="req-star">*</span></label>
            </div>
        </div> --}}

        <div class="col-md-4 mb-3">
            <div class="form-item form-float-style">
                <input name="couponAmount" type="text" id="couponAmount" autocomplete="off" value="{{$paymentDetails['couponAmount'] ?? ''}}" readonly>
                <label for="couponAmount">Coupon Amount</label>
            </div>
        </div>

        <div class="col-md-4 mb-3">
            <div class="form-item form-float-style">
                <input name="walletAmount" type="text" id="walletAmount" autocomplete="off" value="{{$paymentDetails['walletAmount'] ?? ''}}" readonly>
                <label for="walletAmount">Wallet Amount</label>
            </div>
        </div>

        <div class="col-md-4 mb-3">
            <div class="form-item form-float-style">
                <input name="redeemAmount" type="text" id="redeemAmount" autocomplete="off" value="{{$paymentDetails['redeemAmount'] ?? ''}}" readonly>
                <label for="redeemAmount">Redeem Amount</label>
            </div>
        </div>


        <div class="col-md-4 mb-3">
            <div class="form-item form-float-style">
                <input name="addonAmount" type="text" id="addonAmount" autocomplete="off" value="{{$paymentDetails['addOnAmount'] ?? ''}}" readonly>
                <label for="redeemAmount">Addon Amount</label>
            </div>
        </div>



        <div class="col-md-4 mb-3">
            <div class="form-item form-float-style">
                <input name="defaultMarkup" type="text" id="defaultMarkup" autocomplete="off" value="{{ ucwords($paymentDetails['defaultMarkup'] ?? '')}}" readonly>
                <label for="defaultMarkup">Default Markup Applied</label>
            </div>
        </div>


        <div class="col-md-4 mb-3">
            <div class="form-item form-float-style">
                <input name="payment_brand" type="text" id="payment_brand" autocomplete="off" value="{{ ucwords($payment->payment_brand ?? '')}}" readonly>
                <label for="payment_brand">Paid By</label>
            </div>
        </div>


        <div class="col-md-4 mb-3">
            <div class="form-item form-float-style">
                <input name="grandTotal" type="text" id="total_paid" autocomplete="off" value="{{$paymentDetails['grandTotal'] ?? ''}}" readonly>

                <label for="total_paid">Grand Total<span class="req-star">*</span></label>

            </div>
        </div>


        @php
        $payment_status = '';
        if($additional_details->booking_status && $additional_details->booking_status == 'confirmed')
        {
        $payment_status = "Success";
        }
        else
        {
        $payment_status = "Failed";
        }

        @endphp

        <div class="col-md-4 mb-3">
            <div class="form-item form-float-style">
                <input name="payment_status" type="text" id="payment_status" autocomplete="off" value="{{ ucwords($payment_status ?? '')}}" readonly>
                <label for="payment_status">Payment Status</label>
            </div>
        </div>
        <span class="text-danger fw-bold" style="font-size: 0.7em;">*Note: Grand Total = Base Fare + Service Fee + Markup Fee + Addon Amount - (Coupon Amount + Wallet Amount + Redeem Amount)</span>
        <hr style="border: 1px solid #000; margin: 20px 0;">

        <div class="col-md-12 mb-4">
            <h5 class="m-0 text-center text-dark" style="color:black !important">Billing Details</h5>
        </div>

        <div class="col-md-12 row mb-3">
            @foreach($billingDetails as $index => $value)
            @if(ucwords($index) !== 'State_id' && ucwords($index) !== 'Country_id')
            <div class="col-md-4 mb-3">
                <div class="form-item form-float-style">
                    <input
                        name="billing_{{$index}}"
                        type="text"
                        id="billing_{{$index}}"
                        autocomplete="off"
                        value="{{ is_array($value) ? implode(', ', $value) : $value }}">
                    <label for="billing_{{$index}}">{{ ucwords(str_replace('_', ' ', $index)) }}<span class="req-star">*</span></label>
                </div>
            </div>

            @endif
            @endforeach


        </div>
    </div>
    <button type="button" class="btn btn-primary update-btn">Update Payment Details</button>
    </div>

    

    <!-- Cancellation Policies Tab -->
    <div class="tab-pane fade" id="cancellationpolicies">
        <div class="col-md-12 mb-4">
            <h5 class="m-0 text-center text-dark" style="color: black !important">Cancellation Policies</h5>
        </div>
        <div class="col-md-12 row mb-3">
            @if (!empty($cancellationPolicies) && is_array($cancellationPolicies))



            {{-- Cancellation Policies --}}
            @php
            $date = '';
            $policies = $cancellationPolicies['CancellationPolicies'] ?? [];

            $originalPolicies = $cancellationPolicies['CancellationPoliciesOriginal'] ?? [];
            if(!empty($originalPolicies))
            {
            $rawDate = $originalPolicies[0]['DateFrom'];
            preg_match('/\/Date\((\d+)(?:[+-]\d+)?\)\//', $rawDate, $matches);

            if (isset($matches[1])) {

            $timestamp = $matches[1] / 1000;

            $date = Carbon\Carbon::createFromTimestamp($timestamp);
            }
            }

            @endphp

            @if (!empty($policies))
            <h5 class="mb-2">Cancellation Policies</h5>
            <div class="row">
                @foreach ($policies as $policy)
                <div class="col-md-12 mb-3">
                    <div class="form-item form-float-style">
                        <input
                            type="text"
                            readonly
                            value="Title: {{ $policy['Title'] ?? '' }} | Amount: {{ $policy['Amount'] ?? '' }} {{ $policy['Currency'] ?? '' }}">
                        <label class="form-label">Cancellation Policy</label>
                    </div>

                    <div class="form-item">
                        @if ($policy['Refundable'])
                        <p style="color:black">
                            Free Cancellation <strong>{{ $policy['Subtitle'] ?? '-' }}</strong>,

                            Otherwise the below cancellation policy applies.

                        </p>
                        <p style="color:black">
                            <strong>Refundable Amount:</strong> {{ $policy['Amount'] ?? '0' }} {{ $policy['Currency'] ?? '' }}
                        </p>
                        @else
                        <p style="color:black">
                            @if($date)
                            If the reservation is cancelled <strong>{{ $policy['Subtitle'] ?? '-' }}</strong>,
                            a cancellation penalty of <strong>{{ $policy['Amount'] ?? 0 }} {{ $policy['Currency'] ?? '' }}</strong> will apply.
                            @endif
                        </p>
                        @endif

                        @if (!empty($policy['Comments']))
                        <p style="color:black"><em>{{ $policy['Comments'] }}</em></p>
                        @endif
                    </div>
                </div>
                @endforeach

            </div>
            @else
            <div class="alert alert-warning">No cancellation policies found.</div>
            @endif

            {{-- Booking Remarks --}}
            @if (!empty($cancellationPolicies['BookingRemarks']))
            <div class="mb-4">
                <h5 class="mb-2" style="color:black">Booking Remarks</h5>
                @php
                $bookingRemarks = $cancellationPolicies['BookingRemarks'] ?? '';
                $maxLength = 400;
                $isLong = strlen(strip_tags($bookingRemarks)) > $maxLength;
                $uniqueId = 'remarks_' . uniqid();
                @endphp

                <div class="px-3 border rounded bg-light" style="white-space: pre-wrap; font-size: 14px;">
                    @if($isLong)
                    <span id="{{ $uniqueId }}_short">
                        {!! Str::limit(strip_tags($bookingRemarks), $maxLength)!!}...
                        <a href="javascript:void(0);" onclick="toggleRemarks('{{ $uniqueId }}')">See More</a>
                    </span>
                    <span id="{{ $uniqueId }}_full" style="display: none;">
                        {!! $bookingRemarks!!}
                        <a href="javascript:void(0);" onclick="toggleRemarks('{{ $uniqueId }}')">See Less</a>
                    </span>
                    @else
                    {!! $bookingRemarks !!}
                    @endif
                </div>

            </div>
            @endif

            @else
            <div class="alert alert-warning">Cancellation policy data not available.</div>
            @endif

        </div>
    </div>
    </div>

    </div>




    <!-- Confirmation Modal -->
    <div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmModalLabel">Confirm Update</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" style="color: black !important">
                    Are you sure you want to update all details?
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Confirm Update</button>
                </div>
            </div>
        </div>
    </div>
    </form>
    </div>
    </div>
    </div>
    <!-- /.row -->
    </div>
    <!--/. container-fluid -->
</section>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

<script src="https://cdn.jsdelivr.net/npm/toastr@2.1.4/toastr.min.js"></script>




<style>
    /* Loader Styling */
    #loaderOverlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(190, 190, 190, 0.53);
        /* Red background with opacity */
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 9999;
        display: none;
        /* Initially hidden */
    }

    .loader {
        border: 6px solid #f3f3f3;
        border-top: 6px solid #000;
        /* Black loader */
        border-radius: 50%;
        width: 50px;
        height: 50px;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }
</style>

<!-- Loader Overlay -->
<div id="loaderOverlay">
    <div class="loader"></div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        $('.selectDropDown').selectpicker();
        document.querySelectorAll(".update-btn").forEach(button => {
            button.addEventListener("click", function() {
                let activeTab = this.closest(".tab-pane");
                let formData = new FormData();

                let csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute("content");
                formData.append('_token', csrfToken);

                activeTab.querySelectorAll("input, select, textarea").forEach(input => {
                    formData.append(input.name, input.value);
                });

                // Create and show loader
                let loader = document.createElement("div");
                loader.innerHTML = `
                <div class="loader-overlay">
                    <div class="loader"></div>
                </div>
            `;
                document.body.appendChild(loader);

                fetch("/update-hotel-details/{{$booking_id}}", {
                        method: "POST",
                        body: formData,
                        headers: {
                            "X-CSRF-TOKEN": csrfToken
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        toastr.success('Hotel Details Updated Successfully');
                        window.location.reload();

                    })
                    .catch(error => console.error("Error:", error))
                    .finally(() => {
                        // Remove loader after request completion
                        document.querySelector(".loader-overlay").remove();
                    });
            });
        });

        $('body').on('click', '.cancel-booking', function() {
            const id = $(this).attr('data-id');
            Swal.fire({
                title: "Are you sure to cancel this booking?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, Cancel it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    const currentUrl = new URL(location.href);
                    location.href = `${currentUrl.origin}/booking/cancel-booking/${id}`;
                }
            });
            return false;
        });
    });
</script>


<script>
    document.addEventListener("DOMContentLoaded", function() {
        const serviceFeeInput = document.getElementById("serviceFee");
        const markupInput = document.getElementById("markup");
        const markupServiceFeeInput = document.getElementById("markupServiceFee");

        function updateMarkupServiceFee() {
            let serviceFee = parseFloat(serviceFeeInput.value) || 0;
            let markup = parseFloat(markupInput.value) || 0;
            markupServiceFeeInput.value = (serviceFee + markup).toFixed(2);
        }

        serviceFeeInput.addEventListener("input", updateMarkupServiceFee);
        markupInput.addEventListener("input", updateMarkupServiceFee);
    });


    document.addEventListener("DOMContentLoaded", function() {

        const baseFareInput = document.getElementById("base_fare");
        const vatInput = document.getElementById("vat");
        const totalTaxAmountInput = document.getElementById("totalTaxAmount");
        const chargeableSeatPriceInput = document.getElementById("chargeableSeatPrice");
        const markupInput = document.getElementById("markup");
        // const markupValueInput = document.getElementById("markupValue");
        const couponInput = document.getElementById("couponAmount");
        const addonInput = document.getElementById("addonAmount");
        const walletInput = document.getElementById("walletAmount");
        const redeemInput = document.getElementById("redeemAmount");
        const serviceFeeInput = document.getElementById("serviceFee");
        const grandTotalInput = document.getElementById("total_paid");


        function safeParseFloat(value) {
            return value === "" || isNaN(parseFloat(value)) ? 0 : parseFloat(value);
        }


        function updateGrandTotal() {
            let baseFare = safeParseFloat(baseFareInput.value);
            let vat = safeParseFloat(vatInput.value);
            let totalTaxAmount = safeParseFloat(totalTaxAmountInput.value);

            let chargeableSeatPrice = safeParseFloat(chargeableSeatPriceInput.value);
            let markup = safeParseFloat(markupInput.value);
            // let markupValue = safeParseFloat(markupValueInput.value);
            let serviceFee = safeParseFloat(serviceFeeInput.value);
            let coupon = safeParseFloat(couponInput.value);
            let addon = safeParseFloat(addonInput.value);
            let wallet = safeParseFloat(walletInput.value);
            let redeem = safeParseFloat(redeemInput.value);


            let grandTotal = baseFare + vat + chargeableSeatPrice + markup + serviceFee + totalTaxAmount + addon - coupon - wallet - redeem;

            // Set correct value
            grandTotalInput.value = grandTotal.toFixed(2);
        }


        const inputs = [baseFareInput, vatInput, chargeableSeatPriceInput, markupInput, serviceFeeInput, totalTaxAmountInput, couponInput, addonInput, walletInput, redeemInput];

        inputs.forEach(input => {
            input.addEventListener("input", function() {

                if (this.value.trim() === "") {
                    this.value = "0";
                }
                updateGrandTotal();
            });

            input.addEventListener("change", updateGrandTotal);
        });


        updateGrandTotal();


        $('body').on('click', '.cancel-booking', function() {
            const id = $(this).attr('data-id');
            Swal.fire({
                title: "Are you sure to cancel this booking?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, Cancel it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    const currentUrl = new URL(location.href);
                    location.href = `${currentUrl.origin}/booking/cancel-booking/${id}`;
                }
            });
            return false;
        });

    });
</script>
<script>
    function toggleRemarks(id) {
        var shortSpan = document.getElementById(id + '_short');
        var fullSpan = document.getElementById(id + '_full');

        if (shortSpan && fullSpan) {
            if (shortSpan.style.display === 'none') {
                shortSpan.style.display = 'inline';
                fullSpan.style.display = 'none';
            } else {
                shortSpan.style.display = 'none';
                fullSpan.style.display = 'inline';
            }
        }
    }
</script>



@append