@extends('admin.layout.main')
@section('title',$title)

@section('css')
<!-- DataTables -->
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">

<link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" rel="stylesheet" />

<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<style>
    .dataTables_filter {
        margin-left: 10px;
        float: right;
    }

    .datatable-container {
        padding: 0 !important;
        font-size: 13px;
    }

    .dataTables_info {
        float: left;
    }

    tr:nth-of-type(even) {
        color: #212529;
    }

    div.dataTables_wrapper div.dataTables_filter,
    div.dataTables_wrapper div.dataTables_info {
        color: #000;
    }

    .table-bordered tr th {
        background-color: #fff;
        color: #212529;
    }

    .table-bordered td,
    .table-bordered th {
        border: 1px solid #dee2e6;
    }

    .table-bordered {
        border: 1px solid #dee2e6;
    }

    .booking-status {
        font-weight: bold;
    }

    .booking-status.confirmed {
        color: #4CAF50;
    }

    .booking-status.pending {
        color: #1679AB;
    }

    .booking-status.cancelled,
    .booking-status.failed {
        color: #D71920;
    }

    .booking-status span {
        font-weight: normal !important;
    }

    .table> :not(caption)>*>* {
        padding: 0.4rem 0.7rem !important;
    }

    .refund-booking {
        font-weight: bold;
        text-decoration: underline !important;
    }

    .swal2-input:focus {
        color: #FFF !important;
    }

    .dark-mode .daterangepicker .calendar-table td,
    .dark-mode .daterangepicker .calendar-table th {
        color: white !important;
        background-color: black;
    }

    .table-condensed tbody tr .active {
        background-color: #0088CC !important;
        color: #fff !important;
        border: 1px solid #006699;
        border-radius: 4px;
    }
</style>
@endsection
@section('content')
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
                <h1 class="m-0">{{ $heading }}</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">@lang('customers.dashboard') </a></li>
                    <li class="breadcrumb-item active">Booking </li>
                </ol>
                <div class="breadcrumb-btn">

                    <button class="btn btn-primary" id="show-hide-filters">
                        Show Filters
                    </button>&nbsp;
                    <button type="button" class="btn btn-success" id="exportBookings">Export Excel</button>
                    <div class="modal fade" id="exportModal" tabindex="-1" role="dialog" aria-labelledby="exportModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="exportModalLabel">Export Bookings</h5>
                                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form id="exportForm">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label style="color: black !important;">Export Type <span class="required text-danger">*</span></label>
                                                    <select class="form-control" name="export_type" required id="export_type">
                                                        <option value="">Select Export Type</option>
                                                        <option value="all">All Bookings</option>
                                                        <option value="today">Today's Bookings</option>
                                                        <option value="week">This Week's Bookings</option>
                                                        <option value="month">This Month's Bookings</option>
                                                        <option value="year">This Year's Bookings</option>

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;" class="datepicker is-valids">Booking Date</label>
                                                    <input type="date" class="form-control" name="booking_date">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;">Supplier</label>
                                                    <select class="form-control" name="supplier_id">
                                                        <option value="">Select Supplier</option>
                                                        @foreach($supplierDataList as $supplier)
                                                        <option value="{{ $supplier['id'] }}">{{ $supplier['name'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;">Service Type</label>
                                                    <select class="form-control" name="service_id">
                                                        <option value="">Select Service</option>
                                                        @foreach($getServiceType as $service)
                                                        <option value="{{ $service['id'] }}">{{ $service['name'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;">Booking ID</label>
                                                    <input type="text" class="form-control" name="booking_id">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;">Ticket Number</label>
                                                    <input type="text" class="form-control" name="ticket_numbers">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;">System Ref ID</label>
                                                    <input type="text" class="form-control" name="system_ref_id">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;">Price Range From</label>
                                                    <input type="number" class="form-control" name="price_from">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;">Price Range To</label>
                                                    <input type="number" class="form-control" name="price_to">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;">PNR Number</label>
                                                    <input type="text" class="form-control" name="pnr_number">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;">Customer Name</label>
                                                    <input type="text" class="form-control" name="customer_name">
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;">Booking Status</label>
                                                    <select class="form-control" data-live-search="true" id="export_booking_status" name="booking_status" class="order-td-input select-text height_drp is-valid">
                                                        <option value="" selected disabled>Select Status</option>
                                                        <option value="pending">Pending</option>
                                                        <option value="processing">Processing</option>
                                                        <option value="confirmed">Confirmed</option>
                                                        <option value="supplier_failed">Failed (Supplier failed)</option>
                                                        <option value="payment_failed">Failed (Supplier success and Payment failed)</option>
                                                        {{-- <option value="cancelled">Cancelled</option> --}}
                                                        <option value="cancelled not refunded">Cancelled not refunded</option>
                                                        <option value="cancelled and refunded">Cancelled and refunded</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label style="color: black !important;">Agency</label>
                                                    <select class="form-control" name="agency_id">
                                                        <option value="">Select Agency</option>
                                                        @foreach($getAgency as $agency)
                                                        <option value="{{ $agency['id'] }}">{{ $agency['name'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                    <button type="button" class="btn btn-primary" id="submitExport">Export</button>
                                </div>
                            </div>
                        </div>
                    </div>



                </div>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

@if (session('success'))
<div class="m-3 alert alert-success" role="alert">
    <?php echo session('success'); ?>
</div>
@endif
@if (session('error'))
<div class="m-3 alert alert-danger" role="alert">
    {{ session('error') }}
</div>
@endif
@if (isset($error))
<div class="m-3 alert alert-danger" role="alert">
    {{ $error }}
</div>
@endif

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            <div class="col-12 pt-3 pb-3 card">
                <div class="discount">
                    <div class="row">

                        <div class="col-md-12 filter-container d-none">
                            <!-- general form elements -->
                            <div class="card card-primary">
                                <!-- form start -->
                                <form id="booking_filter_form">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>Booking Date</label>
                                                    <!-- <input type="text" class="form-control datepicker is-valids" name="booking_date" id="booking_date" value="{{ @$_GET['booking_date'] }}" class="is-valid" placeholder="DD/MM/YYYY" autocomplete="off"> -->
                                                    <div id="reportrange" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc; width: 100%; color:black">
                                                        <i class="fa fa-calendar"></i>&nbsp;
                                                        <span></span> <i class="fa fa-caret-down"></i>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <!-- select -->
                                                <div class="form-group">
                                                    <label>Supplier</label>
                                                    <select class="form-control" id="supplier_id" name="supplier_id" required>
                                                        <option value="">{{ __('select') }}</option>
                                                        @foreach($supplierDataList as $data)
                                                        <option value="{{ $data['id'] }}">{{ $data['name'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>Service Type</label>
                                                    <select class="form-control" id="service_id" name="service_id" required>
                                                        <option value="" selected disabled>Select Service Type</option>
                                                        @foreach($getServiceType as $data)
                                                        <option value="{{ $data['id'] }}">{{ $data['name'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>Booking Ref ID</label>
                                                    <input type="text" class="form-control is-valids" name="booking_id" id="booking_id" value="" class="is-valid" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>Ticket Number</label>
                                                    <input type="text" class="form-control is-valids" name="ticket_number" id="ticket_number" value="" class="is-valid" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>System Ref ID</label>
                                                    <input type="text" class="form-control is-valids" name="system_ref_id" id="system_ref_id" value="" class="is-valid" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>Price Range From</label>
                                                    <input type="text" class="form-control is-valids" name="price_from" id="price_from" value="" class="is-valid" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>Price Range To</label>
                                                    <input type="text" class="form-control is-valids" name="price_to" id="price_to" value="" class="is-valid" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>PNR Number</label>
                                                    <input type="text" class="form-control is-valids" name="pnr_number" id="pnr_number" value="" class="is-valid" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>Customer Name</label>
                                                    <input type="text" class="form-control is-valids" name="customer_id" id="customer_id" value="" class="is-valid" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>Booking Status</label>
                                                    <select class="form-control" data-live-search="true" id="booking_status" name="booking_status" class="order-td-input select-text height_drp is-valid">
                                                        <option value="" selected disabled>Select Status</option>
                                                        <option value="pending">Pending</option>
                                                        <option value="processing">Processing</option>
                                                        <option value="confirmed">Confirmed</option>
                                                        <option value="supplier_failed">Failed (Supplier failed)</option>
                                                        <option value="payment_failed">Failed (Supplier success and Payment failed)</option>
                                                        {{-- <option value="cancelled">Cancelled</option> --}}
                                                        <option value="cancelled not refunded">Cancelled not refunded</option>
                                                        <option value="cancelled and refunded">Cancelled and refunded</option>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>Agency Name</label>
                                                    <select class="form-control" id="agency_id" name="agency_id" required>
                                                        <option value="" selected disabled>Select Agency Name</option>
                                                        @foreach($getAgency as $data)
                                                        <option value="{{ $data['id'] }}" @if($appliedFilter['agency_id']==$data['id']) selected="selected" @endif>{{ $data['full_name'] }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-sm-4">
                                                <div class="form-group">
                                                    <label>Sales Channel</label>
                                                    <select class="form-control" id="channel" name="channel" required>
                                                        <option value="" selected disabled>Select Channel</option>

                                                        <option value="web">Desktop</option>
                                                        <option value="b2c_mobile_browser">Mobile Browser</option>
                                                        <option value="b2c_mobile_app">Mobile App</option>

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /.card-body -->

                                    <div class="card-footer">
                                        <button type="button" id="search" class="btn btn-primary float-right" style="margin-left: 5px;">Search</button>
                                        <button type="button" id="clear" class="btn btn-warning float-right">Clear</button>
                                    </div>
                                </form>
                            </div>
                            <!-- /.card -->
                        </div>

                        <div class="col-12 datatable-container">
                            <div class="table-card">
                                <!-- /.card-header -->
                                <div class="card-body p-0">
                                    <!-- <table class="table table-head-fixed text-nowrap"> -->
                                    <table class="table table-bordered table-striped" id="booking_table" style="width:100%">
                                        <thead>
                                            <tr>
                                                <th>{{ __('S.No.') }}</th>  
                                                <th>{{ __('Service') }}</th>
                                                <th>{{ __('Booking Ref ID') }}</th>
                                                <th>{{ __('Booking Status') }}</th>
                                                <th>{{ __('PNR') }}</th>
                                                <th>{{ __('Ticket Number(s)') }}</th>
                                                <th>{{ __('System Ref ID') }}</th>
                                                <th>{{ __('GDS') }}</th>
                                                <th>{{ __('Supplier') }}</th>
                                                <th>{{ __('Booking Amount') }}</th>
                                                <th>{{ __('Cancelled Amount') }}</th>
                                                <th>{{ __('Refund Amount') }}</th>
                                                <th>{{ __('Is Guest') }}</th>
                                                <th>{{ __('Email') }}</th>
                                                <th>{{ __('Phone') }}</th>
                                                <th>{{ __('Description') }}</th>
                                                <th>{{ __('Booking Date') }}</th>
                                                <th>{{ __('Sales Channel') }}</th>
                                                <th>{{ __('Action') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody></tbody>
                                    </table>

                                </div>

                                <!-- /.card-body -->
                            </div>
                            <!-- /.card -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!--/. container-fluid -->
</section>

<!-- Modal for Editing Status -->
<div class="modal fade" id="editStatusModal" tabindex="-1" role="dialog" aria-labelledby="editStatusModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editStatusModalLabel">Edit Status</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>

            </div>
            <div class="modal-body">
                <form id="statusForm">
                    <div class="form-group">
                        <label for="statusSelect">Status</label>
                        <select class="form-control" id="statusSelect" name="status" required>
                            <option value="">Select the status</option>
                            <option value="confirmed">Confirmed</option>
                            <option value="supplier_failed">Failed (Supplier failed)</option>
                            <option value="payment_failed">Failed (Supplier success and Payment failed)</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="descriptionInput">Notes</label>
                        <textarea class="form-control" id="descriptionInput" name="description"></textarea>
                    </div>
                    <input type="hidden" id="bookingId" name="booking_id">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </form>
            </div>
        </div>
    </div>
</div>



@endsection
@section('js')

<!-- DataTables  & Plugins -->
<script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/plugins/pdfmake/pdfmake.min.js') }}"></script>
<script src="{{ asset('assets/plugins/pdfmake/vfs_fonts.js')}}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.colVis.min.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script type="text/javascript">
    // Open the Edit Status Modal
    $('body').on('click', '.btn-status-edit', function() {
        const bookingId = $(this).data('id');
        const currentStatus = $(this).data('status');
        const currentDescription = $(this).data('description');


        $('#bookingId').val(bookingId);
        $('#statusSelect').val(currentStatus);
        $('#descriptionInput').val(currentDescription);

        // Show the modal
        $('#editStatusModal').modal('show');
    });

    // Handle the form submission for updating booking status
    $('#statusForm').on('submit', function(e) {
        e.preventDefault();

        const bookingId = $('#bookingId').val();
        const status = $('#statusSelect').val();
        const description = $('#descriptionInput').val();
        const baseURL = `${window.location.origin}`;


        $.ajax({
            // url: '{{ route("booking.update.status")}}',  
            url: `${baseURL}/booking/update-status`,
            method: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                booking_id: bookingId,
                status: status,
                description: description
            },
            success: function(response) {
                $('#editStatusModal').modal('hide');
                $('#booking_table').DataTable().draw();
                // alert('Booking status updated successfully!');
                toastr.success('Booking status updated successfully!');
            },
            error: function() {
                toastr.error('Error updating the booking status');
            }
        });
    });





    $(document).ready(function() {
        $(function() {
            const urlParams = new URLSearchParams(window.location.search);
            const fromDate = urlParams.get('from');
            const toDate = urlParams.get('to');

            let start = null;
            let end = null;

            if (fromDate && toDate) {
                start = moment(fromDate, 'YYYY-MM-DD');
                end = moment(toDate, 'YYYY-MM-DD');
            }

            function cb(start, end) {
                const allStart = moment('2000-01-01');
                const allEnd = moment('2100-01-01');

                if (start.isSame(allStart, 'day') && end.isSame(allEnd, 'day')) {
                    $('#reportrange span').html('All Dates');
                } else {
                    $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                }


                const newUrl = new URL(window.location.href);
                newUrl.searchParams.set('from', start.format('YYYY-MM-DD'));
                newUrl.searchParams.set('to', end.format('YYYY-MM-DD'));
                window.history.replaceState({}, '', newUrl);
            }

            $('#reportrange').daterangepicker({
                autoUpdateInput: false,
                startDate: start || moment(),
                endDate: end || moment(),
                ranges: {
                    'All Dates': [moment('2000-01-01'), moment('2100-01-01')],
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
                }
            }, cb);

            // Set default text
            if (start && end) {
                cb(start, end);
            } else {
                $('#reportrange span').html('All Dates');
            }
        });




        const urlParams = new URLSearchParams(window.location.search);

        setTimeout(function() {
            if (!$.fn.dataTable.isDataTable('#booking_table')) {
                table = dataTable_record();
            } else {
                table = $('#booking_table').DataTable();
            }
        }, 300);


        $('#show-hide-filters').on('click', function() {
            //table.draw();
            if ($('.filter-container').hasClass("d-none")) {
                $('.filter-container').removeClass("d-none");
                $('#show-hide-filters').html('Hide Filters');
            } else {
                $('.filter-container').addClass("d-none");
                $('#show-hide-filters').html('Show Filters');
            }
        });
        $('#search').on('click', function() {
            //table.draw();

            $('#booking_table').dataTable().fnFilter(this.value);
            $('html, body').animate({
                scrollTop: $('#booking_table').offset().top - 100
            }, 500);
        });
        $('#clear').on('click', function() {

            $('#booking_filter_form')[0].reset();

            $('#booking_table').dataTable().fnFilter(this.value);
            window.location.href = '/booking';
        });
        $('body').on('click', '.refund-booking', async function() {
            const id = $(this).attr('data-id');
            const inputValue = $(this).attr('data-amount');
            const {
                value: processedCancelAmount
            } = await Swal.fire({
                title: "Are you sure to refund this booking?",
                input: "text",
                inputLabel: "Refund Amount:",
                inputValue,
                showCancelButton: true,
                inputValidator: (value) => {
                    if (!value) {
                        return "Please enter refund amount.";
                    }
                }
            });
            if (processedCancelAmount) {
                const currentUrl = new URL(location.href);
                location.href = `${currentUrl.origin}/booking/refund-booking/${id}?amount=${processedCancelAmount}`;
            }
            return false;
        });
        $('body').on('click', '.cancel-booking', function() {
            const id = $(this).attr('data-id');
            Swal.fire({
                title: "Are you sure to cancel this booking?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonColor: "#3085d6",
                cancelButtonColor: "#d33",
                confirmButtonText: "Yes, Cancel it!"
            }).then((result) => {
                if (result.isConfirmed) {
                    const currentUrl = new URL(location.href);
                    location.href = `${currentUrl.origin}/booking/cancel-booking/${id}`;
                }
            });
            return false;
        });
    });

    const urlParams = new URLSearchParams(window.location.search);
    const bookingStatus = urlParams.get('booking_status');
    const fromDate = urlParams.get('from');
    const toDate = urlParams.get('to');
    let booking_type = urlParams.get('type');

    if (bookingStatus) {
        $("#booking_status").val(bookingStatus).trigger('change');
    }

    if (booking_type) {
        if (booking_type == 'flight')
            $("#service_id").val(1).trigger('change');
        else if (booking_type)
            $("#service_id").val(2).trigger('change');;

    }

    function dataTable_record() {
        const base_url = `${window.location.origin}`;

        return $('#booking_table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            "sScrollX": '100%',
            "sScrollXInner": "100%",
            scrollX: true,
            scrollXInner: "100%",
            scrollCollapse: true,
            fixedHeader: {
                header: true,
                headerOffset: $('.main-header').height()
            },

            ajax: {
                url: `${base_url}/booking`,
                type: 'GET',
                data: function(d) {
                    const dateRangeText = $("#reportrange span").text();
                    const [fromDate, toDate] = dateRangeText.split(" - ").map(date => date.trim());

                    d.supplier_id = $("#supplier_id option:selected").val();
                    d.service_id = $("#service_id option:selected").val();
                    d.supplier_booking_associated_ref = $("#supplier_booking_associated_ref").val();
                    d.ticket_numbers = $("#ticket_numbers").val();
                    d.system_ref_id = $("#system_ref_id").val();
                    d.booking_id = $("#booking_id").val();
                    d.price_from = $("#price_from").val();
                    d.price_to = $("#price_to").val();
                    d.pnr_number = $("#pnr_number").val();
                    d.customer_id = $("#customer_id").val();
                    d.booking_status = $("#booking_status option:selected").val();
                    d.agency_id = $("#agency_id option:selected").val();
                    d.channel = $("#channel option:selected").val();
                    d.fromDate = fromDate;
                    d.toDate = toDate;
                    d.booking_type = booking_type
                },
                error: function(xhr, status, error) {
                    console.error("DataTables AJAX Error:", error);
                    alert("Failed to load data. Please try again.");
                }
            },
            columns: [{
                    "data": 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    "data": "booking_type"
                },
                {
                    "data": "booking_ref"
                },
                {
                    "data": "booking_status"
                },
                {
                    "data": "supplier_booking_associated_ref"
                },
                {
                    "data": "ticket_numbers"
                },
                {
                    "data": "supplier_booking_ref"
                },
                {
                    "data": "supplier_id"
                },
                {
                    "data": "supplier"
                },
                {
                    "data": "total"
                },
                {
                    "data": "booking_cancel_amount"
                },
                {
                    "data": "processed_cancel_amount"
                },
                {
                    "data": "is_guest"
                },
                {
                    "data": "email"
                },
                {
                    "data": "phone"
                },
                {
                    "data": "description"
                },
                {
                    "data": "booking_date"
                },
                {
                    "data": "booking_from"
                },

                {
                    "data": "action",
                    orderable: false
                }
            ],
            lengthMenu: [
                [10, 25, 50, -1],
                [10, 25, 50, 'All']
            ],
            order: [],
            responsive: false,
            lengthChange: false,
            autoWidth: false,
            dom: 'lfBrtip',
            buttons: {
                buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
                dom: {
                    button: {
                        className: 'd-none'
                    }
                }
            },
            searching: true,
            drawCallback: function(settings) {
                // Add horizontal scrollbar to header and sync scrolling
                if (!$('.dataTables_scrollHead').hasClass('added-scroll')) {
                    $('.dataTables_scrollHead').addClass('added-scroll');
                    $('.dataTables_scrollHead').css('overflow-x', 'auto');

                    // Sync scrolling between header and body
                    $('.dataTables_scrollHead').on('scroll', function() {
                        $('.dataTables_scrollBody').scrollLeft($(this).scrollLeft());
                    });
                    $('[data-bs-toggle="tooltip"]').tooltip();
                }
            }
        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    }
</script>

<script>
    $(document).ready(function() {
        // Show export modal when button clicked
        $('#exportBookings').click(function() {
            $('#exportModal').modal('show');
        });

        // Handle export form submission
        $('#submitExport').click(function() {

            const export_type = $('#export_type').val();
            console.log(export_type);
            if (!export_type) {
                toastr.error('Please select export type');
                return;
            }

            var formData = $('#exportForm').serialize();
            window.location.href = '/export-bookings?' + formData;
            $('#exportModal').modal('hide');
        });


    });
</script>
@endsection
@section('js')
@append