@extends('admin.layout.main')
@section('title',$title)

@section('css')
<!-- DataTables -->
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
<style>
.dataTables_filter {
    margin-left: 10px;
    float: right;
}
.datatable-container {
    padding: 0 !importat;
    font-size: 13px;
}
.dataTables_info{
    float:left;
}
tr:nth-of-type(even) {
    color: #212529;
}
div.dataTables_wrapper div.dataTables_filter, div.dataTables_wrapper div.dataTables_info {
    color: #000;
}
.table-bordered tr th {
    background-color: #fff;
    color: #212529;
}
.table-bordered td, .table-bordered th {
    border: 1px solid #dee2e6;
}
.table-bordered {
    border: 1px solid #dee2e6;
}
.booking-status.confirmed {
    font-weight: bold;
    color: #4CAF50;
}
.booking-status.cancelled {
    font-weight: bold;
    color: #D71920;
}
.booking-status span {
    font-weight: normal !important;
}
.table> :not(caption)>*>* {
    padding: 0.4rem 0.7rem !important;
}
</style>
@endsection
@section('content')
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-4 mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
              <h1 class="m-0">{{ $heading }}</h1>
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">@lang('customers.dashboard') </a></li>
                <li class="breadcrumb-item active">Booking </li>
              </ol>
              <div class="breadcrumb-btn">
                <button class="btn btn-primary" id="show-hide-filters">
                    Show Filters
                </button>
              </div>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

        <div class="m-3 alert alert-success" role="alert">
            test content
        </div>
        @if (session('success'))
            <div class="m-3 alert alert-success" role="alert">
                <?php echo session('success'); ?>
            </div>
        @endif
        @if (session('error'))
            <div class="m-3 alert alert-danger" role="alert">
                {{ session('error') }}
            </div>
        @endif
        @if (isset($error))
            <div class="m-3 alert alert-danger" role="alert">
                {{ $error }}
            </div>
        @endif

      <!-- Main content -->
      <section class="content">
        <div class="container-fluid">
          <!-- Info boxes -->
          <div class="row">
            <div class="col-12 pt-3 pb-3 card">
              <div class="discount">
                <div class="row">

                    <div class="col-md-12 filter-container d-none">
                        <!-- general form elements -->
                        <div class="card card-primary">
                            <!-- form start -->
                            <form id="booking_filter_form">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>Booking Date</label>
                                                <input type="text" class="form-control datepicker is-valids" name="booking_date" id="booking_date" value="{{ @$_GET['booking_date'] }}" class="is-valid" placeholder="DD/MM/YYYY" autocomplete="off">
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <!-- select -->
                                            <div class="form-group">
                                                <label>Supplier</label>
                                                <select class="form-control" id="supplier_id" name="supplier_id" required>
                                                    <option value="">{{ __('select') }}</option>
                                                    @foreach($supplierDataList as $data)
                                                        <option value="{{ $data['id'] }}">{{ $data['name'] }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>Service Type</label>
                                                <select class="form-control" id="service_id" name="service_id" required>
                                                    <option value="" selected disabled>Select Service Type</option>
                                                    @foreach($getServiceType as $data)
                                                    <option value="{{ $data['id'] }}">{{ $data['name'] }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>System Ref ID</label>
                                                <input type="text" class="form-control is-valids" name="system_ref_id" id="system_ref_id" value="" class="is-valid" autocomplete="off">
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>Booking ID</label>
                                                <input type="text" class="form-control is-valids" name="booking_id" id="booking_id" value="" class="is-valid" autocomplete="off">
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>Price Range From</label>
                                                <input type="text" class="form-control is-valids" name="price_from" id="price_from" value="" class="is-valid" autocomplete="off">
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>Price Range To</label>
                                                <input type="text" class="form-control is-valids" name="price_to" id="price_to" value="" class="is-valid" autocomplete="off">
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>PNR Number</label>
                                                <input type="text" class="form-control is-valids" name="pnr_number" id="pnr_number" value="" class="is-valid" autocomplete="off">
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>Customer Name</label>
                                                <input type="text" class="form-control is-valids" name="customer_id" id="customer_id" value="" class="is-valid" autocomplete="off">
                                            </div>
                                        </div>
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>Booking Status</label>
                                                <select class="form-control" data-live-search="true" id="booking_status" name="booking_status" class="order-td-input select-text height_drp is-valid">
                                                    <option value="" selected disabled>Select Status</option>
                                                    <option value="pending">Pending</option>
                                                    <option value="processing">Processing</option>
                                                    <option value="confirmed">Confirmed</option>
                                                    <option value="failed">Failed</option>
                                                    <option value="cancelled">Cancelled</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>Agency Name</label>
                                                <select class="form-control" id="agency_id" name="agency_id" required>
                                                    <option value="" selected disabled>Select Agency Name</option>
                                                    @foreach($getAgency as $data)
                                                    <option value="{{ $data['id'] }}" @if($appliedFilter['agency_id'] == $data['id']) selected="selected" @endif >{{ $data['full_name'] }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- /.card-body -->

                                <div class="card-footer">
                                <button type="button" id="search" class="btn btn-primary float-right" style="margin-left: 5px;">Search</button>
                                <button type="button" id="clear" class="btn btn-warning float-right">Clear</button>
                                </div>
                            </form>
                        </div>
                        <!-- /.card -->
                    </div>

                    <div class="col-12 datatable-container">
                    <div class="table-card">
                      <!-- /.card-header -->
                      <div class="card-body p-0">
                        <!-- <table class="table table-head-fixed text-nowrap"> -->
                        <table class="table table-bordered table-striped" id="booking_table" style="width:100%">
                        <thead>
                            <tr>
                            <th>{{ __('Sl. No.') }}</th>
                                <th>{{ __('Service') }}</th>
                                <th>{{ __('System Ref ID') }}</th>
                                <th>{{ __('Booking Status') }}</th>
                                <th>{{ __('Booking Ref ID') }}</th>
                                <th>{{ __('Supplier') }}</th>
                                <th>{{ __('Price') }}</th>
                                <th>{{ __('Is Guest') }}</th>
                                <th>{{ __('Email') }}</th>
                                <th>{{ __('Phone') }}</th>
                                <th>{{ __('Description') }}</th>
                                <th>{{ __('Booking Date') }}</th>
                                <th>{{ __('PNR Number') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                          <tbody></tbody>
                        </table>

                      </div>

                      <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                  </div>
                </div>
              </div>
            </div>
          </div>
          <!-- /.row -->
        </div>
        <!--/. container-fluid -->
      </section>
  @endsection
  @section('js')

<!-- DataTables  & Plugins -->
<script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/plugins/pdfmake/pdfmake.min.js') }}"></script>
<script src="{{ asset('assets/plugins/pdfmake/vfs_fonts.js')}}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.colVis.min.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script type="text/javascript">
$(document).ready(function(){

    var table = $('#booking_table').DataTable({
        processing: true,
        serverSide: true,
        responsive: true,
        //paging: false,
        // pageLength: 25,
        "sScrollX": '100%',
        ajax: {
          url: "{{ route('booking-test.index') }}",
          type: 'GET',
          data: function (d) {
            d.booking_date = $("#booking_date").val();
            d.supplier_id = $("#supplier_id option:selected").val();
            d.service_id = $("#service_id option:selected").val();
            d.system_ref_id = $("#system_ref_id").val();
            d.booking_id = $("#booking_id").val();
            d.price_from = $("#price_from").val();
            d.price_to = $("#price_to").val();
            d.pnr_number = $("#pnr_number").val();
            d.customer_id = $("#customer_id").val();
            d.booking_status = $("#booking_status option:selected").val();
            d.agency_id = $("#agency_id option:selected").val();
          }
        },
        columns: [
            {data: 'DT_RowIndex', name: 'DT_RowIndex'},
            {"data": "booking_type"},
            {"data": "supplier_booking_ref"},
            {"data": "booking_status"},
            {"data": "booking_ref"},
            {"data": "supplier_id"},
            {"data": "booking_amount"},
            {"data": "is_guest"},
            {"data": "email"},
            {"data": "phone"},
            {"data": "description"},
            {"data": "booking_date"},
            {"data": "pnr_number"},
            {"data": "action", orderable: false}
        ],
        lengthMenu: [
            [10, 25, 50, -1],
            [10, 25, 50, 'All']
        ],
        order: [],
        responsive:false,
        lengthChange: false,
        autoWidth: false,
        dom: 'lfBrtip',
        buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
        drawCallback: function( settings ) {}
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

    $('#show-hide-filters').on('click', function () {
        //table.draw();
        if ($('.filter-container').hasClass("d-none")) {
            $('.filter-container').removeClass("d-none");
            $('#show-hide-filters').html('Hide Filters');
        } else {
            $('.filter-container').addClass("d-none");
            $('#show-hide-filters').html('Show Filters');
        }
    });
    $('#search').on('click', function () {
        //table.draw();
        $('#booking_table').dataTable().fnFilter(this.value);
    });
    $('#clear').on('click', function () {
        $('#booking_filter_form')[0].reset();
        $('#booking_table').dataTable().fnFilter(this.value);
    });
    $('body').on('click', '.cancel-booking', function() {
        const id = $(this).attr('data-id');
        Swal.fire({
            title: "Are you sure to cancel this booking?",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, Cancel it!"
            }).then((result) => {
            if (result.isConfirmed) {
                const currentUrl = new URL(location.href);
                location.href = `${currentUrl.origin}/booking/cancel-booking/${id}`;
            }
        });
        return false;
    });
});

</script>
@endsection
@section('js')
@append
