<!doctype html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Rehlte Booking</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Fira+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js" integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous"></script>
<style>
body {
font-family: 'Fira Sans', sans-serif;
}
.container {
	margin-top: 30px;
}
</style>
</head>
<body>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">Booking in Progress</div>

                <div class="card-body">
                    <div class="text-center mb-4">
                        <div class="spinner-border text-primary" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                        <h4 class="mt-3" id="payment-status-text">Processing your booking...</h4>
                    </div>
                    
                    <p class="text-muted text-center">
                        Please do not close this window.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        let statusUrl = "{{ $data['status_url'] }}";
		const bookingVia = "{{ $data['booking_via'] }}";
		const checkStatusUrl = "{{ $data['check_status_url'] }}";
		const refId = "{{ $data['ref_id'] }}";
		const paymentId = "{{ $data['payment_id'] }}";
		let statusCheckInterval;

		statusUrl = `${statusUrl}&ref_id=${refId}`;
        async function checkPaymentStatus() {
			let response = await fetch(decodeURI(statusUrl));
			let result = await response.json();
			const data = result.data;
			if (data.status === 'confirmed' || data.status === 'failed') {
				if (bookingVia == 'mobile-app') {
					const data = {
						booking_id: data.booking_id,
						ref_id: refId,
						status: data.status,
						sub_status: data.sub_status,
						message: data.message,
					}
					window.ReactNativeWebView.postMessage(JSON.stringify(data));
				} else {
					window.location.href = data.url;
				}
			}
        }
		if (refId != '') {
			if (bookingVia == 'web') {
				window.location.href = checkStatusUrl;
				/*setTimeout(checkPaymentStatus, 0);
				setTimeout(() => {
					window.location.href = checkStatusUrl;
				}, 2000);*/
			} else {
				statusCheckInterval = setInterval(checkPaymentStatus, 3000);
			}
		}		
    });
</script>
</body>
</html>