@extends('admin.layout.main')
@section('content')
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/css/bootstrap-datepicker.min.css">

<!-- New Datepicker style cdn -->
<link rel="stylesheet" href="https://code.jquery.com/ui/1.14.1/themes/base/jquery-ui.css">
<link rel="stylesheet" href="/resources/demos/style.css">

<style>
    .card-body p {
        font-size: 10px;
    }

    .pie-chart {

        width: 100 px !important;
        height: 100 px !important;

    }

    .dataTables_filter {
        margin-left: 10px;
        float: right;
    }

    .datatable-container {
        padding: 0 !important;
        font-size: 13px;
    }

    .dataTables_info {
        float: left;
    }

    tr:nth-of-type(even) {
        color: #212529;
    }

    div.dataTables_wrapper div.dataTables_filter,
    div.dataTables_wrapper div.dataTables_info {
        color: #000;
    }

    .table-bordered tr th {
        background-color: #fff;
        color: #212529;
    }

    .table-bordered td,
    .table-bordered th {
        border: 1px solid #dee2e6;
    }

    .table-bordered {
        border: 1px solid #dee2e6;
    }

    .booking-status {
        font-weight: bold;
    }

    .booking-status.confirmed {
        color: #4CAF50;
    }

    .booking-status.pending {
        color: #1679AB;
    }

    .booking-status.cancelled,
    .booking-status.failed {
        color: #D71920;
    }

    .booking-status span {
        font-weight: normal !important;
    }

    .table> :not(caption)>*>* {
        padding: 0.4rem 0.7rem !important;
    }

    .refund-booking {
        font-weight: bold;
        text-decoration: underline !important;
    }

    .swal2-input:focus {
        color: #FFF !important;
    }


    .datepicker td,
    .datepicker th {
        height: 50px !important;
        width: 50px !important;
        border-radius: 5px !important;
    }

    .date {
        position: relative;

    }

    .sel_date {
        background: #343a40;
        color: #fff;
        border-radius: 50px;
        text-align: center;
    }

    .sel_date::placeholder {
        color: #fff;
    }

    .datepicker {
        left: auto !important;
        right: 0 !important;
    }

    .datepicker-days tr:nth-of-type(even) {
        background-color: #f5a9a4 !important;
    }

    .dark-mode .dropdown-menu {
        background-color: #fff !important;
        color: #000 !important;
    }



    .datepicker table.no-spacing {
        border-spacing: 0 !important;
        border-collapse: collapse !important;
    }
</style>

<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">




        <div class="row mb-4 mt-2">
            <div class="col-sm-10 align-items-center d-flex breadcrumb-style">
                <h1 class="m-0">{{ $heading }}</h1>
            </div>

            <div class="col-sm-2 align-items-center d-flex breadcrumb-style">
                <div class="form-group">
                    <label for="datepicker"> Date</label>
                    <input type="text" placeholder="Select the date" class="sel_date" name="booking_date" id="booking_date">
                </div>
            </div>


        </div> <!-- End of row for heading -->



        <div class="row">



            <!-- Total Users Card -->
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="card text-white bg-primary mb-4">
                    <div class="card-header">
                        <h6>Total Customers</h6>
                    </div>
                    <div class="card-body">
                        <h2 class="display-7" id="total_customers"></h2>
                        <p>Total number of registered customers.</p>
                    </div>
                </div>
            </div>

            <!-- Total Orders Card -->
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="card text-white bg-success mb-4">
                    <div class="card-header">
                        <h6>Total Bookings</h6>
                    </div>
                    <div class="card-body">
                        <h2 class="display-7" id="total_bookings"></h2>
                        <p>Total number of booking placed.</p>
                    </div>
                </div>
            </div>

            <!-- Total Products Card -->
            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="card text-white bg-warning mb-4">
                    <div class="card-header">
                        <h6>Total Coupons</h6>
                    </div>
                    <div class="card-body">
                        <h2 class="display-7" id="total_coupons"></h2>
                        <p>Total number of coupons</p>
                    </div>
                </div>
            </div>


            <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="card text-white bg-info  mb-4">
                    <div class="card-header">
                        <h6>Customer, Booking, and Coupon Data</h6>
                    </div>
                    <div class="card-body">
                    <canvas id="combinedPieChart"></canvas>
                    </div>
                </div>
            </div>


            <!-- <div class="col-lg-3 col-md-6 col-sm-12">
                <div class="chart-card">
                    <div class="chart-header">Customer, Booking, and Coupon Data</div>
                    <canvas id="combinedPieChart"></canvas>
                </div>

            </div> -->


        </div> <!-- End of row for cards -->


        <div class="container p-3 mb-2">
            <div class="row">
                <div class="col-md-4 p-3" style="border: 1px solid lightblue;">
                    <canvas id="customersChart"></canvas>
                </div>
                <div class="col-md-4 p-3" style="border: 1px solid lightblue;">
                    <canvas id="bookingChart"></canvas>
                </div>
                <div class="col-md-4 p-3" style="border: 1px solid lightblue;">
                    <canvas id="couponChart"></canvas>
                </div>
            </div>


        </div>





        <div class="row">
            <!-- Chart Card -->



            <!-- <div class="col-lg-6 col-md-12 col-sm-12">
                  <div class="card mb-4">
                      <div class="card-body">
                          <canvas id="pieChart" class="pie-chart"></canvas>
                      </div>
                  </div>
              </div> -->


            <div class="table-card">
                <!-- /.card-header -->
                <div class="card-body p-0">
                    <!-- <table class="table table-head-fixed text-nowrap"> -->
                    <table class="table table-bordered table-striped" id="booking_table" style="width:100%">
                        <thead>
                            <tr>
                                <th>{{ __('Sl. No.') }}</th>
                                <th>{{ __('Service') }}</th>
                                <th>{{ __('Booking Ref ID') }}</th>
                                <th>{{ __('Booking Status') }}</th>
                                <th>{{ __('PNR') }}</th>
                                <th>{{ __('Ticket Number(s)') }}</th>
                                <th>{{ __('System Ref ID') }}</th>
                                <th>{{ __('Supplier') }}</th>
                                <th>{{ __('Booking Amount') }}</th>
                                <th>{{ __('Cancelled Amount') }}</th>
                                <th>{{ __('Refund Amount') }}</th>
                                <th>{{ __('Is Guest') }}</th>
                                <th>{{ __('Email') }}</th>
                                <th>{{ __('Phone') }}</th>
                                <th>{{ __('Description') }}</th>
                                <th>{{ __('Booking Date') }}</th>
                                <th>{{ __('PNR Number') }}</th>
                                <th>{{ __('Action') }}</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>

                </div>

                <!-- /.card-body -->
            </div>

            <!-- <div class="col-lg-6 col-md-12 col-sm-12">
                        <div class="card mb-4">
                            <div class="card-body">
                                <canvas id="dashboardChart"></canvas>
                            </div>
                        </div>
                    </div>     -->




        </div>



    </div> <!-- End of container-fluid -->
</div> <!-- End of content-header -->

<!-- /.content-header -->

<!-- Main content -->

@endsection
@section('js')

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="{{ asset('assets/plugins/datatables/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
<script src="{{ asset('assets/plugins/pdfmake/pdfmake.min.js') }}"></script>
<script src="{{ asset('assets/plugins/pdfmake/vfs_fonts.js')}}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.html5.min.js')}}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.print.min.js')}}"></script>
<script src="{{ asset('assets/plugins/datatables-buttons/js/buttons.colVis.min.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/js/bootstrap-datepicker.min.js"></script>

<!-- New Jcdn for Datepicker -->
<script src="https://code.jquery.com/ui/1.14.1/jquery-ui.js"></script>
<script type="text/javascript">
    $(document).ready(function() {

        // $('#booking_date').datepicker({
        //     format: 'yyyy/mm/dd', 
        //     autoclose: true   , 
        // });



        $("#booking_date").datepicker({
            format: 'yyyy/mm/dd',
            changeMonth: true,
            changeYear: true,
           
        });



        let table;

        setTimeout(function() {
            if (!$.fn.dataTable.isDataTable('#booking_table')) {
                table = dataTable_record();
            } else {
                table = $('#booking_table').DataTable();
            }
        }, 300);

        $('#show-hide-filters').on('click', function() {
            if ($('.filter-container').hasClass("d-none")) {
                $('.filter-container').removeClass("d-none");
                $('#show-hide-filters').html('Hide Filters');
            } else {
                $('.filter-container').addClass("d-none");
                $('#show-hide-filters').html('Show Filters');
            }
        });

        $('#search').on('input', function() {
            var searchValue = $(this).val();
            if (table) {
                table.search(searchValue).draw();
            }
        });

        let debounceTimer;


        $('#booking_date').change(function() {
            setTimeout(function() {
                if ($.fn.dataTable.isDataTable('#booking_table')) {
                    $('#booking_table').DataTable().destroy();
                }
                dataTable_record();
            }, 300);
        });


    });

    function dataTable_record() {
        console.log("Func check..");

        const base_url = `${window.location.origin}`;

        return $('#booking_table').DataTable({
            processing: true,
            serverSide: true,
            responsive: true,
            "sScrollX": '100%',
            ajax: {
                url: `${base_url}/dashboard`,
                type: 'GET',
                data: function(d) {
                    d.booking_date = $("#booking_date").val();
                    d.supplier_id = $("#supplier_id option:selected").val();
                    d.service_id = $("#service_id option:selected").val();
                    d.supplier_booking_associated_ref = $("#supplier_booking_associated_ref").val();
                    d.ticket_numbers = $("#ticket_numbers").val();
                    d.system_ref_id = $("#system_ref_id").val();
                    d.booking_id = $("#booking_id").val();
                    d.price_from = $("#price_from").val();
                    d.price_to = $("#price_to").val();
                    d.pnr_number = $("#pnr_number").val();
                    d.customer_id = $("#customer_id").val();
                    d.booking_status = $("#booking_status option:selected").val();
                    d.agency_id = $("#agency_id option:selected").val();
                },
                dataSrc: function(response) {
                    console.log("Total Customers:", response.totalCustomers);
                    console.log("Total Coupons:", response.totalCoupons);
                    console.log("Total Bookings:", response.totalBookings);

                    $("#total_customers").text(response.totalCustomers);
                    $("#total_coupons").text(response.totalCoupons);
                    $("#total_bookings").text(response.totalBookings);

                    return response.data;
                },
                error: function(xhr, status, error) {
                    console.error("DataTables AJAX Error:", error);
                    alert("Failed to load data. Please try again.");
                }
            },
            columns: [{
                    "data": 'DT_RowIndex',
                    name: 'DT_RowIndex'
                },
                {
                    "data": "booking_type"
                },
                {
                    "data": "booking_ref"
                },
                {
                    "data": "booking_status"
                },
                {
                    "data": "supplier_booking_associated_ref"
                },
                {
                    "data": "ticket_numbers"
                },
                {
                    "data": "supplier_booking_ref"
                },
                {
                    "data": "supplier_id"
                },
                {
                    "data": "total"
                },
                {
                    "data": "booking_cancel_amount"
                },
                {
                    "data": "processed_cancel_amount"
                },
                {
                    "data": "is_guest"
                },
                {
                    "data": "email"
                },
                {
                    "data": "phone"
                },
                {
                    "data": "description"
                },
                {
                    "data": "booking_date"
                },
                {
                    "data": "pnr_number"
                },
                {
                    "data": "action",
                    orderable: false
                }
            ],
            lengthMenu: [
                [10, 25, 50, -1],
                [10, 25, 50, 'All']
            ],
            order: [],
            responsive: false,
            lengthChange: false,
            autoWidth: false,
            dom: 'lfBrtip',
            buttons: ["copy", "csv", "excel", "pdf", "print", "colvis"],
            drawCallback: function(settings) {}
        }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
    }

    // Chart for Total Customes
    const customerLabels = @json($customerLabels);
    const customerData = @json($customerData);

    // Initialize Chart.js
    const ctx_customer = document.getElementById('customersChart').getContext('2d');
    new Chart(ctx_customer, {
        type: 'bar',
        data: {
            labels: customerLabels,
            datasets: [{
                label: 'Total Customers',
                data: customerData,
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Chart for Bookings

    const bookingLabels = @json($bookingLabels);
    const bookingData = @json($bookingData);

    // Initialize Chart.js
    const ctx_booking = document.getElementById('bookingChart').getContext('2d');
    new Chart(ctx_booking, {
        type: 'bar',
        data: {
            labels: bookingLabels,
            datasets: [{
                label: 'Total Bookings',
                data: bookingData,
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Chart for Coupons

    const couponLabels = @json($couponLabels);
    const couponData = @json($couponData);

    // Initialize Chart.js
    const ctx_coupon = document.getElementById('couponChart').getContext('2d');
    new Chart(ctx_coupon, {
        type: 'bar',
        data: {
            labels: couponLabels,
            datasets: [{
                label: 'Total Coupons',
                data: couponData,
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                borderColor: 'rgba(75, 192, 192, 1)',
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });


    // Data for Pie Chart
    const labels = ['Total Customers', 'Total Bookings', 'Total Coupons'];
    const data = [
        @json($totalCustomers), 
        @json($totalBookings), 
        @json($totalCoupons) 
    ];

    // Colors for Pie Chart
    const backgroundColors = [
        'rgba(75, 192, 192, 0.7)', // Customers
        'rgba(54, 162, 235, 0.7)', // Bookings
        'rgba(255, 206, 86, 0.7)' // Coupons
    ];

    const borderColors = [
        'rgba(75, 192, 192, 1)',
        'rgba(54, 162, 235, 1)',
        'rgba(255, 206, 86, 1)'
    ];

    // Render Pie Chart
    const ctx = document.getElementById('combinedPieChart').getContext('2d');
    new Chart(ctx, {
        type: 'pie',
        data: {
            labels: labels,
            datasets: [{
                label: 'Data Distribution',
                data: data,
                backgroundColor: backgroundColors,
                borderColor: borderColors,
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            plugins: {
            legend: {
                position: 'top',
                labels: {
                    color: 'white', 
                    font: {
                        size: 14 
                    }
                }
            },
                tooltip: {
                    callbacks: {
                        label: function(tooltipItem) {
                            const total = data.reduce((acc, value) => acc + value, 0);
                            const percentage = ((tooltipItem.raw / total) * 100).toFixed(2);
                            return `${tooltipItem.label}: ${tooltipItem.raw} (${percentage}%)`;
                        }
                    }
                }
            }
        }
    });
</script>



@append