@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<?php app()->setLocale("en"); ?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
                <h1 class="m-0">@lang('city.addCity')</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">@lang('airport.dashboard') </a></li>
                    <li class="breadcrumb-item"><a href="{{ route('city-images.index') }}">Top Destinations</a></li>
                    <li class="breadcrumb-item active">@lang('city.add')</li>
                </ol>
            </div><!-- /.col -->

        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            @if ($errors->has('message'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                {{ $errors->first('message') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            @endif
            <br>
            <div class="card pb-4 pt-3 px-3 w-100">
                <form method="post" action="{{route('city-images.store')}}" id="cityForm" class="form row mb-0 validate" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" id="id" name="id" autocomplete="off">
                    <div class="brdr-btm row">

                        <div class="col-md-6">
                            <div class="form-item form-float-style">
                                @php
                                $countries = App\Models\Country::with('countryCode')
                                ->where('status', 'active')
                                ->orderBy('iso_code', 'asc')
                                ->get();
                                @endphp
                                <select name="country_code" id="country_code" data-live-search="true" class="order-td-input selectpicker1 select-text height_drp is-valid select2" style="width:100%" onchange="getCity(this.value)">
                                    <option value="">Select Country</option>
                                    @foreach($countries as $country)
                                    <option value="{{ $country->iso_code }}">
                                        @foreach($country->countryCode as $country_name)
                                        {{ $country_name['country_name'] }} <br>
                                        @endforeach
                                    </option>
                                    @endforeach
                                </select>
                                <label for="code">Select Country <span class="req-star">*</span></label>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style">
                                        <select data-live-search="true" id="status" name="status" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option value="1" selected="">@lang('city.active')</option>
                                            <option value="2">@lang('city.inActive')</option>
                                        </select>
                                        <label class="select-label searchable-drp">@lang('city.status')</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-item form-float-style d-flex align-items-center" style="margin-top: 5px;">
                                <button type="button" id="add-city" class="btn btn-primary"> <i class="fa fa-plus"></i> </button>
                            </div>
                        </div>

                        <div id="city-container">
                            <div class="city-row d-flex justify-content-between align-items-center mb-3">
                                <div class="col-md-4">
                                    <div class="form-item form-float-style">
                                        <select data-live-search="true" name="city[]" id="city" class="order-td-input selectpicker1 select-text height_drp is-valid select2 city-select" style="width: 100%" required></select>
                                        <label>Select City <span class="req-star">*</span></label>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-item form-float-style">
                                        <input type="file" name="city_thumbnail[]" id="city_thumbnail" class="is-valid" autocomplete="off" required>
                                        <label>Upload Thumbnail <span class="req-star">*</span></label>
                                    </div>
                                </div>
                               
                                
                                <div class="col-md-3">
                                    <div class="form-item form-float-style d-flex align-items-center" >
                                        <button type="button" class="btn btn-danger remove-city float-left">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>







                    

                    </div>
                    <div class="cards-btn mt-3">
                        <button type="submit" id="disBtn" class="btn btn-success form-btn-success">@lang('city.submit')</button>
                        <a href="{{ route('city-images.index') }}" type="button" class="btn btn-danger form-btn-danger">@lang('city.cancel')</a>
                    </div>
                </form>

            </div>
            <!-- /.row -->
        </div>
        <!--/. container-fluid -->
</section>
@endsection
@section('js')
<script>
    // Listen for file input change event


    $(function() {


        $('#cityForm').validate({
            onkeyup: false, //turn off auto validate whilst typing
            rules: {
                "city_names[0][city_name]": {
                    required: true,
                    noSpace: true
                },
                "city_names[1][city_name]": {
                    required: true,
                    noSpace: true
                },
                iso_code: {
                    required: true,
                    noSpace: true,
                    letterswithoutspaces: true,
                    remote: {
                        url: "{{route('cities.checkISOCodeExist') }}",
                        type: "POST",
                        data: {
                            iso_code: function() {
                                return $("#iso_code").val();
                            },
                            "_token": '{{ csrf_token() }}'
                        }
                    }
                },
                country_code: {
                    noSpace: true,
                    required: true,
                },
                city: {
                    required: true,
                },
                city_thumbnail: {
              
                    required: true,
                },

            },
            messages: {

                iso_code: {
                    required: "Please enter an ISO Code",
                    remote: "ISO Code is already taken"
                },
                country_code: {
                    required: "Please select country "
                },
                city: {
                    required: "Please select city "
                },


                city_thumbnail: {
                    required: "Please Upload Thumbnail",

                },

            },
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-item').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
            highlight: function(element, errorClass) {
                $(element).removeClass(errorClass);
            },
            submitHandler: function(form) {
                $("#disBtn").attr("disabled", true);
                form.submit();
            }
        });
    });
</script>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize select2 for country dropdown
        $('#country_code').select2({
            placeholder: "Select Country",
            allowClear: true,
            width: '100%'
        });
    });

    // To store selected cities and their ISO codes
    var selectedCities = [];

    // Function to fetch cities based on selected country
    function getCity(countryCode) {
        $.ajax({
            url: '/fetch-cities-by-country',
            type: 'GET',
            data: { country_code: countryCode },
            success: function(response) {
                if (response.length > 0) {
                    // Clear and populate the city dropdowns for all rows
                    $('.city-select').each(function() {
                        var $select = $(this);
                        $select.empty().append('<option value="">Select City</option>');
                        response.forEach(function(city) {
                            // If the city has not been selected already, add it
                            $select.append(new Option(city.city_name, city.iso_code));
                        });
                        // Reinitialize select2
                        $select.select2({
                            placeholder: 'Select City',
                            allowClear: true
                        });
                    });
                } else {
                    alert('No cities found.');
                }
            },
            error: function(xhr, status, error) {
                alert('Error fetching cities: ' + error);
            }
        });
    }

    // When city is selected, check if it's already selected
    $(document).on('change', '.city-select', function() {
        var selectedCity = $(this).val();
        if (selectedCity && selectedCities.includes(selectedCity)) {
            alert('This city has already been selected!');
            $(this).val("").trigger('change'); // Clear the selection
        } else if (selectedCity) {
            selectedCities.push(selectedCity); // Add the selected city to the list
        }
    });

    // Add more cities (add a new row)
    $(document).on('click', '#add-city', function() {
        var newRow = $('.city-row:first').clone(); // Clone the first row
        newRow.find("select").val(""); // Clear values in the new row (important to clear the selection)
        
        // Reinitialize select2 for the new row
        newRow.find('.city-select').select2({
            placeholder: 'Select City',
            allowClear: true
        });

        $('#city-container').append(newRow); // Append the new row
    });

    // Remove a city row
    $(document).on('click', '.remove-city', function() {
        var cityToRemove = $(this).closest('.city-row').find('.city-select').val();
        if (cityToRemove) {
            // Remove the city from the selectedCities array
            selectedCities = selectedCities.filter(function(city) {
                return city !== cityToRemove; // Remove the city from the list
            });
        }
        $(this).closest('.city-row').remove(); // Remove the row
    });
</script>





<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

@append