@extends('admin.layout.main')

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/2.3.3/css/dataTables.dataTables.css" />

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.css">

<style>
    .dt-search input {
        width: 200px;
        height: 40px;
        padding: 3px 5px;
        font-size: 14px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }

    .dataTables_wrapper {
        padding-bottom: 0 !important;
        margin-bottom: 0 !important;
    }

    .dataTables_paginate {
        margin-top: 5px !important;
        margin-bottom: 0 !important;
    }

    .tab-content .tab-pane {
        max-height: 70vh;
        /* adjust as needed */
        overflow-y: auto;
        overflow-x: hidden;
        padding-bottom: 15px;
        /* avoid cutting pagination */
    }

    /* Only the table area scrolls */
    .table-wrapper {
        max-height: 70vh;
        /* adjust */
        overflow-y: auto;
    }


.loader {
  width: 35px;
  height: 35px;
  border-radius: 50%;
  display: inline-block;
  position: relative;
  border: 3px solid;
  border-color: #FFF #FFF transparent;
  box-sizing: border-box;
  animation: rotation 1s linear infinite;
}
.loader::after {
  content: '';  
  box-sizing: border-box;
  position: absolute;
  left: 0;
  right: 0;
  top: 0;
  bottom: 0;
  margin: auto;
  border: 3px solid;
  border-color: transparent #FF3D00 #FF3D00;
  width: 24px;
  height: 24px;
  border-radius: 50%;
  animation: rotationBack 0.5s linear infinite;
  transform-origin: center center;
}

@keyframes rotation {
  0% {
    transform: rotate(0deg);
  }
  100% {
    transform: rotate(360deg);
  }
} 
    
@keyframes rotationBack {
  0% {
    transform: rotate(0deg);
  }
  100% {
    transform: rotate(-360deg);
  }
}
    
</style>


      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-4 mt-2">
            <div class="col-sm-12 align-items-center d-flex breadcrumb-style">
              <h1 class="m-0">Hotel Facilites - Translate Service</h1>
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">@lang('adminUser.dashboard')</a></li>
                <li class="breadcrumb-item active">Hotel Facilites - Translate Service</li>
              </ol>
              <div class="breadcrumb-btn">
                <div class="add-breadcrumb">
                  <!-- Button to trigger modal -->
                   <a href="#" title="Add" data-bs-toggle="modal" data-bs-target="#addModal">
                       <?xml version="1.0" encoding="utf-8"?>
                       <svg fill="#ffffff" height="15" width="15" version="1.1"
                         id="Layer_1" x="0px" y="0px" width="122.881px" height="122.88px" viewBox="0 0 122.881 122.88"
                         enable-background="new 0 0 122.881 122.88" xml:space="preserve">
                         <g>
                         <path
                           d="M56.573,4.868c0-0.655,0.132-1.283,0.37-1.859c0.249-0.6,0.61-1.137,1.056-1.583C58.879,0.545,60.097,0,61.44,0 c0.658,0,1.287,0.132,1.863,0.371c0.012,0.005,0.023,0.011,0.037,0.017c0.584,0.248,1.107,0.603,1.543,1.039 c0.881,0.88,1.426,2.098,1.426,3.442c0,0.03-0.002,0.06-0.006,0.089v51.62l51.619,0c0.029-0.003,0.061-0.006,0.09-0.006 c0.656,0,1.285,0.132,1.861,0.371c0.014,0.005,0.025,0.011,0.037,0.017c0.584,0.248,1.107,0.603,1.543,1.039 c0.881,0.88,1.428,2.098,1.428,3.441c0,0.654-0.133,1.283-0.371,1.859c-0.248,0.6-0.609,1.137-1.057,1.583 c-0.445,0.445-0.98,0.806-1.58,1.055v0.001c-0.576,0.238-1.205,0.37-1.861,0.37c-0.029,0-0.061-0.002-0.09-0.006l-51.619,0.001 v51.619c0.004,0.029,0.006,0.06,0.006,0.09c0,0.656-0.133,1.286-0.371,1.861c-0.006,0.014-0.012,0.025-0.018,0.037 c-0.248,0.584-0.602,1.107-1.037,1.543c-0.883,0.882-2.1,1.427-3.443,1.427c-0.654,0-1.283-0.132-1.859-0.371 c-0.6-0.248-1.137-0.609-1.583-1.056c-0.445-0.444-0.806-0.98-1.055-1.58h-0.001c-0.239-0.575-0.371-1.205-0.371-1.861 c0-0.03,0.002-0.061,0.006-0.09V66.303H4.958c-0.029,0.004-0.059,0.006-0.09,0.006c-0.654,0-1.283-0.132-1.859-0.371 c-0.6-0.248-1.137-0.609-1.583-1.056c-0.445-0.445-0.806-0.98-1.055-1.58H0.371C0.132,62.726,0,62.097,0,61.44 c0-0.655,0.132-1.283,0.371-1.859c0.249-0.6,0.61-1.137,1.056-1.583c0.881-0.881,2.098-1.426,3.442-1.426 c0.031,0,0.061,0.002,0.09,0.006l51.62,0l0-51.62C56.575,4.928,56.573,4.898,56.573,4.868L56.573,4.868z" />
                          </g>
                        </svg>
                        Add
                    </a>

                </div>
                
              <!-- Import Excel -->
               <div class="add-breadcrumb bg-success">
                <a href="#" data-bs-toggle="modal" data-bs-target="#importExcelModal"
                   title="Import Excel"
                   style="padding: 0px 10px; color: white !important; text-decoration: none;">
                  <i class="fas fa-download"></i>&nbsp;
                  Import
                </a>
              </div>
                <!-- Export Excel -->
                <div class="add-breadcrumb bg-info">
                  <a href="#" title="Export Excel"  style="padding: 0px 10px;color: white !important" id="exportFacility">
                    <i class="fas fa-file-export"></i> &nbsp;
                    <span class="loader"></span> <span id="exportText">Export</span>
                  </a>
                </div>

              </div>
       
            </div><!-- /.col -->

          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>



<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">

                  @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger" role="alert">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                @endif


                <!-- Existing Table -->
                <div class="card-body table-radius table-responsive p-0">
                    <table class="table table-head-fixed text-nowrap" id="special-request-table">
                        <thead class="td-data-color">
                            <tr>
                                <th style="color:white">S.No</th>
                                <th style="color:white">Hotel Facilites (En)</th>
                                <th style="color:white">Hotel Facilites (Ar)</th>
                                <th style="color:white">Created At</th>
                                <th style="color:white">Action</th>
                            </tr>
                        </thead>
                        <tbody class="td-data-color">
                             
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</section>


<!-- Add Model Popup -->

<div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">

  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addModalLabel">Add Hotel Arabic Facilities </h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <!-- Form content here -->
        <form action="{{ route('hotel-facilities-ar.store') }}" method="post">
            @csrf
          <div class="mb-3">
            <label for="facility-name-en" class="form-label">Facility Name (English) <span class="text-danger"> *</span></label>
            <input type="text" class="form-control" id="facility-name-en" name="facility_name_en">
          </div>
          <div class="mb-3">
            <label for="facility-name-ar" class="form-label">Facility Name (Arabic) <span class="text-danger"> *</span></label>
            <input type="text" class="form-control" id="facility-name-ar" name="facility_name_ar">
          </div>
      
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Save Facility</button>
      </div>
    </div>
    </form>
  </div>
</div>

<!-- End of Add  Model Popup -->


<!-- Edit Model Popup -->

<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <form id="editForm" method="post">
        @csrf
        @method('PUT')
        <div class="modal-header">
          <h5 class="modal-title" id="editModalLabel">Edit Hotel Arabic Facility</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <div class="mb-3">
            <label for="edit-facility-name-en" class="form-label">Facility Name (English) <span class="text-danger"> *</span></label>
            <input type="text" class="form-control" id="edit-facility-name-en" name="facility_name_en">
          </div>
          <div class="mb-3">
            <label for="edit-facility-name-ar" class="form-label">Facility Name (Arabic) <span class="text-danger"> *</span></label>
            <input type="text" class="form-control" id="edit-facility-name-ar" name="facility_name_ar">
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Update Facility</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- End of Edit Model popup -->


<!-- Import Facility Model -->
 <!-- Import Excel Modal -->
<div class="modal fade" id="importExcelModal" tabindex="-1" aria-labelledby="importExcelModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title" id="importExcelModalLabel" style="color: white;">
          <i class="fas fa-download"></i>&nbsp; Import Excel
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <div class="modal-body text-center">

        <!-- Template Download -->
        <div class="mb-3">
          <a href="{{ route('hotel-facilities-ar.template') }}" class="btn btn-outline-success">
            <i class="fas fa-download"></i> Download Template
          </a>
        </div>

        <!-- Drag and Drop Area -->
        <form id="importExcelForm" enctype="multipart/form-data">
          @csrf
          <div id="dropArea" class="border border-2 border-dashed rounded p-5 bg-light text-center">
            <i class="fas fa-upload fa-3x text-light"></i>
            <p class="mt-3">Drag & Drop your Excel file here or click to select</p>
            <input type="file" name="file" id="fileInput" class="d-none" accept=".xlsx,.xls">
            <button type="button" id="browseFile" class="btn btn-sm btn-success">Browse File</button>
          </div>
        </form>

      </div>

      <div class="modal-footer">
        <button type="button" id="uploadBtn" class="btn btn-success">Upload & Import</button>
      </div>

    </div>
  </div>
</div>

@endsection

@section('js')
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>



<script src="https://cdn.datatables.net/2.3.3/js/dataTables.js"></script>

<script>
    $(document).ready(function() {
      
    let table = $('#special-request-table').DataTable({
             processing: true, 
             serverSide: true,  
             pageLength: 10,
             lengthChange: false,
             ordering: true,
             info: false,
             autoWidth: false,
             searching: true,
             columnDefs: [{
                 orderable: false,
                 targets: -1
             }],
             ajax: {
                 url: "{{ route('hotel-facilities-ar.data') }}",
                 type: 'GET',         
             },
             columns: [
                 { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                 { data: 'facility_name_en', name: 'facility_name_en' },
                 { data: 'facility_name_ar', name: 'facility_name_ar' },
                 { data: 'created_at', name: 'created_at' },
                 { data: 'action', name: 'action', orderable: false, searchable: false }
             ],
        });


        const editForm = document.getElementById('editForm');
        const nameInputEn = document.getElementById('edit-facility-name-en');
        const nameInputAr = document.getElementById('edit-facility-name-ar');

  
        $('#special-request-table').on('click', '.edit-button', function () {
            const id = $(this).data('id');
            const nameEn = $(this).data('name-en');
            const nameAr = $(this).data('name-ar');

            editForm.action = `/hotel-facilities-ar/${id}`;
            nameInputEn.value = nameEn;
            nameInputAr.value = nameAr;

            const editModal = new bootstrap.Modal(document.getElementById('editModal'));
            editModal.show();
        });
          $('.loader').hide();

          $('#exportFacility').on('click', function(e) {
              e.preventDefault();       
              console.log('Export Clicked');    
              $('#exportText').hide();
              $('.loader').show();
          
              $.ajax({
                  url: "{{ route('hotel-facilities-ar.export') }}",
                  method: 'GET',
                  xhrFields: {
                      responseType: 'blob' 
                  },
                  success: function(data, status, xhr) {
                      $('.loader').hide();
                      $('#exportText').show();

                      var disposition = xhr.getResponseHeader('Content-Disposition');
                      var filename = "Facility_" + new Date().toISOString().slice(0,19).replace(/:/g, "-") + ".xlsx";
                      if (disposition && disposition.indexOf('filename=') !== -1) {
                          filename = disposition.split('filename=')[1].replace(/"/g, '');
                      }
     
                      var url = window.URL.createObjectURL(data);
                      var a = document.createElement('a');
                      a.href = url;
                      a.download = filename;
                      document.body.appendChild(a);
                      a.click();
                      a.remove();
                      window.URL.revokeObjectURL(url);
                    
                      toastr.success('Export completed successfully!', 'Success');
                  },
                  error: function(xhr, status, error) {
                      $('.loader').hide();
                      $('#exportText').show();
                      toastr.error('Export failed. Please try again.', 'Error');
                      console.error(error);
                  }
              });
          });


        // Import Excel Functionality

    let file; 


    $("#browseFile").on("click", function () {
        $("#fileInput").click();
    });


    $("#fileInput").on("change", function (e) {
        file = e.target.files[0];
        $("#dropArea").addClass("border-success").removeClass("border-dashed");
        $("#dropArea p").text("Selected File: " + file.name);
    });

    // Drag and drop functionality
    $("#dropArea").on("dragover", function (e) {
        e.preventDefault();
        $(this).addClass("bg-success text-white");
    }).on("dragleave", function () {
        $(this).removeClass("bg-success text-white");
    }).on("drop", function (e) {
        e.preventDefault();
        file = e.originalEvent.dataTransfer.files[0];
        $("#fileInput")[0].files = e.originalEvent.dataTransfer.files;
        $("#dropArea p").text("Selected File: " + file.name);
        $(this).removeClass("bg-success text-white");
    });

    // Upload button click
    $("#uploadBtn").on("click", function () {
        if (!file) {
            toastr.warning("Please select a file first!");
            return;
        }

        let formData = new FormData($("#importExcelForm")[0]);

        $.ajax({
            url: "{{ route('hotel-facilities-ar.import') }}",
            type: "POST",
            data: formData,
            contentType: false,
            processData: false,
            beforeSend: function () {
                $("#uploadBtn").prop("disabled", true).text("Uploading...");
            },
            success: function (response) {
              toastr.success(response.message, 'Import Complete');
                $("#importExcelModal").modal("hide");
                $("#uploadBtn").prop("disabled", false).text("Upload & Import");

              if (response.skipped > 0) {

                  Swal.fire({
                  title: 'Skipped Facilities',
                  html: "Total " + response.skipped + " facilities were skipped (already exist).<br>" 
                      + response.inserted + " new facilities were added.",
                  icon: 'info',
                  confirmButtonText: 'OK'
                   }).then((result) => {
                  if (result.isConfirmed) {
                      location.reload(); 
                  }
              });


             } else {

                 Swal.fire({
                     title: 'Import Complete',
                     text: response.message,
                     icon: 'success',
                     confirmButtonText: 'OK'
                 }).then(() => {
                     location.reload();
                 });
             }


            },
            error: function () {
                toastr.error("Import failed. Please try again.");
                $("#uploadBtn").prop("disabled", false).text("Upload & Import");
            }
        });
    });




    });

</script>

@append