@extends('admin.layout.main')

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/2.3.3/css/dataTables.dataTables.css" />
<style>
    .dt-search input {
        width: 200px;
        height: 40px;
        padding: 3px 5px;
        font-size: 14px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }

    .dataTables_wrapper {
        padding-bottom: 0 !important;
        margin-bottom: 0 !important;
    }

    .dataTables_paginate {
        margin-top: 5px !important;
        margin-bottom: 0 !important;
    }

    .tab-content .tab-pane {
        max-height: 70vh;
        /* adjust as needed */
        overflow-y: auto;
        overflow-x: hidden;
        padding-bottom: 15px;
        /* avoid cutting pagination */
    }

    /* Only the table area scrolls */
    .table-wrapper {
        max-height: 70vh;
        /* adjust */
        overflow-y: auto;
    }
</style>


      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-4 mt-2">
            <div class="col-sm-12 align-items-center d-flex breadcrumb-style">
              <h1 class="m-0">Hotel Special Request</h1>
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">@lang('adminUser.dashboard')</a></li>
                <li class="breadcrumb-item active">Hotel Special Request</li>
              </ol>
              <div class="breadcrumb-btn">
                <div class="add-breadcrumb">
                  <!-- Button to trigger modal -->
                   <a href="#" title="Add" data-bs-toggle="modal" data-bs-target="#addModal">
                       <?xml version="1.0" encoding="utf-8"?>
                       <svg fill="#ffffff" height="15" width="15" version="1.1"
                         id="Layer_1" x="0px" y="0px" width="122.881px" height="122.88px" viewBox="0 0 122.881 122.88"
                         enable-background="new 0 0 122.881 122.88" xml:space="preserve">
                         <g>
                         <path
                           d="M56.573,4.868c0-0.655,0.132-1.283,0.37-1.859c0.249-0.6,0.61-1.137,1.056-1.583C58.879,0.545,60.097,0,61.44,0 c0.658,0,1.287,0.132,1.863,0.371c0.012,0.005,0.023,0.011,0.037,0.017c0.584,0.248,1.107,0.603,1.543,1.039 c0.881,0.88,1.426,2.098,1.426,3.442c0,0.03-0.002,0.06-0.006,0.089v51.62l51.619,0c0.029-0.003,0.061-0.006,0.09-0.006 c0.656,0,1.285,0.132,1.861,0.371c0.014,0.005,0.025,0.011,0.037,0.017c0.584,0.248,1.107,0.603,1.543,1.039 c0.881,0.88,1.428,2.098,1.428,3.441c0,0.654-0.133,1.283-0.371,1.859c-0.248,0.6-0.609,1.137-1.057,1.583 c-0.445,0.445-0.98,0.806-1.58,1.055v0.001c-0.576,0.238-1.205,0.37-1.861,0.37c-0.029,0-0.061-0.002-0.09-0.006l-51.619,0.001 v51.619c0.004,0.029,0.006,0.06,0.006,0.09c0,0.656-0.133,1.286-0.371,1.861c-0.006,0.014-0.012,0.025-0.018,0.037 c-0.248,0.584-0.602,1.107-1.037,1.543c-0.883,0.882-2.1,1.427-3.443,1.427c-0.654,0-1.283-0.132-1.859-0.371 c-0.6-0.248-1.137-0.609-1.583-1.056c-0.445-0.444-0.806-0.98-1.055-1.58h-0.001c-0.239-0.575-0.371-1.205-0.371-1.861 c0-0.03,0.002-0.061,0.006-0.09V66.303H4.958c-0.029,0.004-0.059,0.006-0.09,0.006c-0.654,0-1.283-0.132-1.859-0.371 c-0.6-0.248-1.137-0.609-1.583-1.056c-0.445-0.445-0.806-0.98-1.055-1.58H0.371C0.132,62.726,0,62.097,0,61.44 c0-0.655,0.132-1.283,0.371-1.859c0.249-0.6,0.61-1.137,1.056-1.583c0.881-0.881,2.098-1.426,3.442-1.426 c0.031,0,0.061,0.002,0.09,0.006l51.62,0l0-51.62C56.575,4.928,56.573,4.898,56.573,4.868L56.573,4.868z" />
                          </g>
                        </svg>
                        Add
                    </a>

                </div>

              </div>
            </div><!-- /.col -->

          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>



<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">

                  @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger" role="alert">
                            {{ session('error') }}
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger" role="alert">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                @endif


                <!-- Existing Table -->
                <div class="card-body table-radius table-responsive p-0">
                    <table class="table table-head-fixed text-nowrap" id="special-request-table">
                        <thead class="td-data-color">
                            <tr>
                                <th style="color:white">S.No</th>
                                <th style="color:white">Special Request Name (En)</th>
                                <th style="color:white">Special Request Name (Ar)</th>
                                <th style="color:white">Created By</th>
                                <th style="color:white">Created At</th>
                                <th style="color:white">Status</th>
                                <th style="color:white">Action</th>
                            </tr>
                        </thead>
                        <tbody class="td-data-color">
                             @foreach ($hotelSpecialRequestList as $specialRequest)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $specialRequest?->special_request_name  }}</td>
                                    <td>{{ $specialRequest?->special_request_name_ar  }}</td>
                                    <td>{{ $specialRequest->user?->name  }}</td>
                                    <td>{{ $specialRequest?->created_at->format('d M, Y')  }}</td>
                                    <td>{{ $specialRequest?->status ? 'Active' : 'In Active'  }}</td>
                                    <td>
                                      <span>
                                         <a href="#" class="edit-button" data-id="{{ $specialRequest->id }}" data-name="{{ $specialRequest?->special_request_name }}" data-name_ar="{{ $specialRequest?->special_request_name_ar }}" data-status="{{ $specialRequest?->status }}" title="Edit">
                                         <?xml version="1.0"?>
                                      <svg fill="#198754" viewBox="0 0 24 24" width="20" height="20">
                                      <path d="M 19.171875 2 C 18.448125 2 17.724375 2.275625 17.171875 2.828125 L 16 4 L 20 8 L 21.171875 6.828125 C 22.275875 5.724125 22.275875 3.933125 21.171875 2.828125 C 20.619375 2.275625 19.895625 2 19.171875 2 z M 14.5 5.5 L 3 17 L 3 21 L 7 21 L 18.5 9.5 L 14.5 5.5 z"/>
                                       </svg>
                                   </a>
                                    </span>

                                    <span>
                                          <a data-url="{{ route('hotel-special-request.delete', ['id' => $specialRequest?->id]) }}" data-bs-toggle="modal" data-bs-target="#exampleModal" type="button" title="Delete"
                                          class="deleteConfirmation btn-hover-del"><svg fill="#ee3137" viewBox="0 0 24 24"
                                          width="20" height="20">
                                         <path
                                            d="M 10 2 L 9 3 L 5 3 C 4.4 3 4 3.4 4 4 C 4 4.6 4.4 5 5 5 L 7 5 L 17 5 L 19 5 C 19.6 5 20 4.6 20 4 C 20 3.4 19.6 3 19 3 L 15 3 L 14 2 L 10 2 z M 5 7 L 5 20 C 5 21.1 5.9 22 7 22 L 17 22 C 18.1 22 19 21.1 19 20 L 19 7 L 5 7 z M 9 9 C 9.6 9 10 9.4 10 10 L 10 19 C 10 19.6 9.6 20 9 20 C 8.4 20 8 19.6 8 19 L 8 10 C 8 9.4 8.4 9 9 9 z M 15 9 C 15.6 9 16 9.4 16 10 L 16 19 C 16 19.6 15.6 20 15 20 C 14.4 20 14 19.6 14 19 L 14 10 C 14 9.4 14.4 9 15 9 z" />
                                          </svg></a>

                                         </span>
                                       </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</section>


<!-- Add Model Popup -->

<div class="modal fade" id="addModal" tabindex="-1" aria-labelledby="addModalLabel" aria-hidden="true">

  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="addModalLabel">Add Hotel Special Request</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <!-- Form content here -->
        <form action="{{ route('hotel-special-request.store') }}" method="post">
            @csrf
          <div class="mb-3">
            <label for="special-request-name" class="form-label">Request Name (En)<span class="text-danger"> *</span></label>
            <input type="text" class="form-control" id="special-request-name" name="special_request_name">
          </div>
          <div class="mb-3">
            <label for="special-request-name_ar" class="form-label">Request Name (Ar)<span class="text-danger"> *</span></label>
            <input type="text" class="form-control" id="special-request-name_ar" name="special_request_name_ar">
          </div>
          <div class="mb-3">
            <label for="status" class="form-label">Status <span class="text-danger"> *</span></label>
            <select name="status" id="" class="form-control">
                <option value="1">Active</option>
                <option value="0">In Active</option>
            </select>
          </div>
          
        
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="submit" class="btn btn-primary">Save Request</button>
      </div>
    </div>
    </form>
  </div>
</div>

<!-- End of Add  Model Popup -->


<!-- Edit Model Popup -->

<div class="modal fade" id="editModal" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <form id="editForm" method="post">
        @csrf
        @method('PUT')
        <div class="modal-header">
          <h5 class="modal-title" id="editModalLabel">Edit Special Request</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <div class="mb-3">
                <label for="edit-special-request-name" class="form-label">Request Name (En) <span class="text-danger"> *</span></label>
                <input type="text" class="form-control" id="edit-special-request-name" name="special_request_name">
            </div>
            <div class="mb-3">
                <label for="edit-special-request-name_ar" class="form-label">Request Name (Ar) <span class="text-danger"> *</span></label>
                <input type="text" class="form-control" id="edit-special-request-name_ar" name="special_request_name_ar">
            </div>
            <div class="mb-3">
                <label for="edit-status" class="form-label">Status <span class="text-danger"> *</span></label>
                <select name="status" id="edit-status" class="form-control">
                    <option value="1">Active</option>
                    <option value="0">In Active</option>
                </select>
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button type="submit" class="btn btn-primary">Update Request</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- End of Edit Model popup -->

@endsection

@section('js')
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>



<script src="https://cdn.datatables.net/2.3.3/js/dataTables.js"></script>

<script>
    $(document).ready(function() {
        let table = $('#special-request-table').DataTable({
            pageLength: 10,
            lengthChange: false,
            ordering: true,
            info: false,
            autoWidth: false,
            searching: true,
            columnDefs: [{
                orderable: false,
                targets: -1
            }]
        });

        const editForm   = document.getElementById('editForm');
        const nameInput  = document.getElementById('edit-special-request-name');
        const nameInputAr = document.getElementById('edit-special-request-name_ar');
        const statusSelect = document.getElementById('edit-status');

        $('#special-request-table').on('click', '.edit-button', function () {
            const id     = $(this).data('id');
            const name   = $(this).data('name');
            const nameAr = $(this).data('name_ar');
            const status = $(this).data('status');

            editForm.action = `/hotel-special-request/${id}`;
            nameInput.value = name;
            nameInputAr.value = nameAr;
            statusSelect.value = status;

            const editModal = new bootstrap.Modal(document.getElementById('editModal'));
            editModal.show();
        });
    });
</script>

@append