@extends('admin.layout.main')
@section('title', $header['title'])


@section('content')
<style>
    .dt-input {
        font-size: 14px;
        /* Optional: smaller label */
    }

    .dt-search input {
        width: 200px;
        height: 40px;
        padding: 3px 5px;
        font-size: 14px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }
</style>
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-4 mt-2">
            <div class="col-sm-12 align-items-center d-flex breadcrumb-style">
              <h1 class="m-0">Markups Logs</h1>
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard')}}">@lang('adminUser.dashboard')</a></li>
                <li class="breadcrumb-item active">Markups Logs</li>
              </ol>
             

              </div>
              <!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->
<section class="content">
        <div class="container-fluid">
            <div class="row mt-3">
                  <div class="col-12">
                    <div class="table-card">
                      <!-- /.card-header -->
                      <div class="card-body table-radius table-responsive p-0">
                        <table class="table table-head-fixed text-nowrap" id="markupsTable">
                          <thead class="td-data-color">
                            <tr>
                              <th style="color: white; font-weight:bold">ID</th>
                              <th style="color: white; font-weight:bold">Service Name</th>
                              <th style="color: white; font-weight:bold">Purpose</th>
                              <th style="color: white; font-weight:bold">Created By</th>
                              <th style="color: white; font-weight:bold">Created At</th>
                              <th style="color: white; font-weight:bold">Updated At</th>
                              <th style="color: white; font-weight:bold">Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                      </div>
                    </div>
                </div>
            </div>
        </div>
</section>
@endsection
 @section('js')
  <link rel="stylesheet" href="https://cdn.datatables.net/2.3.1/css/dataTables.dataTables.css" />
  
<script src="https://cdn.datatables.net/2.3.1/js/dataTables.js"></script>

<script>
  $(document).ready(function() {
    console.log("Document is ready....");
    // Initialize DataTable
    $('#markupsTable').DataTable({
      "processing": true,
      "serverSide": true,
      "ajax": {
        "url": "{{ route('get-markup-logs') }}",
        "type": "GET"
      },
      "columns": [
        { "data": "DT_RowIndex", "name": "DT_RowIndex", "orderable": false, "searchable": false },
        { "data": "service_type_id" },
        { "data": "action" },
        { "data": "created_by" },
        { "data": "created_at" },
        { "data": "updated_at" },
         { "data": "action_button", orderable: false, searchable: false }
      ]
    });
  });  
</script>
@endsection 



