@extends('admin.layout.main')

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">
<style>
    textarea.select2-search__field {
        width: 40.50em !important;

    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        color: #000 !important;

    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice__display {
        margin-left: 5px;

    }

    #logic_rule,
    #hotels {
        transition: all 0.2s ease-in-out;
    }

    .select2-container--default.select2-container--open .select2-search--inline .select2-search__field {
        color: #000 !important;
    }
</style>


<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-9 d-flex breadcrumb-style">
                <h1 class="m-0">Hotel Sales Service Markups</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="{{ route('flight-sales-markups.index') }}">Sales Service Markups</a></li>
                </ol>
            </div>
        </div>
    </div>
</div>

<section class="content">
    <div class="container-fluid">
        <div class="row card p-3">
            <div class="col-12">
                <form action="{{route('hotel-sales-markups.store')}}" method="post">
                    @csrf
                    <div class="row">

                        <!-- Service Type -->
                        <div class="col-md-4">
                            <div class="form-floating form-float-style form-group required mb-3">
                                <div class="form-item form-float-style serach-rem mb-3">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" name="service_type" id="service_type" class="order-td-input selectpicker select-text height_drp is-valid select-validate" required>
                                            <option value="international" selected>International</option>
                                            <option value="domestic">Domestic</option>
                                            <option value="both">Both</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Service Type <span class="text-red">*</span></label>
                                        @error('service_type')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                      
                        <!-- Markup Percentage -->
                        <div class="col-md-4">
                            <div class="form-item form-float-style form-group">
                                <input name="markup_percentage" type="number" id="markup_percentage" autocomplete="off" value="{{ old('markup_percentage') }}" min="0" max="100" required>

                                <label for="markup_percentage">Markup (%)<span class="req-star">*</span></label>
                                @error('markup_percentage')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <!-- Fixed Service Fee -->
                        <div class="col-md-4">
                            <div class="form-item form-float-style form-group">
                                <input name="fixed_service_fee" type="number" id="fixed_service_fee" autocomplete="off" value="{{ old('fixed_service_fee') }}" required>

                                <label for="fixed_service_fee">Fixed Service Fee (SAR)<span class="req-star">*</span></label>
                                @error('fixed_service_fee')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <!-- After Sales Service Type -->
                        <div class="col-md-4">
                            <div class="form-floating form-float-style form-group required mb-3">
                                <div class="form-item form-float-style serach-rem mb-3">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" name="sales_service_type" id="sales_service_type" class="order-td-input selectpicker select-text height_drp is-valid select-validate" required>
                                            <option value="cancellation" selected>Cancellation</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Sales Service Type<span class="text-red">*</span></label>
                                        @error('sales_service_type')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Status -->
                        <div class="col-md-4">
                            <div class="form-floating form-float-style form-group required mb-3">
                                <div class="form-item form-float-style serach-rem mb-3">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" name="status" id="status" class="order-td-input selectpicker select-text height_drp is-valid select-validate" required>
                                            <option value="active" selected>Active</option>
                                            <option value="inactive">In-active</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">@lang('adminUser.status') <span class="text-red">*</span></label>
                                        @error('status')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row d-flex justify-content-start">
                        <div class="col-md-6 discount">
                            <div class="cards-btn">
                                <button type="submit" id="disBtn" class="btn btn-success form-btn-success">Save Changes</button>
                                <a href="{{ route('flight-sales-markups.index') }}" class="btn btn-danger form-btn-danger">Cancel</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    </div>
</section>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>



@endsection