@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<style>
  .form-item input.is-valids+label {
    font-size: 11px;
    top: -5px;
  }

  .hidden {
    display: none;
  }

  .dark-mode .select2-container .select2-search--inline .select2-search__field {
    color: #222 !important;
  }

  .select2-container--default .select2-selection--multiple .select2-selection__choice {
    color: #222 !important;
    padding-left: 25px !important;
  }
</style>


<!-- /.Start content-header -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-4 mt-2">
      <div class="col-sm-12 d-flex breadcrumb-style">
        <h1 class="m-0">SEO Popular Hotels - Edit</h1>
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
          <li class="breadcrumb-item"><a href="{{ route('seo-trending-hotel.index') }}">SEO Popular Hotels</a></li>
          <li class="breadcrumb-item active">Edit</li>
        </ol>
      </div><!-- /.col -->

    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.End content-header -->



<!-- Main content -->
<section class="content">
  <!-- Start container fluid -->
  <div class="container-fluid">
    <!-- Start Row Div -->
    <div class="row">
      <form id="basicForm" class="form validate mb-3 ml-0 mr-0 mt-0" action="{{ route('seo-trending-hotel.update',$trendingHotelDetails['id']) }}" method="post" enctype="multipart/form-data">
        <div class="card pb-4 pt-4 px-3 w-100">

          <div class="col-md-12">
            <div class="form-group">
              @if (session('success'))
              <div class="alert alert-success" role="alert">
                <?php echo session('success'); ?>
              </div>
              @endif
              @if (session('error'))
              <div class="alert alert-danger" role="alert">
                {{ session('error') }}
              </div>
              @endif
              @if (isset($error))
              <div class="alert alert-danger" role="alert">
                {{ $error }}
              </div>
              @endif
            </div>
          </div>

          <div class="row mb-3">
            @csrf
            @method('PUT')
            <input type="hidden" name="redirects_to" id="redirects_to" value="{{ URL::previous() }}">
            <input type="hidden" name="id" id="id" value="{{ $trendingHotelDetails['id'] }}">

            <div class="col-md-4">
              <div class="form-item form-float-style form-group">
                <select data-live-search="true" id="city" name="city" class="order-td-input select-text height_drp is-valid select2" style="width: 100%;" placeholder="Select City">
                  <?php
                  if (count($cities) > 0) {
                    foreach ($cities as $city) {
                      echo '<option value="' . $city['id'] . '" ' . ($trendingHotelDetails['city_en'] == $city['city_en'] ? 'selected' : '') . '>' . $city['city_en'] . '</option>';
                    }
                  }
                  ?>
                </select>
                <label for="from_airport">City<span class="req-star">*</span></label>
              </div>
            </div>
            <div class="col-md-4">
              <div class="form-floating form-float-style form-group required mb-3">
                <div class="form-item form-float-style serach-rem mb-3">
                  <div class="select top-space-rem after-drp form-float-style form-group">
                    <select data-live-search="true" name="status" id="status" class="order-td-input selectpicker select-text height_drp is-valid select-validate">
                      <option value="1" <?php echo ($trendingHotelDetails['status'] === 1 ? 'selected' : ''); ?>>Active</option>
                      <option value="0" <?php echo ($trendingHotelDetails['status'] === 0 ? 'selected' : ''); ?>>In-active</option>
                    </select>
                    <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">@lang('adminUser.status') <span class="text-red">*</span></label>
                  </div>
                </div>
              </div>
            </div>



            <div class="row mb-3">
                <div class="col-md-3">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="<?php echo $trendingHotelDetails['title']; ?>" id="title" name="title" autocomplete="off" class="is-valid">
                    <label for="to_date">Title <span class="req-star">*</span></label>
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="<?php echo $trendingHotelDetails['arabic_title']; ?>" id="arabic_title" name="arabic_title" autocomplete="off" class="is-valid">
                    <label for="to_date">Arabic Title <span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="<?php echo $trendingHotelDetails['sub_title']; ?>" id="sub_title" name="sub_title" autocomplete="off" class="is-valid">
                    <label for="to_date">Sub Title <span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="<?php echo $trendingHotelDetails['arabic_sub_title']; ?>" id="arabic_sub_title" name="arabic_sub_title" autocomplete="off" class="is-valid">
                    <label for="to_date">Sub Arabic Title <span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="<?php echo $trendingHotelDetails['banner_title']; ?>" id="banner_title" name="banner_title" autocomplete="off" class="is-valid">
                    <label for="to_date">Banner Title <span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="<?php echo $trendingHotelDetails['arabic_banner_title']; ?>" id="arabic_banner_title" name="arabic_banner_title" autocomplete="off" class="is-valid">
                    <label for="to_date">Banner Arabic Title <span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="{{ $trendingHotelDetails['banner_sub_title'] ?? ''  }}" id="banner_sub_title" name="banner_sub_title" autocomplete="off" class="is-valid" >
                    <label for="to_date">Banner Sub Title <span class="req-star">*</span></label>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-item form-float-style form-group">
                    <input type="text" value="{{ $trendingHotelDetails['arabic_banner_sub_title'] ?? ''  }}" id="arabic_banner_sub_title" name="arabic_banner_sub_title" autocomplete="off" class="is-valid">
                    <label for="to_date">Banner Arabic Sub Title <span class="req-star">*</span></label>
                </div>
            </div>


              <div class="col-md-6" id="uploadBanner">
              <div class="form-item form-float-style">
                <input type="hidden" id="old_photo" name="old_photo" class="file-upload" autocomplete="off" class="is-valid" value="{{ $trendingHotelDetails['banner'] }}">

                @component('components.crop-image', [
                'name' => 'upload_banner',
                'id' => 'upload_banner',
                'class' => 'file-upload is-valid image'

                ])
                @endcomponent
                <p class="upload-img-des mb-0">These images are visible in the home banner page.
                  Support jpg, jpeg, or png files.
                </p>

                <div id='profile_image_section'>
                  <img data-toggle="popover" id="croppedImagePreview" height="150px" width="150px" src="{{ asset('storage/'.$trendingHotelDetails['banner']) ?: URL::asset('assets/images/no-image.png')}}" alt="">
                  <label for="upload-profile">Upload Banner</label>

                </div>
                <input type="hidden" id="croppedImage" name="croppedImage" value="">
              </div>

            </div>


          </div>



            <div class="col-md-12 row">
              <div class="col-md-12">
                <div class="form-item form-float-style">
                  <label for="content">Content<span class="req-star">*</span></label>
                  <textarea name="content" id="editor_en" minlength="1">{!! $trendingHotelDetails['content'] !!}</textarea>
                  @error('content')
                  <span id="content-error" class="error invalid-feedback ">{{ $message }}</span>
                  @enderror
                </div>
              </div>
            </div>

            <div class="col-md-12 row">
                        <div class="col-md-12">
                            <div class="form-item form-float-style">
                                <label for="arabic_content">Arabic Content<span class="req-star">*</span></label>
                                <textarea  name="arabic_content" id="editor_en" minlength="1" dir="rtl">{!! $trendingHotelDetails['arabic_content'] !!}</textarea>
                                @error('arabic_content')
                                <span id="content-error" class="error invalid-feedback ">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                    </div>      

            <div class="col-md-4 discount">
              <div class="cards-btn">
                <button type="submit" id="disBtn" class="btn btn-success form-btn-success">Submit</button>
                <a href="{{ route('seo-trending-hotel.index') }}" class="btn btn-danger form-btn-danger">Cancel</a>
              </div>

            </div>
      </form>

    </div>
  </div>
  </div>
  </div>
  </div>
  </div>



  </div>
  <!-- /.row -->
  </div>
  <!-- End Row Div -->

  </div>

  <!-- End container fluid -->
</section>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

<script>
  $(document).ready(function() {
    $('.airport_list').select2();
  });
</script>

@append