@extends('admin.layout.main')
@section('title', $header['title'])

@section('content')
<style>
    .select2-search__field {
        color: black !important;
    }

    textarea.select2-search__field {
        width: 41.50em !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        color: #000 !important;
    }
    .select2-container--default .select2-selection--multiple .select2-selection__choice__display {
    margin-left: 5px;
}
</style>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-4 mt-2">
      <div class="col-sm-12 d-flex breadcrumb-style">
        <h1 class="m-0">{{ $header['heading'] }}</h1>
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">@lang('general.dashboard') </a></li>
          <li class="breadcrumb-item active">@lang('general.moduleHeading')</li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <!-- Info boxes -->
    <div class="row">
      <div class="card pb-4 pt-4 px-3 w-100">
        <div class="col-md-12">
          <div class="form-group">
            @if (session('success'))
            <div class="alert alert-success" role="alert">
              <?php echo session('success'); ?>
            </div>
            @endif
            @if (session('error'))
            <div class="alert alert-danger" role="alert">
              {{ session('error') }}
            </div>
            @endif
            @if (isset($error))
            <div class="alert alert-danger" role="alert">
              {{ $error }}
            </div>
            @endif
          </div>
        </div>
        <div class="row mb-3">
          <div class="col-md-6 discount">
            <form id="basicForm" class="brdr-btm form validate mb-3 ml-0 mr-0 mt-0" action="{{ route('general.basic') }}" method="post" enctype="multipart/form-data">
              @csrf
              <h5 class="setting-title">@lang('general.basicInformation')</h5>
              <div class="form-item form-float-style">
                <input type="file" id="upload-color-logo" name="general|basic|colorLogo" class="file-upload" autocomplete="off" class="is-valid">
                <label for="upload-color-logo">@lang('general.uploadColorLogo') <span class="req-star">*</span></label>
              </div>
              @php
              $logo = "";
              @$logo = App\Models\Setting::where('config_key', 'general|basic|colorLogo')->get('value')[0]['value'];
              @endphp
              @if($logo)
              <image src="{{@$logo}}" width="90px" class="img_prev mt-0 mb-3 p-2">
                @endif
                <div class="form-item form-float-style">
                  <input type="file" id="upload-white-logo" name='general|basic|whiteLogo' class="upload-white-logo" autocomplete="off" class="is-valid">
                  <label for="upload-white-logo">@lang('general.uploadWhiteLogo') <span class="req-star">*</span></label>
                </div>
                @php
                $logo = "";
                @$logo = App\Models\Setting::where('config_key', 'general|basic|whiteLogo')->get('value')[0]['value'];
                @endphp
                @if($logo)
                <image src="{{$logo}}" width="90px" class="img_prev mt-0 mb-3 p-2">
                  @endif
                  <div class="form-item form-float-style">
                    <input type="file" id="upload-fav" name='general|basic|favicon' class="file-upload" autocomplete="off" class="is-valid">
                    <label for="upload-fav">@lang('general.uploadFaviconLogo') <span class="req-star">*</span></label>
                  </div>
                  @php
                  $logo = "";
                  @$logo = App\Models\Setting::where('config_key', 'general|basic|favicon')->get('value')[0]['value'];
                  @endphp
                  @if($logo)
                  <image src="{{$logo}}" width="90px" class="img_prev mt-0 mb-3 p-2">
                    @endif
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|basic|siteName')->get('value')[0]['value'];
                      @endphp
                      <input type="text" value="{{ @old('general|basic|siteName')?@old('general|basic|siteName'):$value }}" id="compname" name='general|basic|siteName' autocomplete="off" class="is-valid">
                      <label for="compname">@lang('general.companyName') <span class="req-star">*</span></label>
                    </div>
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|basic|siteUrl')->get('value')[0]['value'];
                      @endphp
                      <input type="text" value="{{ @old('general|basic|siteUrl')?@old('general|basic|siteUrl'):$value }}" name='general|basic|siteUrl' id="weburl" autocomplete="off" class="is-valid">
                      <label for="weburl">@lang('general.companyWebsiteURl') <span class="req-star">*</span></label>
                    </div>
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|basic|siteEmail')->get('value')[0]['value'];
                      @endphp
                      <input type="text" value="{{ @old('general|basic|siteEmail')?@old('general|basic|siteEmail'):$value }}" name='general|basic|siteEmail' id="emailadd" autocomplete="off" class="is-valid">
                      <label for="emailadd">@lang('general.companyEmailAddress') <span class="req-star">*</span></label>
                    </div>
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|basic|sitePhoneNo')->get('value')[0]['value'];
                      @endphp
                      <input type="text" name='general|basic|sitePhoneNo' value="{{ @old('general|basic|sitePhoneNo')?@old('general|basic|sitePhoneNo'):$value }}" id="phoneno" autocomplete="off" class="is-valid">
                      <label for="phoneno">@lang('general.companyPhoneNumber') <span class="req-star">*</span></label>
                    </div>
                    <div class="cards-btn">
                      <button type="submit" class="btn btn-success form-btn-success">@lang('general.submit')</button>
                    </div>
            </form>
            <h5 class="setting-title">@lang('general.maintenanceMode')</h5>
            <form class="brdr-btm form validate mb-3 ml-0 mr-0 mt-0" method="post" action="{{ route('general.maintenance') }}" id="maintenanceModeForm" name="maintenanceModeForm">
              @csrf

              @php
              $value = "";
              @$value = App\Models\Setting::where('config_key', 'general|maintenanceMode')->get('value')[0]['value'];
              @endphp
              <div class="q-a mb-2">
                <div class="form-check">
                  <input type="radio" id="radioSuccess10" name="general|maintenanceMode" data-change="maintenance_mode" class="form-check-input maintenanceMode" value="on" {{ (old('general|maintenanceMode') == "on" || $value == "on") ? 'checked' : '' }} checked>
                  <label class="form-check-label" for="radioSuccess10">@lang('general.on')</label>
                </div>


                <div class="form-check">
                  <input type="radio" id="radioSuccess11" name="general|maintenanceMode" data-change="maintenance_mode" class="form-check-input maintenanceMode" value="off" {{ (old('general|maintenanceMode') == "off" || $value == "off") ? 'checked' : '' }}>
                  <label class="form-check-label" for="radioSuccess11">@lang('general.off')</label>
                </div>

              </div>
              <div class="form-group" id="maintenance_mode">
                <div class="form-item form-float-style w-100">
                  @php
                  $value = "";
                  @$value = App\Models\Setting::where('config_key', 'general|maintenanceMode|message')->get('value')[0]['value'];
                  @endphp
                  <input type="text" id="maintenanceMessage" name="general|maintenanceMode|message" value="{{ @old('general|maintenanceMode|message')?@old('general|maintenanceMode|message'):$value }}" autocomplete="off" class="is-valid">
                  <label for="maintenanceMessage">@lang('general.maintenanceMessage')</label>
                </div>
              </div>
              <div class="cards-btn">
                <button type="submit" class="btn btn-success form-btn-success">@lang('general.submit')</button>
              </div>
            </form>

          </div>

          <div class="col-md-6 discount">
            <form class="brdr-btm form validate m-0" action="{{ route('general.addressInformation') }}" method="post" id="addressInfoForm">
              @csrf
              <h5 class="setting-title">@lang('general.addressInformation')</h5>

              <div class="form-item form-float-style mb-2s">
                @php
                $value = "";
                @$value = App\Models\Setting::where('config_key', 'general|basic|storeAddress')->get('value')[0]['value'];
                @endphp
                <input type="text" id="setting-search-add" name="searchAddress" value="" class="autocomplete" id="searchAddress" autocomplete="on">
                <label for="setting-search-add">@lang('general.searchAddress')</label>
                <div id="menu-container"></div>

              </div>
              <div class="form-check filter-check sub-check mb-3">

                <input class="form-check-input" type="checkbox" value="" id="searchAddressChecked" name="searchAddress">
                <label class="form-check-label" for="flexCheckDefault1">
                  @lang('general.enterManualAddress')
                </label>
              </div>
              <div class="form-item form-float-style">
                @php
                $value = "";
                $placeId = "";
                @$value = App\Models\Setting::where('config_key', 'general|basic|storeAddress')->get('value')[0]['value'];
                @$placeId = App\Models\Setting::where('config_key', 'general|basic|place_id')->get('value')[0]['value'];
                @endphp
                <input type="hidden" value="{{ old('general|basic|place_id')? old('general|basic|place_id') : $placeId }}" name="general|basic|place_id" id="place_id">

                <textarea type="text" name='general|basic|storeAddress' id="address" autocomplete="off" required class="removeReadOnly is-valid" readonly>{{ @old('general|basic|storeAddress')?@old('general|basic|storeAddress'):$value }}</textarea>
                <label for="address">@lang('general.address') <span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style">
                @php
                $value = "";
                @$value = App\Models\Setting::where('config_key', 'general|basic|storeCountry')->get('value')[0]['value'];
                @endphp
                <input type="text" class="removeReadOnly is-valid" value="{{ @old('general|basic|storeCountry')?@old('general|basic|storeCountry'):$value }}" id="country" name='general|basic|storeCountry' autocomplete="off" readonly>
                <label for="country">@lang('general.country') <span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style">
                @php
                $value = "";
                @$value = App\Models\Setting::where('config_key', 'general|basic|storeState')->get('value')[0]['value'];
                @endphp
                <input type="text" class="removeReadOnly is-valid" value="{{ @old('general|basic|storeState')?@old('general|basic|storeState'):$value }}" name='general|basic|storeState' id="state" autocomplete="off" readonly>
                <label for="state">@lang('general.state') <span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style">
                @php
                $value = "";
                @$value = App\Models\Setting::where('config_key', 'general|basic|storeCity')->get('value')[0]['value']
                @endphp
                <input type="text" class="removeReadOnly is-valid" value="{{ @old('general|basic|storeCity')?@old('general|basic|storeCity'):$value }}" name='general|basic|storeCity' id="city" autocomplete="off" readonly>
                <label for="city">@lang('general.city') <span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style">
                @php
                $value = "";
                @$value = App\Models\Setting::where('config_key', 'general|basic|storePincode')->get('value')[0]['value'];
                @endphp
                <input type="text" class="removeReadOnly is-valid" value="{{ @old('general|basic|storePincode')?@old('general|basic|storePincode'):$value }}" name='general|basic|storePincode' id="pincode" autocomplete="off" readonly>
                <label for="pincode">@lang('general.pincode') <span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style">
                @php
                $value = "";
                @$value = App\Models\Setting::where('config_key', 'general|basic|storeLattitude')->get('value')[0]['value'];
                @endphp
                <input type="text" name="general|basic|storeLattitude" id="lattitude" value="{{ @old('general|basic|storeLattitude')?@old('general|basic|storeLattitude'):$value }}" class="removeReadOnly is-valid" autocomplete="off" readonly>
                <label for="setting-latitude">@lang('general.latitude')</label>
              </div>
              <div class="form-item form-float-style">
                @php
                $value = "";
                @$value = App\Models\Setting::where('config_key', 'general|basic|storeLongitude')->get('value')[0]['value'];
                @endphp
                <input type="text" name="general|basic|storeLongitude" id="longitude" value="{{ @old('general|basic|storeLongitude')?@old('general|basic|storeLongitude'):$value }}" class="removeReadOnly is-valid" autocomplete="off" value="" readonly>
                <label for="setting-longitude">@lang('general.longitude')</label>
              </div>
              <div class="cards-btn">
                <button type="submit" class="btn btn-success form-btn-success">@lang('general.submit')</button>
              </div>
            </form>
          </div>
          <form class="form validate brdr-btm row mb-3" action="{{ route('general.additionalInformation') }}" method="post" id="additionalInfoForm">
            @csrf
            <div class="col-md-12 discount">
              <div>
                <h5 class="setting-title">@lang('general.additionalInformation')</h5>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      <div class="form-floating">
                        <div class="select after-drp">
                          @php
                          $value = "";
                          @$value = App\Models\Setting::where('config_key', 'general|site|dateFormat')->get('value')[0]['value'];
                          @endphp
                          <select class="select-text disabled height_drp" name="general|site|dateFormat">
                            <option {{ (@$old['general|site|dateFormat'] == "F j, Y") || ($value == "F j, Y") ? 'selected' : '' }} value="F j, Y" readonly>April 30, 2022</option>
                            <option {{ (@$old['general|site|dateFormat'] == "Y-m-d") || ($value == "Y-m-d") ? 'selected' : '' }} value="Y-m-d" readonly>2022-04-30</option>
                            <option {{ (@$old['general|site|dateFormat'] == "m/d/y") || ($value == "m/d/y") ? 'selected' : '' }} value="m/d/y">04/30/2022</option>
                            <option {{ (@$old['general|site|dateFormat'] == "d/m/y") || ($value == "d/m/y") ? 'selected' : '' }} value="d/m/y">30/04/2022</option>
                          </select>
                          <label class="select-label">@lang('general.dateFormat')</label>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      <div class="form-floating">
                        <div class="select after-drp">
                          @php
                          $value = "";
                          @$value = App\Models\Setting::where('config_key', 'general|site|timeFormat')->get('value')[0]['value'];
                          @endphp
                          <select class="select-text disabled height_drp" name="general|site|timeFormat">
                            <option {{ (@$old['general|site|timeFormat'] == "H:m:s") || ($value == "H:m:s") ? 'selected' : '' }} value="H:m:s">24:00:00</option>
                            <option {{ (@$old['general|site|timeFormat'] == "h:m:s A") || ($value == "h:m:s A") ? 'selected' : '' }} value="h:m:s A">12:00:00 AM</option>
                            <option {{ (@$old['general|site|timeFormat'] == "H:m") || ($value == "H:m") ? 'selected' : '' }} value="H:m">24:00</option>
                            <option {{ (@$old['general|site|timeFormat'] == "h:m A") || ($value == "h:m A") ? 'selected' : '' }} value="h:m A">12:00 AM</option>
                          </select>
                          <label class="select-label">@lang('general.timeFormat')</label>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      <div class="form-floating">
                        <div class="select after-drp">
                          @php
                          $value = "";
                          @$value = App\Models\Setting::where('config_key', 'general|site|timeZone')->get('value')[0]['value'];
                          @endphp
                          <select class="select-text disabled height_drp" name="general|site|timeZone">
                            @foreach($items as $k=>$v)
                            <option {{ (old('general|site|timeZone') == $k) || ($value == $k) ? 'selected' : ''}} value="{{ $k }}">{{ $v }}</option>
                            @endforeach
                          </select>
                          <label class="select-label">@lang('general.timeZone')</label>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|googleApiKey')->get('value')[0]['value'];
                      @endphp
                      <input type="text" name="general|site|googleApiKey" value="{{ @old('general|site|googleApiKey')?@old('general|site|googleApiKey'):$value }}" id="general|site|googleApiKey" autocomplete="off" class="is-valid">
                      <label for="googleapi">@lang('general.googleMapAPIKey') <span class="req-star">*</span></label>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|inquiryEmail')->get('value')[0]['value'];
                      @endphp
                      <input type="email" name="general|site|inquiryEmail" id="general|site|inquiryEmail" value="{{ @old('general|site|inquiryEmail')?@old('general|site|inquiryEmail'):$value }}" autocomplete="off" class="is-valid">
                      <label for="inqemail">@lang('general.inquiryEmailAddress') <span class="req-star">*</span></label>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|footerText')->get('value')[0]['value'];
                      @endphp
                      <input type="text" name="general|site|footerText" id="general|site|footerText" value="{{ @old('general|site|footerText')?@old('general|site|footerText'):$value }}" autocomplete="off" class="is-valid">
                      <label for="footer-text">@lang('general.footerText') <span class="req-star">*</span></label>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-floating">
                      <div class="select top-space-rem after-drp form-item form-float-style">
                        @php
                        $value = "";
                        @$value = App\Models\Setting::where('config_key', 'general|setting|ResetMonth')->get('value')[0]['value'];
                        @endphp
                        <select data-live-search="true" name="general|setting|ResetMonth" id="month" class="order-td-input selectpicker select-text height_drp is-valid">
                          <?php for ($i = 1; $i <= 12; $i++) : ?>
                            <?php
                            if ($i <= 9) {
                              $i = '0' . $i;
                            }
                            ?>
                            <option {{ (old('general|setting|ResetMonth') == $i) || ($value == $i) ? 'selected' : ''}} value="<?= $i; ?>"><?= $i; ?></option>
                          <?php endfor ?>
                        </select>
                        <label class="select-label searchable-drp">@lang('general.orderIDResetMonth')</label>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="select top-space-rem after-drp form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|defaultISDCode')->get('value')[0]['value'];
                      @endphp
                      <select data-live-search="true" id="isd_code" name="general|site|defaultISDCode" class="order-td-input selectpicker select-text height_drp is-valid">
                        <option value="">Select ISD Code</option>
                        @foreach($countries as $country)
                        <option value="{{ $country['isd_code'] }}" {{ (old('general|site|defaultISDCode') == $country['isd_code']) || ($value == $country['isd_code']) ? 'selected' : ''}}>
                            {{ $country['isd_code'] }}&nbsp;{{ $country['country_name'] }}
                        </option>
                        @endforeach
                      </select>
                      <label for="ISD Code" id="isd-code-customer">Default ISD Code<span class="req-star">*</span></label>
                      @error('email')
                      <span id="isd-error" class="error invalid-feedback-isd-code">{{ $message }}</span>
                      @enderror
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="select top-space-rem after-drp form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|defaultLanguageCode')->get('value')[0]['value'];
                      @endphp
                      <select data-live-search="true" id="isd_code" name="general|site|defaultLanguageCode" class="order-td-input selectpicker select-text height_drp is-valid">
                        <option value="">Select Language</option>
                        @foreach($getLanguages as $language)
                        <option value="{{ $language->language_code }}" {{ (old('general|site|defaultLanguageCode') == $language->language_code) || ($value == $language->language_code) ? 'selected' : ''}}>
                          {{ $language->language_name }}
                        </option>
                        @endforeach
                      </select>
                      <label for="ISD Code" id="isd-code-customer">Default Language<span class="req-star">*</span></label>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|defaultVatPercentage')->get('value')[0]['value'];
                      @endphp
                      <input type="text" name="general|site|defaultVatPercentage" id="general|site|defaultVatPercentage" value="{{ @old('general|site|defaultVatPercentage')?@old('general|site|defaultVatPercentage'):$value }}" autocomplete="off" class="is-valid">
                      <label for="default-Vat-Percentage">Default VAT Percentage (%)<span class="req-star">*</span></label>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="select top-space-rem after-drp form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|defaultCountry')->get('value')[0]['value'];
                      @endphp
                      {{-- @component('components.country_city_select', [
                      'name' => 'general|site|defaultCountry',
                      'id' => 'country_code',
                      'class' => 'order-td-input selectpicker1 select-text height_drp is-valid select2',
                      'selected' => @old('general|site|defaultCountry')?@old('general|site|defaultCountry'):$value,
                      'placeholder' => 'Select Country'
                      ])
                      @endcomponent --}}
                      <select data-live-search="true" id="country_code" name="general|site|defaultCountry" class="order-td-input selectpicker select-text height_drp is-valid">
                        <option value="">Select Country</option>
                        @foreach($countries as $country)
                        <option value="{{ $country['iso_code'] }}" {{ (old('general|site|defaultCountry') == $country['iso_code']) || ($value == $country['iso_code']) ? 'selected' : ''}}>
                            {{ $country['country_name'] }}
                        </option>
                        @endforeach
                      </select>
                      <label for="country" id="customer-country">Default Country <span class="req-star">*</span></label>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|maxRedeemPointsFixedAmount')->get('value')[0]['value'];
                      @endphp
                      <input type="text" name="general|site|maxRedeemPointsFixedAmount" id="general|site|maxRedeemPointsFixedAmount" value="{{ @old('general|site|maxRedeemPointsFixedAmount')?@old('general|site|maxRedeemPointsFixedAmount'):$value }}" autocomplete="off" class="is-valid">
                      <label for="max-redeem-points-percentage">Max Redeem Points (Fixed Amount)<span class="req-star">*</span></label>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|flightServiceFee')->get('value')[0]['value'];
                      @endphp
                      <input type="text" name="general|site|flightServiceFee" id="general|site|flightServiceFee" value="{{ @old('general|site|flightServiceFee')?@old('general|site|flightServiceFee'):$value }}" autocomplete="off" class="is-valid">
                      <label for="service-fee">Flight Service Fee (Fixed Amount)<span class="req-star">*</span></label>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|hotelServiceFee')->get('value')[0]['value'];
                      @endphp
                      <input type="text" name="general|site|hotelServiceFee" id="general|site|hotelServiceFee" value="{{ @old('general|site|hotelServiceFee')?@old('general|site|hotelServiceFee'):$value }}" autocomplete="off" class="is-valid">
                      <label for="service-fee">Hotel Service Fee (Fixed Amount)<span class="req-star">*</span></label>
                    </div>
                  </div>


                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|flightBookingAddOn')->get('value')[0]['value'];
                      @endphp
                      <input type="text" name="general|site|flightBookingAddOn" id="general|site|flightBookingAddOn" value="{{ @old('general|site|flightBookingAddOn')?@old('general|site|flightBookingAddOn'):$value }}" autocomplete="off" class="is-valid">
                      <label for="service-fee">Flight Booking Add-on (Fixed Amount)<span class="req-star">*</span></label>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|hotelBookingAddOn')->get('value')[0]['value'];
                      @endphp
                      <input type="text" name="general|site|hotelBookingAddOn" id="general|site|hotelBookingAddOn" value="{{ @old('general|site|hotelBookingAddOn')?@old('general|site|hotelBookingAddOn'):$value }}" autocomplete="off" class="is-valid">
                      <label for="service-fee">Hotel Booking Add-on (Fixed Amount)<span class="req-star">*</span></label>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="select top-space-rem after-drp form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|arabic_speak_country')->get('value')[0]['value'];
                      @endphp
                      <?php
                      $value = explode(',', $value);
                      $selectedValues = is_array($value) ? $value : [$value];
                      ?>
                      @component('components.country_city_select', [
                      'name' => 'general|site|arabic_speak_country[]',
                      'id' => 'arabic_country_code',
                      'class' => 'order-td-input selectpicker1 select-text height_drp is-valid select2',
                      'selected' => $selectedValues,
                      'placeholder' => 'Select Country',
                      'multiple' => true
                      ])
                      @endcomponent
                      <label for="arabic_speak_country" id="customer-country">Arabic Speak Country <span class="req-star">*</span></label>
                    </div>
                  </div>

                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|cancelBufferTime')->get('value')[0]['value'];
                      @endphp
                      <input type="number" name="general|site|cancelBufferTime" id="general|site|cancelBufferTime" value="{{ @old('general|site|cancelBufferTime')?@old('general|site|cancelBufferTime'):$value }}" autocomplete="off" class="is-valid" placeholder="Ex: 12, 24, 48..">
                      <label for="general|site|cancelBufferTime">Cancellation Policy Buffer Time<span class="req-star">*</span></label>
                    </div>
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'signUpOtpAttempts|perHost')->get('value')[0]['value'];
                      @endphp
                      <input type="number" name="signUpOtpAttempts|perHost" id="signUpOtpAttempts|perHost" value="{{ @old('signUpOtpAttempts|perHost')?@old('signUpOtpAttempts|perHost'):$value }}" autocomplete="off" class="is-valid" placeholder="">
                      <label for="signUpOtpAttempts|perHost">Sign Up OTP Attempt Limit (Per IP) <span class="req-star">*</span></label>
                    </div>
                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'signUpOtpAttempts|perCust')->get('value')[0]['value'];
                      @endphp
                      <input type="number" name="signUpOtpAttempts|perCust" id="signUpOtpAttempts|perCust" value="{{ @old('signUpOtpAttempts|perCust')?@old('signUpOtpAttempts|perCust'):$value }}" autocomplete="off" class="is-valid" placeholder="">
                      <label for="signUpOtpAttempts|perCust">Sign Up OTP Attempt Limit (Per Customer) <span class="req-star">*</span></label>
                    </div>

                    <div class="form-item form-float-style">
                      @php
                      $value = "";
                      @$value = App\Models\Setting::where('config_key', 'general|site|rankCountries')->get('value')[0]['value'];
                      @endphp
                      <input type="text" name="general|site|rankCountries" id="general|site|rankCountries" value="{{ @old('general|site|rankCountries')?@old('general|site|rankCountries'):$value }}" autocomplete="off" class="is-valid">
                      <label for="general|site|rankCountries">Rank Countries (comma seperated)<span class="req-star">*</span></label>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "enabled";
                      @$value = App\Models\Setting::where('config_key', 'general|site|togglePayment')->get('value')[0]['value'];
                      @endphp
                      <select name="general|site|togglePayment" id="general|site|togglePayment" style="width: 100%; border: 1px solid #CCC; border-radius: 5px; padding: 10px;">
                        <option value="enabled" <?php echo ($value == "enabled") ? "selected" : "" ?>>Enabled</option>
                        <option value="disabled" <?php echo ($value == "disabled") ? "selected" : "" ?>>Disabled</option>
                      </select>
                      <label for="general|site|togglePayment">Enable/Disable Payment<span class="req-star">*</span></label>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                      @php
                      $value = "disabled";
                      @$value = App\Models\Setting::where('config_key', 'general|site|toggleTestPayment')->get('value')[0]['value'];
                      @endphp
                      <select name="general|site|toggleTestPayment" id="general|site|toggleTestPayment" style="width: 100%; border: 1px solid #CCC; border-radius: 5px; padding: 10px;">
                        <option value="enabled" <?php echo ($value == "enabled") ? "selected" : "" ?>>Enabled</option>
                        <option value="disabled" <?php echo ($value == "disabled") ? "selected" : "" ?>>Disabled</option>
                      </select>
                      <label for="general|site|toggleTestPayment">Enable/Disable Test Payment<span class="req-star">*</span></label>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                        @php
                        $value = "";
                        @$value = App\Models\Setting::where('config_key', 'general|site|toggleTestPaymentValue')->get('value')[0]['value'];
                        @endphp
                        <input type="text" name="general|site|toggleTestPaymentValue" id="general|site|toggleTestPaymentValue" value="{{ @old('general|site|toggleTestPaymentValue')?@old('general|site|toggleTestPaymentValue'):$value }}" autocomplete="off" class="is-valid">
                        <label for="general|site|toggleTestPaymentValue">Test Payment Amount</label>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                        @php
                        $value = "";
                        @$value = App\Models\Setting::where('config_key', 'general|site|qrCodeUrl')->get('value')[0]['value'];
                        @endphp
                        <input type="text" name="general|site|qrCodeUrl" id="general|site|qrCodeUrl" value="{{ @old('general|site|qrCodeUrl')?@old('general|site|qrCodeUrl'):$value }}" autocomplete="off" class="is-valid">
                        <label for="general|site|qrCodeUrl">QR Code URL</label>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                        @php
                        $value = "";
                        @$value = App\Models\Setting::where('config_key', 'general|android|appUrl')->get('value')[0]['value'];
                        @endphp
                        <input type="text" name="general|android|appUrl" id="general|android|appUrl" value="{{ @old('general|android|appUrl')?@old('general|android|appUrl'):$value }}" autocomplete="off" class="is-valid">
                        <label for="general|android|appUrl">Android App URL</label>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="form-item form-float-style">
                        @php
                        $value = "";
                        @$value = App\Models\Setting::where('config_key', 'general|ios|appUrl')->get('value')[0]['value'];
                        @endphp
                        <input type="text" name="general|ios|appUrl" id="general|ios|appUrl" value="{{ @old('general|ios|appUrl')?@old('general|ios|appUrl'):$value }}" autocomplete="off" class="is-valid">
                        <label for="general|ios|appUrl">iOS App URL</label>
                    </div>
                  </div>


                </div>
                <div class="cards-btn">
                  <button type="submit" class="btn btn-success form-btn-success">@lang('general.submit')</button>
                </div>
              </div>
            </div>
          </form>
          <div class="pt-0">
            <div class="col-md-12 discount p-0">
              <div class="row">
                <div class="col-md-6">
                  <h5 class="setting-title">@lang('general.androidAutoUpdate')</h5>
                  <form class="brdr-btm form-horizontal mb-3" method="post" action="{{ route('general.mobile') }}" id="androidVersion" name="androidVersion">
                    @csrf
                    <input type="hidden" name="updateFor" value="android">
                    @php
                    $value = "";
                    @$value = App\Models\Setting::where('config_key', 'general|androidUpdate')->get('value')[0]['value'];
                    @endphp
                    <div class="q-a mb-2">
                      <div class="form-check">
                        <input type="radio" id="radioSuccess13" name="general|androidUpdate" class="form-check-input mobileUpdate" data-change='android_update' value="optional" {{ (old('general|androidUpdate') == "optional" || $value == "optional") ? 'checked' : '' }} checked>
                        <label class="form-check-label" for="radioSuccess13">@lang('general.optional')</label>
                      </div>
                      <div class="form-check">
                        <input type="radio" id="radioSuccess14" name="general|androidUpdate" class="form-check-input mobileUpdate" data-change='android_update' value="forcefully" {{ (old('general|androidUpdate') == "forcefully" || $value == "forcefully") ? 'checked' : '' }}>
                        <label class="form-check-label" for="radioSuccess14">@lang('general.forcefully')</label>
                      </div>
                    </div>
                    <div class="form-group" id="android_update">
                      <div class="form-item form-float-style w-100">
                        @php
                        $value = "";
                        @$value = App\Models\Setting::where('config_key', 'general|android|version')->get('value')[0]['value'];
                        @endphp
                        <input type="text" id="andrverison" name="general|android|version" value="{{ @old('general|android|version')?@old('general|android|version'):$value }}" autocomplete="off" class="is-valid">
                        <label for="andrverison">@lang('general.androidVersion')</label>
                      </div>
                    </div>
                    <div class="form-group">
                        <div class="form-item form-float-style w-100">
                          @php
                          $value = "";
                          @$value = App\Models\Setting::where('config_key', 'general|android|appUrl')->get('value')[0]['value'];
                          @endphp
                          <input type="text" id="androidAppUrl" name="general|android|appUrl" value="{{ @old('general|android|appUrl')?@old('general|android|version'):$value }}" autocomplete="off" class="is-valid">
                          <label for="androidAppUrl">Android App URL</label>
                        </div>
                      </div>
                    <div class="cards-btn">
                      <button type="submit" class="btn btn-success form-btn-success">@lang('general.submit')</button>
                    </div>
                  </form>
                </div>
                <div class="col-md-6">
                  <h5 class="setting-title">@lang('general.iosAutoUpdate')</h5>
                  <form class="form-horizontal" method="post" action="{{ route('general.mobile') }}" id="iosVersion" name="iosVersion">
                    @csrf
                    <input type="hidden" name="updateFor" value="ios">
                    @php
                    $value = "";
                    @$value = App\Models\Setting::where('config_key', 'general|iosUpdate')->get('value')[0]['value'];
                    @endphp
                    <div class="q-a mb-2">
                      <div class="form-check">
                        <input type="radio" id="radioSuccess15" name="general|iosUpdate" class="form-check-input mobileUpdate" data-change='ios_update' value="optional" {{ (old('general|iosUpdate') == "optional" || $value == "optional") ? 'checked' : '' }} checked>
                        <label class="form-check-label" for="radioSuccess15">@lang('general.optional')</label>
                      </div>
                      <div class="form-check">
                        <input type="radio" id="radioSuccess16" name="general|iosUpdate" class="form-check-input mobileUpdate" data-change='ios_update' value="forcefully" {{ (old('general|iosUpdate') == "forcefully" || $value == "forcefully") ? 'checked' : '' }}>
                        <label class="form-check-label" for="radioSuccess16">@lang('general.forcefully')</label>
                      </div>
                    </div>
                    <div id="ios_update">
                      <div class="form-item form-float-style w-100">
                        @php
                        $value = "";
                        @$value = App\Models\Setting::where('config_key', 'general|ios|version')->get('value')[0]['value'];
                        @endphp
                        <input type="text" id="iosver" name="general|ios|version" value="{{ @old('general|ios|version')?@old('general|ios|version'):$value }}" autocomplete="off" class="is-valid">
                        <label for="iosver">@lang('general.iosVersion')</label>
                      </div>
                    </div>
                    <div>
                        <div class="form-item form-float-style w-100">
                          @php
                          $value = "";
                          @$value = App\Models\Setting::where('config_key', 'general|ios|appUrl')->get('value')[0]['value'];
                          @endphp
                          <input type="text" id="iosAppUrl" name="general|ios|appUrl" value="{{ @old('general|ios|appUrl')?@old('general|ios|appUrl'):$value }}" autocomplete="off" class="is-valid">
                          <label for="iosAppUrl">iOS App URL</label>
                        </div>
                      </div>
                    <div class="cards-btn">
                      <button type="submit" class="btn btn-success form-btn-success">@lang('general.submit')</button>
                    </div>
                  </form>
                </div>
                <h5 class="setting-title">OTP Verification</h5>
                <form class="brdr-btm form validate mb-3 ml-0 mr-0 mt-0" method="post" action="{{ route('general.otp-phoneVerification') }}">
                  @csrf

                  @php
                  $value = "";
                  @$value = App\Models\Setting::where('config_key', 'general|otp|phoneVerification')->get('value')[0]['value'];
                  @endphp
                  <div class="q-a mb-2">
                    <div class="form-check">
                      <input type="radio" id="radioSuccess12" name="general|otp|phoneVerification" class="form-check-input" value="on" {{ (old('general|otp|phoneVerification') == "on" || $value == "on") ? 'checked' : '' }} checked>
                      <label class="form-check-label" for="radioSuccess12">@lang('general.on')</label>
                    </div>
                    <div class="form-check">
                      <input type="radio" id="radioSuccess17" name="general|otp|phoneVerification" class="form-check-input" value="off" {{ (old('general|otp|phoneVerification') == "off" || $value == "off") ? 'checked' : '' }}>
                      <label class="form-check-label" for="radioSuccess17">@lang('general.off')</label>
                    </div>
                  </div>

                   @php
                  $value = "";
                  @$value = App\Models\Setting::where('config_key', 'general|otp|mobileBookingVerification')->get('value')[0]['value'];
                  @endphp
                   <h5 class="setting-title">Mobile Number Verification (Booking Cycle)</h5>
                  <div class="q-a mb-2">
                    <div class="form-check">
                      <input type="radio" id="radioSuccess18" name="general|otp|mobileBookingVerification" class="form-check-input" value="on" {{ (old('general|otp|mobileBookingVerification ') == "on" || $value == "on") ? 'checked' : '' }} checked>
                      <label class="form-check-label" for="radioSuccess18">@lang('general.on')</label>
                    </div>
                    <div class="form-check">
                      <input type="radio" id="radioSuccess19" name="general|otp|mobileBookingVerification" class="form-check-input" value="off" {{ (old('general|otp|mobileBookingVerification') == "off" || $value == "off") ? 'checked' : '' }}>
                      <label class="form-check-label" for="radioSuccess19">@lang('general.off')</label>
                    </div>
                  </div>
                  <div class="cards-btn">
                    <button type="submit" class="btn btn-success form-btn-success">@lang('general.submit')</button>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- /.row -->
    </div>
    <!--/. container-fluid -->
</section>
<!-- /.content -->

@endsection
@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

<script>
  //dealer
  $.validator.addMethod('dealerMinStrict', function(value, el, param) {
    if ($("#dealer_max_val").val() != "" && value != "") {
      var maxVal = parseInt($("#dealer_max_val").val());
      return value < maxVal;
    } else {
      return true;
    }
  }, 'value should minimum value than maximum value');
  $.validator.addMethod('dealerMaxStrict', function(value, el, param) {
    if ($("#dealer_min_val").val() != "" && value != "") {
      var minVal = parseInt($("#dealer_min_val").val());
      return value > minVal;
    } else {
      return true;
    }
  }, 'value should maximum value than minimum value');

  //exclusive dealer
  $.validator.addMethod('exDealerMinStrict', function(value, el, param) {
    if ($("#ex_dealer_max_val").val() != "" && value != "") {
      var maxVal = parseInt($("#ex_dealer_max_val").val());
      return value < maxVal;
    } else {
      return true;
    }
  }, 'value should minimum value than maximum value');
  $.validator.addMethod('exDealerMaxStrict', function(value, el, param) {
    if ($("#ex_dealer_min_val").val() != "" && value != "") {
      var minVal = parseInt($("#ex_dealer_min_val").val());
      return value > minVal;
    } else {
      return true;
    }
  }, 'value should maximum value than minimum value');

  //channel partner
  $.validator.addMethod('channelPartnerMinStrict', function(value, el, param) {
    if ($("#channel_partner_max_val").val() != "" && value != "") {
      var maxVal = parseInt($("#channel_partner_max_val").val());
      return value < maxVal;
    } else {
      return true;
    }
  }, 'value should minimum value than maximum value');
  $.validator.addMethod('channelPartnerMaxStrict', function(value, el, param) {
    if ($("#channel_partner_min_val").val() != "" && value != "") {
      var minVal = parseInt($("#channel_partner_min_val").val());
      return value > minVal;
    } else {
      return true;
    }
  }, 'value should maximum value than minimum value');

  //channel partner
  $.validator.addMethod('distributorMinStrict', function(value, el, param) {
    if ($("#dist_max_val").val() != "" && value != "") {
      var maxVal = parseInt($("#dist_max_val").val());
      return value < maxVal;
    } else {
      return true;
    }
  }, 'value should minimum value than maximum value');
  $.validator.addMethod('distributorMaxStrict', function(value, el, param) {
    if ($("#dist_min_val").val() != "" && value != "") {
      var minVal = parseInt($("#dist_min_val").val());
      return value > minVal;
    } else {
      return true;
    }
  }, 'value should maximum value than minimum value');

  $(function() {
    //jquery Form validation
    $('#finalOrderForm').validate({
      rules: {
        "general|finalOrderDiscount|dealer|min": {
          required: function(element) {
            return $("#dealer_min_disc").val() != "" || $("#dealer_max_val").val() != "" || $("#dealer_max_disc").val() != "";
          },
          dealerMinStrict: true
        },
        "general|finalOrderDiscount|dealer|minDiscount": {
          required: function(element) {
            return $("#dealer_min_val").val() != "" || $("#dealer_max_val").val() != "" || $("#dealer_max_disc").val() != "";
          }
        },
        "general|finalOrderDiscount|dealer|max": {
          required: function(element) {
            return $("#dealer_min_val").val() != "" || $("#dealer_min_disc").val() != "" || $("#dealer_max_disc").val() != "";
          },
          dealerMaxStrict: true
        },
        "general|finalOrderDiscount|dealer|maxDiscount": {
          required: function(element) {
            return $("#dealer_min_val").val() != "" || $("#dealer_min_disc").val() != "" || $("#dealer_max_val").val() != "";
          }
        },
        "general|finalOrderDiscount|exclusiveDealer|min": {
          required: function(element) {
            return $("#ex_dealer_min_disc").val() != "" || $("#ex_dealer_max_val").val() != "" || $("#ex_dealer_max_disc").val() != "";
          },
          exDealerMinStrict: true
        },
        "general|finalOrderDiscount|exclusiveDealer|minDiscount": {
          required: function(element) {
            return $("#ex_dealer_min_val").val() != "" || $("#ex_dealer_max_val").val() != "" || $("#ex_dealer_max_disc").val() != "";
          }
        },
        "general|finalOrderDiscount|exclusiveDealer|max": {
          required: function(element) {
            return $("#ex_dealer_min_val").val() != "" || $("#ex_dealer_min_disc").val() != "" || $("#ex_dealer_max_disc").val() != "";
          },
          exDealerMaxStrict: true
        },
        "general|finalOrderDiscount|exclusiveDealer|minDiscount": {
          required: function(element) {
            return $("#ex_dealer_min_val").val() != "" || $("#ex_dealer_min_disc").val() != "" || $("#ex_dealer_max_val").val() != "";
          }
        },
        "general|finalOrderDiscount|channelPartner|min": {
          required: function(element) {
            return $("#channel_partner_min_disc").val() != "" || $("#channel_partner_max_val").val() != "" || $("#channel_partner_max_disc").val() != "";
          },
          channelPartnerMinStrict: true
        },
        "general|finalOrderDiscount|channelPartner|minDiscount": {
          required: function(element) {
            return $("#channel_partner_min_val").val() != "" || $("#channel_partner_max_val").val() != "" || $("#channel_partner_max_disc").val() != "";
          }
        },
        "general|finalOrderDiscount|channelPartner|max": {
          required: function(element) {
            return $("#channel_partner_min_val").val() != "" || $("#channel_partner_min_disc").val() != "" || $("#channel_partner_max_disc").val() != "";
          },
          channelPartnerMaxStrict: true
        },
        "general|finalOrderDiscount|channelPartner|maxDiscount": {
          required: function(element) {
            return $("#channel_partner_min_val").val() != "" || $("#channel_partner_min_disc").val() != "" || $("#channel_partner_max_val").val() != "";
          }
        },
        "general|finalOrderDiscount|distributor|min": {
          required: function(element) {
            return $("#dist_min_disc").val() != "" || $("#dist_max_val").val() != "" || $("#dist_max_disc").val() != "";
          },
          distributorMinStrict: true
        },
        "general|finalOrderDiscount|distributor|minDiscount": {
          required: function(element) {
            return $("#dist_min_val").val() != "" || $("#dist_max_val").val() != "" || $("#dist_max_disc").val() != "";
          }
        },
        "general|finalOrderDiscount|distributor|max": {
          required: function(element) {
            return $("#dist_min_val").val() != "" || $("#dist_min_disc").val() != "" || $("#dist_max_disc").val() != "";
          },
          distributorMaxStrict: true
        },
        "general|finalOrderDiscount|distributor|maxDiscount": {
          required: function(element) {
            return $("#dist_min_val").val() != "" || $("#dist_min_disc").val() != "" || $("#dist_max_val").val() != "";
          }
        },
      },


      messages: {

        "general|finalOrderDiscount|dealer|min": {
          required: "Please enter minimum value"
        },
        "general|finalOrderDiscount|dealer|minDiscount": {
          required: "Please enter minimum discount value"
        },
        'general|finalOrderDiscount|dealer|max': {
          required: "Please enter maximum value"
        },
        'general|finalOrderDiscount|dealer|maxDiscount': {
          required: "Please enter maximum discount value"
        },
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-item').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
  });
</script>

<script type="text/javascript">
  $(function() {

    // $(".collapse").trigger("click");

    $(".mobileUpdate").change(function() {
      var changeVal = $(this).attr('data-change');

      if ($(this).is(":checked") && $(this).val() === "forcefully") {
        $("#" + changeVal).show();
      } else {
        $("#" + changeVal).hide();
      }

    });
    $(".mobileUpdate").trigger('change');
  });

  $(function() {
    $(".maintenanceMode").change(function() {
      var maintenanceMode = $("input:radio.maintenanceMode:checked").val();

      if (maintenanceMode == "on") {

        $("#maintenance_mode").show();
      } else {

        $("#maintenance_mode").hide();
      }

    });
    $(".maintenanceMode").trigger('change');


  });
</script>
<script>
  // INCLUDE JQUERY & JQUERY UI 1.12.1
  $(function() {
    $('*[value=""]').removeClass('is-valid');

    $("#datepicker").datepicker({
      dateFormat: "dd-mm-yy",
      duration: "fast"
    });

    //set manual addres details fill
    $("#searchAddressChecked").click(function() {
      if ($(this).is(":checked")) {

        $(".removeReadOnly").removeAttr("readonly", false);
        $("#setting-search-add").attr('readonly', true);

      } else {
        $(".removeReadOnly").attr("readonly", true);
        $("#setting-search-add").attr('readonly', false);
      }
    });
  });

  const inputs = document.querySelectorAll("input");

  inputs.forEach((input) => {
    input.addEventListener("blur", (event) => {
      if (event.target.value) {
        input.classList.add("is-valid");
      } else {
        input.classList.remove("is-valid");
      }
    });
  });

  const textareas = document.querySelectorAll("textarea");

  textareas.forEach((textarea) => {
    textarea.addEventListener("blur", (event) => {
      if (event.target.value) {
        textarea.classList.add("is-valid");
      } else {
        textarea.classList.remove("is-valid");
      }
    });
  });
</script>
<script>
  $(function() {
    // check value is empty remove valid class
    $('*[value=""]').removeClass('is-valid');
    //jquery Form validation
    $('#basicForm').validate({
      rules: {
        'general|basic|colorLogo': {

          extension: "jpg|jpeg|png",
          maxsize: 1000000

        },
        'general|basic|whiteLogo': {

          extension: "jpg|jpeg|png",
          maxsize: 1000000


        },
        'general|basic|favicon': {

          extension: "png|jpeg|jpg",
          maxsize: 1000000


        },
        'general|basic|siteName': {
          required: true
        },
        'general|basic|siteUrl': {
          required: true

        },
        'general|basic|sitePhoneNo': {
          required: true,

        },
        'general|basic|siteEmail': {
          required: true,
          email: true
        }
      },


      messages: {
        'general|basic|siteName': {
          required: "Please enter a Company Name"
        },
        'general|basic|siteUrl': {
          required: "Please enter a Company Website URL",
          url: true,
        },
        'general|basic|colorLogo': {
          required: "Please Upload Color Logo Image",
          extension: "Please select image format must be .jpg, .jpeg or .png",
          maxsize: "Please upload image size less than 1MB"

        },
        'general|basic|whiteLogo': {
          required: "Please Upload White Logo Image",
          extension: "Please select image format must be .jpg, .jpeg or .png",
          maxsize: "Please upload image size less than 1MB"

        },
        'general|basic|favicon': {
          required: "Please Upload Favicon Image",
          extension: "Please select image format must be .jpg, .jpeg or .png",
          maxsize: "Please upload image size less than 1MB"

        },
        'general|basic|sitePhoneNo': {
          required: "Please enter a Company Phone Number "
        },
        'general|basic|siteEmail': {
          required: "Please enter a Company Email Address"
        }


      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-item').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });

    //maintenance message validtion
    //additional information validation
    $('#maintenanceModeForm').validate({
      rules: {
        'general|maintenanceMode|message': {
          required: true
        },
      },
      messages: {
        'general|maintenanceMode|message': {
          required: "Please enter a Maintenance Message"
        },
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-item').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
    //additional information validation
    $('#additionalInfoForm').validate({
      rules: {
        'general|site|googleApiKey': {
          required: true
        },
        'general|site|inquiryEmail': {
          required: true,
          email: true
        },
        'general|site|footerText': {
          required: true
        },
        'general|setting|pagePerAdminRecords': {
          required: true,
          min: 1,
          max: 100
        },
        'general|setting|pagePerAPIRecords': {
          required: true,
          min: 1,
          max: 100
        },
        'general|site|defaultLanguageCode': {
          required: true,
        },
        'general|site|defaultVatPercentage': {
          required: true,
          number: true,
          range: [0, 100]
        },
      },
      messages: {
        'general|site|googleApiKey': {
          required: "Please enter a Google Map API Key"
        },
        'general|site|inquiryEmail': {
          required: "Please enter an Inquiry Email"
        },
        'general|site|footerText': {
          required: "Please enter a Footer Text",
        },
        'general|setting|pagePerAdminRecords': {
          required: "Please enter a Per Page Record for Admin",
        },
        'general|setting|pagePerAPIRecords': {
          required: "Please enter a Per Page Record for API",
        },
        'general|site|defaultLanguageCode': {
          required: "Please select a Default Language",
        },
        'general|site|defaultVatPercentage': {
          required: "Please enter a Default VAT Percentage",
        }
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-item').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });

    //bank details validation
    $('#bankDetailsForm').validate({
      rules: {
        'general|bankDetail|beneficiaryName': {

          required: true
        },
        'general|bankDetail|beneficiaryAccountNo': {
          required: true,
        },
        'general|bankDetail|bankName': {

          required: true

        },
        'general|bankDetail|branchName': {
          required: true,
        },
        'general|bankDetail|ifscCode': {
          required: true,
        }


      },


      messages: {
        'general|bankDetail|beneficiaryName': {
          required: "Please enter a Beneficiary's Name"
        },
        'general|bankDetail|beneficiaryAccountNo': {
          required: "Please enter a Benificiary's Account Number"

        },
        'general|bankDetail|bankName': {
          required: "Please enter a Bank Name",

        },
        'general|bankDetail|branchName': {
          required: "Please enter a Branch Name",
        },
        'general|bankDetail|ifscCode': {
          required: "Please enter an IFSC Code ",
        }
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-item').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });
    //address information
    $('#addressInfoForm').validate({
      rules: {
        "general|basic|storeAddress": {
          required: true,
          maxlength: 255
        },
        "general|basic|storeCountry": {
          required: true,
          maxlength: 100
        },
        "general|basic|storeState": {
          required: true,
          maxlength: 100
        },
        "general|basic|storeCity": {
          required: true,
          maxlength: 100
        },
        "general|basic|storePincode": {
          required: true,
          digits: true
        },
      },
      messages: {
        "general|basic|storePincode": {
          required: true,
          digits: "Please enter only digits"
        },
      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-item').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });

    // android auto update
    $('#androidVersion').validate({
      rules: {
        "general|android|version": {
          required: true
        }

      },
      messages: {
        "general|android|version": {
          required: "Please enter an Android Version"
        }

      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-item').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });

    $('#iosVersion').validate({
      rules: {
        "general|ios|version": {
          required: true
        }

      },
      messages: {
        "general|ios|version": {
          required: "Please enter an IOS Version"
        }

      },
      errorElement: 'span',
      errorPlacement: function(error, element) {
        error.addClass('invalid-feedback');
        element.closest('.form-item').append(error);
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass('is-invalid');
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).removeClass('is-invalid');
      }
    });


  });
</script>

<script>
  document.getElementById('flexCheckDefault1').onclick = function() {
    var checkboxes = document.getElementsByName('check');
    for (var checkbox of checkboxes) {
      checkbox.checked = this.checked;
    }
  }
</script>
@append
