@extends('admin.layout.main')
@section('title',$header['title'])
@section('content')

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
                <h1 class="m-0">{{ $header['title'] }}</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="{{ route('mail-campaign.index') }}">Mail Campaigns</a></li>
                    <li class="breadcrumb-item active">Edit</li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>

<style>
    input[readonly] {
        color: #6c757d;

        background-color: #e9ecef;

        cursor: not-allowed;

        border: 1px solid #ced4da;

    }



    .modal-dialog {
        max-width: 90%;

        max-height: 80vh;

        margin: 30px auto;

    }

    .modal-body {
        padding: 15px;

    }

    .modal-text-content {
        max-height: 60vh;

        overflow-y: auto;

    }

    .content-section {
        margin-bottom: 15px;

    }

    .modal-title {
        font-size: 1.25rem;

    }


    .modal-body h5 {
        font-size: 1rem;
        color: #333;
    }

    .modal-body p {
        font-size: 0.875rem;
        line-height: 1.5;
        color: #555;
    }


    /* Ensure the search box has proper width */
.select2-container--default .select2-search--inline .select2-search__field,
.select2-container--default .select2-search__field {
    width: 100% !important;
    min-width: 200px;
    color: black !important; /* Make search text black */
}

/* Optional: Improve visibility by setting background */
.select2-container--default .select2-search--inline .select2-search__field {
    background-color: white !important;
}

/* Change the selected text color in the dropdown */
.select2-container--default .select2-selection--multiple .select2-selection__choice,
.select2-container--default .select2-selection--single .select2-selection__rendered {
    color: black !important; 
}

</style>
<!-- /.content-header -->
<section class="content">
    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            <div class="card pb-4 pt-3 px-3 w-100">
                <form id="dataForm" action="{{ route('admin.mail-campaign.sendemail', $mailCampaignDetail['id']) }}"
                class="form row pt-3 mb-0 validate" enctype="multipart/form-data" method="post">
                    @csrf
                    @method('post')
                    <div class="form-group col-md-12">
                        @if($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                        @endif
                    </div>
                    <input type="hidden" name="redirects_to" id="redirects_to" value="{{ URL::previous() }}">
                    <input type="hidden" value="{{ $mailCampaignDetail['id'] }}" name="mail_template_id">

                  



                    <div class="col-md-12 row">
                        <div class="col-md-6">
                            <div class="form-item form-float-style">
                                <input name="code" type="text" id="mail_code_english" autocomplete="off" required value="{{ $mailCampaignDetail['code'] }}" class="is-valid" placeholder="Ex: MAIL_CAMPAIGN" readonly>
                                <label for="home-banner">Mail Code English<span class="req-star">*</span></label>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-item form-float-style">
                                <input name="mail[1][name]" type="text" id="from_email" autocomplete="off" required value="{{ $mailCampaignDetail['mailCodeName'][0]['name'] }}" class="is-valid" placeholder="Ex: حملة بريدية" dir="rtl" readonly>
                                <label for="home-banner">Mail Code Arabic<span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row">
                        <div class="col-md-6">
                            <div class="form-item form-float-style">
                                <input name="mail[0][name]" type="hidden" id="mail_code_hidden" autocomplete="off" required value="{{ $mailCampaignDetail['code']  }}" class="is-valid">
                            </div>
                        </div>
                    </div>




                    <div class="col-md-12 row">
                        <div class="col-md-6">
                            <div class="form-item form-float-style">
                                <input name="mail[0][subject]" type="text" id="subject1" autocomplete="off" required value="{{ $mailCampaignDetail['mailCodeName'][1]['subject'] }}" class="is-valid" readonly>
                                <input name="mail[0][language_code]" type="hidden" id="language_code" autocomplete="off" required value="en" class="is-valid" readonly>
                                <label for="home-banner">Subject English<span class="req-star">*</span></label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-item form-float-style">
                                <input name="mail[1][subject]" type="text" id="subject2" dir="rtl" autocomplete="off" required value="{{ $mailCampaignDetail['mailCodeName'][0]['subject'] }}" class="is-valid" readonly>
                                <input name="mail[1][language_code]" type="hidden" id="language_code2" autocomplete="off" required value="ar" class="is-valid" readonly>
                                <label for="home-banner">Subject Arabic<span class="req-star">*</span></label>
                            </div>
                        </div>


                    </div>

                   

                    <div class="row">
                    
                        <div class="col-md-6">
                            <div class="form-item form-float-style form-group">
                                <label for="customer_list">Select Customer</label>
                                <select data-live-search="true" id="customer_list" name="customer_email[]" class="order-td-input width-set-serc select-text is-valid select2 customer_list" data-placeholder="Select Customer" multiple style="width: 100%;" style="color: black;">
                                    <option value="All">All</option>
                                    @foreach($userEmail as $email)
                                    <option value="{{ $email }}">{{ $email }}</option>
                                    @endforeach
                                </select>
                                @error('customer_email')
                                <span id="content-error" class="error invalid-feedback ">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <label for="customer_list">Import Customer From Excel</label>
                                <input type="file" name="customer_email_excel" id="customer_email_excel" class="is-valid" placeholder="Enter Customer Email">
                                @error('customer_email_excel')
                                <span id="content-error" class="error invalid-feedback ">{{ $message }}</span>
                                @enderror
                            </div>
                            <div class="mt-2">
                                <a href="{{ asset('sample_file/campaign_emails_sample.xlsx') }}" class="btn btn-info" download>
                                    <i class="fas fa-download"></i> Download Sample Excel
                                </a>
                            </div>
                        </div>


                        <div class="col-md-3">
                            <!-- View Content Button -->
                            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#viewContentModal">
                                View Content
                            </button>
                        </div>

                    </div>


                    <!-- Modal for Viewing Content -->
                    <div class="modal fade" id="viewContentModal" tabindex="-1" aria-labelledby="viewContentModalLabel" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="viewContentModalLabel">View Content</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <!-- Scrollable content -->
                                    <div class="modal-text-content">
                                        <div class="content-section">
                                            <h5>Description English</h5>
                                            <div style="color: black !important;">{!!  $mailCampaignDetail['mailCodeName'][0]['content'] !!}</div>
                                        </div>
                                        <div class="content-section" style="color: black;">
                                            <h5>Description Arabic</h5>
                                            <div style="color: black !important;">{!! $mailCampaignDetail['mailCodeName'][1]['content'] !!}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>



                    <div class="cards-btn mt-3">
                        <button type="submit" id="disBtn" class="btn btn-success form-btn-success">Send Email</button>
                        <a href="{{ route('mail-campaign.index') }}" type="button" class="btn btn-danger form-btn-danger">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- /.row -->
    </div>
    <!--/. container-fluid -->
</section>

@endsection
@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

<script>
    jQuery.validator.setDefaults({
        ignore: [],
        // with this no hidden fields will be ignored E.g. ckEditor text-area
    });

    jQuery.validator.addMethod("noSpace1", function(value, element) {
        return value == '' || value.trim().length != 0;
    }, "Only Space are not allowed");


    $.validator.addMethod("email_regex", function(value, element, regexpr) {
        return this.optional(element) || regexpr.test(value);
    }, "Please enter a valid From");
</script>
<script>
    $(function() {
        //jquery Form validation
        $('*[value=""]').removeClass('is-valid');

        $('#dataForm').validate({
            ignore: [],
            rules: {
                ignore: [],
                from_email: {
                    required: true,
                    email_regex: /\b[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b/i,
                    noSpace: true
                },
                cc: {
                    required: true,
                },
                bcc: {
                    required: true,
                },
                'mail[0][subject]': {
                    required: true,
                    noSpace: true,
                },
                'mail[1][subject]': {
                    required: true,
                    noSpace: true,
                },
                'mail[0][content]': {
                    required: true,
                    noSpace: true,
                },
                'mail[1][content]': {
                    required: true,
                    noSpace: true,
                },

            },

            messages: {
                from_email: {
                    required: "Please enter a From"
                },
                cc: {
                    required: "Please select a CC"
                },
                bcc: {
                    required: "Please select a BCC"
                },
                'mail[0][subject]': {
                    required: "Please enter a Subject English"
                },
                'mail[1][subject]': {
                    required: "Please enter a Subject Arabic"
                },
                'mail[0][content]': {
                    required: "Please enter a Description English",
                },
                'mail[1][content]': {
                    required: "Please enter a Description Arabic",
                },

            },
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-item').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
            submitHandler: function(form) {
                $("#disBtn").attr("disabled", true);
                form.submit();
            }
        });
    });
</script>

<script>
    // Listen for input changes in the 'from_email' field
    document.getElementById('mail_code_english').addEventListener('keyup', function() {
        // Update the value of the second input field
        document.getElementById('mail_code_hidden').value = this.value;
    });

    $(document).ready(function() {
        $('#customer_list').select2({
            placeholder: "Select Customer",
            allowClear: true,
            width: '100%' // Ensures the search box and dropdown take full width
        });
    });
</script>

@append