@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<style>
.image_div{
    display: flex;
    justify-content: center;
}
</style>
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-4 mt-2">
            <div class="col-sm-12 align-items-center d-flex breadcrumb-style">
              <h1 class="m-0">{{ $header['heading'] }}</h1>
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">@lang('adminUser.dashboard') </a></li>
                <li class="breadcrumb-item"><a href="{{ route('tour-code.index') }}">Tour Codes</a></li>

                <li class="breadcrumb-item active">@lang('adminUser.view')</li>
              </ol>
              <div class="breadcrumb-btn">

                <div class="add-breadcrumb">
                  <a class="" href="{{ route('tour-code.edit',$tourCodeDetails['id']) }}">
                    <?xml version="1.0"?>
                    <svg fill="#fff" viewBox="0 0 24 24" width="20" height="20">
                    <path
                        d="M 19.171875 2 C 18.448125 2 17.724375 2.275625 17.171875 2.828125 L 16 4 L 20 8 L 21.171875 6.828125 C 22.275875 5.724125 22.275875 3.933125 21.171875 2.828125 C 20.619375 2.275625 19.895625 2 19.171875 2 z M 14.5 5.5 L 3 17 L 3 21 L 7 21 L 18.5 9.5 L 14.5 5.5 z" />
                    </svg>
                  Edit
                  </a>
                </div>
              </div>
            </div><!-- /.col -->

          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">
        <div class="container-fluid">
          <!-- Info boxes -->
          <div class="row">
            <div class="card pb-4 pt-4 px-3 w-100">
              <div class="row view_page mb-0">

                <div class="col-md-12 mt-3">


                  <div class="view_user_data">
                    <table class="">
                    <tr>
                        <th>Tour Code :</th>
                        <td> {{ $tourCodeDetails['tour_code'] }}</td>
                    </tr>
                    <tr>
                        <th>From Airports :</th>
                        <td>{!! $tourCodeDetails['from_airports'] !!} </td>
                    </tr>
                    <tr>
                        <th>To Airports :</th>
                        <td>{!! $tourCodeDetails['to_airports'] !!} </td>
                    </tr>
                    <tr>
                        <th>From Date :</th>
                       <td>{{ $tourCodeDetails['from_date'] }} </td>
                    </tr>
                    <tr>
                        <th>To :</th>
                       <td>{{ $tourCodeDetails['to_date'] }} </td>
                    </tr>
                    <tr>
                        <th>Status :</th>
                        <td>{{ ($tourCodeDetails['status'] ? 'Active' : 'Inactive') }} </td>
                    </tr>
                    </tbody>
                    </table>
                  </div>
                </div>

              </div>
            </div>
            <!-- /.row -->
          </div>
          <!--/. container-fluid -->
      </section>

      @endsection
