<?php

use App\Exports\BookingsExport;
use App\Models\CustomerLoginToken;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Request;
use App\Http\Controllers\Admin\ApiController;
use Stichoza\GoogleTranslate\GoogleTranslate;
use App\Http\Controllers\Admin\PagesController;
use App\Http\Controllers\API\V1\PageController;
use App\Http\Controllers\Admin\AgencyController;
use App\Http\Controllers\Admin\WalletController;
use App\Http\Controllers\Admin\BookingController;
use App\Http\Controllers\Admin\NegFareController;
use App\Http\Controllers\Admin\CustomerController;
use App\Http\Controllers\Admin\SeoLinksController;
use App\Http\Controllers\Admin\TourCodeController;
use App\Http\Controllers\Admin\BestOfferController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\TravellerController;
use App\Http\Controllers\Admin\Auth\LoginController;
use App\Http\Controllers\Admin\BookingLogController;
use App\Http\Controllers\Admin\HomeBannerController;
use App\Http\Controllers\Admin\Setting\SmsController;
use App\Http\Controllers\Admin\SummerOfferController;
use App\Http\Controllers\Admin\Auth\ProfileController;
use App\Http\Controllers\Admin\FeatureHotelController;
use App\Http\Controllers\Admin\Setting\SmtpController;
use App\Http\Controllers\Admin\FeatureFlightController;
use App\Http\Controllers\Admin\GeneralSettingController;
use App\Http\Controllers\Admin\Geography\CityController;
use App\Http\Controllers\Admin\TrendingHotelsController;
use App\Http\Controllers\Admin\Geography\StateController;
use App\Http\Controllers\Admin\Setting\GeneralController;
use App\Http\Controllers\Admin\TrendingFlightsController;
use App\Http\Controllers\Admin\Setting\CurrencyController;
use App\Http\Controllers\Admin\Setting\LanguageController;
use App\Http\Controllers\Admin\Geography\AirlineController;
use App\Http\Controllers\Admin\Geography\CountryController;
use App\Http\Controllers\Admin\HotelFacilitiesArController;
use App\Http\Controllers\Admin\Reports\LogReportController;
use App\Http\Controllers\Admin\SeoTrendingHotelsController;
use App\Http\Controllers\Admin\Setting\AdminUserController;
use App\Http\Controllers\Admin\Action\BlockFlightController;
use App\Http\Controllers\Admin\Geography\AirportsController;
use App\Http\Controllers\Admin\Reports\UserReportController;
use App\Http\Controllers\Admin\SeoTrendingFlightsController;
use App\Http\Controllers\Admin\Setting\AmadeusApiController;
use App\Http\Controllers\Admin\HotelRecommendationController;
use App\Http\Controllers\Admin\HotelSpecialRequestController;
use App\Http\Controllers\Admin\SeoLinks\MultimediaController;
use App\Http\Controllers\Admin\SeoLinks\RehlteLinkController;
use App\Http\Controllers\Admin\Markups\SalesMarkupsController;
use App\Http\Controllers\Admin\OperationalData\BankController;
use App\Http\Controllers\Admin\Reports\AgencyReportController;
use App\Http\Controllers\Admin\Setting\HotelBedsApiController;
use App\Http\Controllers\Admin\Setting\LoginAttemptController;
use App\Http\Controllers\Admin\Setting\SinginMethodController;
use App\Http\Controllers\Admin\Auth\AdminLoginAsUserController;
use App\Http\Controllers\Admin\Markups\FlightMarkupsController;
use App\Http\Controllers\Admin\Markups\MarkupSettingController;
use App\Http\Controllers\Admin\SeoLinks\PopularGuideController;
use App\Http\Controllers\Admin\Templates\SmsTemplateController;
use App\Http\Controllers\Admin\OperationalData\CouponController;
use App\Http\Controllers\Admin\Reports\CustomerReportController;
use App\Http\Controllers\Admin\SeoLinks\FeaturedGuideController;
use App\Http\Controllers\Admin\SeoLinks\PopularTravelController;
use App\Http\Controllers\Admin\Setting\RolePermissionController;
use App\Http\Controllers\Admin\Templates\MailCampaignController;
use App\Http\Controllers\Admin\Templates\MailTemplateController;
use App\Http\Controllers\Admin\SeoLinks\PopularAirlineController;
use App\Http\Controllers\Admin\Geography\TopDestinationController;
use App\Http\Controllers\Admin\Setting\PasswordSecurityController;
use App\Http\Controllers\Admin\Auth\AdminLoginAsCustomerController;
use App\Http\Controllers\Admin\Markups\HotelSalesMarkupsController;
use App\Http\Controllers\Admin\OperationalData\SuppliersController;
use App\Http\Controllers\Admin\Markups\FlightSalesMarkupsController;
use App\Http\Controllers\Admin\OperationalData\AgencyTypeController;
use App\Http\Controllers\Admin\SeoLinks\PopularAttractionController;
use App\Http\Controllers\Admin\OperationalData\ServiceTypeController;
use App\Http\Controllers\Admin\OperationalData\PaymentmethodController;
use App\Http\Controllers\Admin\Reports\MonthlyCustomerReportController;
use App\Http\Controllers\Admin\OperationalData\PaymentGatewayController;

Route::domain('officeuat.' . env('APP_URL'))->group(function () {

    Route::get('/login', function () {
        return view('admin/auth/login');
    })->name('login');

    Route::get('/login', function () {
        return view('admin/auth/login');
    })->name('admin.login');
    Route::get('/', function () {
        return view('admin/auth/login');
    })->name('admin.login');


    // Login Controller routes
    Route::controller(LoginController::class)->group(function () {
        Route::post('/verifyLogin', 'sendOtp')->name('verifyLogin');
        Route::get('/verify-otp', function () {
            $username = session('otp_username');
            $password = session('otp_password');
            $otp_sent = session('otp_sent');
            $otp_start_time = session('otp_start_time');

            if (!$username || !$password) {
                return redirect()->route('admin.login')->with('error', 'Session expired. Please login again.');
            }
            $otpSent = true;
            return view('admin.auth.verify-otp', compact('username', 'password', 'otp_sent', 'otp_start_time'));
        })->name('verifyOtpPage');

        Route::post('/send-otp', 'reSendOtp')->name('send.otp');
        Route::post('login', 'adminLogin')->name('adminLogin');
        Route::get('otp', 'getOtp')->name('admin.otp');
        Route::get('forgot-password', 'getForgotPassword')->name('admin.forgot-password');
        Route::post('forgot-password', 'forgotPassword')->name('admin.forgot-password.save');
        Route::post('otp-verify', 'tpVerify')->name('admin.otp-verification');
        Route::get('/reset-password/{mobile}', 'getResetPassword')->name('admin.reset-password.create');
        Route::post('reset-password', 'reset_password')->name('admin.reset-password.save');
        Route::post('reset-password/check', 'resetPasswordvalidate')->name('admin.reset-password.validate');
        Route::post('api-send-otp', 'api_reset_password')->name('admin.api-send-otp.save');
        Route::get('logout', 'logout')->name('admin.logout');
    });

    // Customer Controller Routes
    Route::resource('/customers', CustomerController::class);
    Route::controller(CustomerController::class)->group(function () {
        Route::get('/customer-reset-password/{token}', 'getCustomerResetPassword')->name('admin.customer-reset-password.create');
        Route::post('customer-reset-password', 'action_customer_reset_password')->name('admin.customer-reset-password.save');
        Route::get('/customer-updated-password', 'getCustomerUpdatedResetPassword')->name('admin.customer-updated-password');
        Route::get('/customer-active-account/{id}', 'customerActiveAccount')->name('admin.customer-active-account');

        Route::post('/customers/checkMobile', 'checkUserExist')->name('admin.customers.checkUser');
        Route::post('/customers/checkEmailUserExist', 'checkEmailUserExist')->name('admin.customers.checkEmailUserExist');
        Route::post('/customers/checkCustomerMobileExist', 'checkCustomerMobileExist')->name('admin.customers.checkCustomerMobileExist');
        Route::get('/deleteCustomers', 'deleteCustomers')->name('admin.customers.delete');
        Route::get('export/customers', 'export')->name('export.user');
        Route::post('cropped-image', 'cropImg')->name('cropped-image');
        Route::get('/get-booking-history/{id}', 'getBookingHistory')->name('get-booking-history');
    });

    Route::get('/api-send-otp/{token}', function ($token) {
        return view('Admin/Auth/api-send-otp', ['token' => $token]);
    })->name('reset-password');


    /*     * ****************** authenticated routes ********************** */
    Route::group(['middleware' => ['auth']], function () {

        // Best Offers routes
        Route::resource('best-offers', BestOfferController::class);
        Route::get('/deleteBestOffer/{id}', [BestOfferController::class, 'deleteBestOffer'])->name('admin.best-offers.delete');

        // Summer Offers routes
        Route::resource('/summer-offers', SummerOfferController::class);
        Route::get('/deleteSummerOffer/{id}', [SummerOfferController::class, 'deleteSummerOffer'])->name('admin.summer-offers.delete');

        Route::resource('feature-flight', FeatureFlightController::class);
        Route::controller(FeatureFlightController::class)->group(function () {
            Route::get('/deleteFeatureFlight', 'deleteFeatureFlight')->name('feature-flight.delete');
            Route::get('/featured-flight/fetchAirlineCode', 'fetchAirlineCode')->name('feature-flight.fetchAirlineCode');
            Route::get('/get-airport-name', 'getAirportName');
        });

        //Featured Hotels routes
        Route::resource('/feature-hotel', FeatureHotelController::class);
        Route::get('/deleteFeatureHotel/{id}', [FeatureHotelController::class, 'deleteFeatureHotel'])->name('admin.feature-hotel.delete');

        Route::resource('/neg-fare', NegFareController::class);
        Route::get('/deleteNegFare/{id}',  [NegFareController::class, 'deleteNegFare'])->name('admin.neg-fare.delete');

        Route::resource('/tour-code', TourCodeController::class);
        Route::get('/deleteTourCode/{id}', [TourCodeController::class, 'deleteTourCode'])->name('admin.tour-code.delete');

        Route::resource('/trending-flight', TrendingFlightsController::class);
        Route::get('/deleteTrendingFlight/{id}', [TrendingFlightsController::class, 'deleteTrendingFlight'])->name('admin.trending-flight.delete');

        Route::resource('/trending-hotel', TrendingHotelsController::class);
        Route::get('/deleteTrendingHotel/{id}', [TrendingHotelsController::class, 'deleteTrendingHotel'])->name('admin.trending-hotel.delete');

        Route::resource('/seo-trending-flight', SeoTrendingFlightsController::class);
        Route::get('/deleteSeoTrendingFlight/{id}',  [SeoTrendingFlightsController::class . 'deleteSeoTrendingFlight'])->name('admin.seo-trending-flight.delete');

        Route::resource('/seo-trending-hotel', SeoTrendingHotelsController::class);
        Route::get('/deleteSeoTrendingHotel/{id}', [SeoTrendingHotelsController::class, 'deleteSeoTrendingHotel'])->name('admin.seo-trending-hotel.delete');


        // SEO Links

        Route::resource('/featured-guides', FeaturedGuideController::class);
        Route::get('/deletefeaturedGuide/{id}', [FeaturedGuideController::class, 'deleteFeaturedGuide'])->name('admin.featured-guide.delete');

        Route::resource('/popular-attraction', PopularAttractionController::class);
        Route::get('/deletepopularAttraction/{id}', [PopularAttractionController::class . 'deletePopularAttraction'])->name('admin.popular-attraction.delete');


        Route::resource('/popular-airline', PopularAirlineController::class);
        Route::get('/deletepopularAirline/{id}', [PopularAirlineController::class, 'deletePopularAirline'])->name('admin.popular-airline.delete');

        Route::resource('/popular-guide', PopularGuideController::class);
        Route::get('/deletepopularGuide/{id}', [PopularGuideController::class, 'deletePopularGuide'])->name('admin.popular-guide.delete');

        Route::resource('/rehlte-links', RehlteLinkController::class);
        Route::get('/deleterehlteLink/{id}', [RehlteLinkController::class, 'deleteRehlteLinks'])->name('admin.rehlte-links.delete');

        Route::resource('/popular-travel', PopularTravelController::class);
        Route::get('/deletepopularTravel/{id}', 'SeoLinks\PopularTravelController@deletePopularTravel')->name('admin.popular-travel.delete');

        Route::resource('/multimedia', MultimediaController::class);
        Route::get('/deleteMultimedia/{id}', [MultimediaController::class, 'deleteMultimedia'])->name('admin.multimedia.delete');

        // End of SEO Links

        Route::resource('/block-flight', BlockFlightController::class);
        Route::get('/deleteBlockedFlight/{id}', [BlockFlightController::class, 'deleteBlockedFlight'])->name('admin.block-flight.delete');

        Route::controller(ProfileController::class)->group(function () {
            Route::post('add-login-history',  'addLoginHistory')->name('admin.fcm_token_update');
            Route::get('change-password/', 'changePasswordUserEdit')->name('admin.change-password');
            Route::post('check-current-password/check', 'currentPasswordvalidate')->name('admin.current-password.validate');
            Route::post('change-password/check', 'changePasswordvalidate')->name('admin.change-password.validate');
            Route::post('change-password/{id}', 'changePasswordUserUpdate')->name('admin.change-password.update');
            Route::get('profile/edit', 'edit')->name('admin.profile.edit');
            Route::put('profile/update/{id}', 'update')->name('admin.profile.update');
        });

        //dashboard routes
        Route::controller(DashboardController::class)->group(function () {
            Route::get('/dashboard', 'index')->name('admin.dashboard');
            Route::get('/getRecord', 'getRecord')->name('getRecords');
            Route::get('/get-duration', 'getDuration')->name('admin.get_duration');
            Route::get('/get-active-customers', 'getActiveCustomers')->name('active.customers');
            Route::get('/get-failed-bookings', 'getFailedBookings')->name('failed.bookings');
            Route::post('/get-dashboard-filter-data', 'getDashboardFilteredData')->name('dashboard.filter');
        });

        //order-challan's routes
        //SEO links routes

        //Route::resource('/seo-links/trending-flight', 'SeoLinksController@index')->name('reports.customerReport.customer-report');
        Route::controller(SeoLinksController::class)->group(function () {
            Route::get('/seo-links/trending-flight', 'trending_flight')->name('seo-links.trending-flight.trending-flight');
            Route::get('/seo-links/deleteTrendingFlight/{id}', 'deleteTrendingFlight')->name('seo.trending-flight.delete');
        });


        //booking routes
        Route::resource('/booking', BookingController::class)->except('show');
        // Edit Booking
        Route::controller(BookingController::class)->prefix('booking')->group(function () {
            Route::post('update-flight-details/{id}', 'updateFlightDetails')->name('update-flight-details');
            Route::post('update-hotel-details/{id}', 'updateHotelDetails')->name('update-hotel-details');
            Route::get('booking-status-log/{id}', 'bookingStatusLog')->name('booking.view-booking-status-log');
            Route::get('/admin/booking-status-log/{id}', 'fetchBookingStatusLog')->name('admin.booking_status_log');
        });

        //Travellers routes
        Route::resource('/travellers', TravellerController::class);
        Route::controller(TravellerController::class)->group(function () {
            Route::get('/deleteTravellers', 'deleteTravellers')->name('admin.travellers.delete');
            Route::get('/restoreTraveller', 'restoreTraveller')->name('admin.travellers.restore');
        });


        //home banner's routes
        Route::resource('/home-banner', HomeBannerController::class);
        Route::get('/deleteBanner',  [HomeBannerController::class, 'deleteBanner'])->name('admin.home-banner.delete');

        //cms pages routes
        Route::resource('/cms-pages', PagesController::class);
        Route::controller(PagesController::class)->group(function () {
            Route::get('/deletepage', 'deletePage')->name('admin.cms-pages.delete');
            Route::post('/admin-page/checkTitle', 'checkPageTitleExist')->name('admin.cms-pages-title.checkExist');
            Route::post('/admin-page/checkSlugURL', 'checkPageSlugURLExist')->name('admin.cms-pages-SlugURL.checkExist');
            Route::post('/uploadCmsFile', 'uploadCmsFile');
        });

        //reports routes
        Route::controller(AgencyReportController::class)->group(function () {
            //agency report routs
            Route::get('/agencyReport/agency-report', 'index')->name('reports.agencyReport.agency-report');
            Route::get('/agencyReport/master-agency-report-pdf', 'generateMasterAgencyReportPdf')->name('admin.master-agency-report.pdf');
            Route::get('master-agency-report-export', 'generateMasterOrderReportExport')->name('admin.master-agency-report.export');
        });

        //user report routes
        Route::controller(UserReportController::class)->group(function () {
            Route::get('/userReport/user-report', 'index')->name('reports.userReport.user-report');
            Route::get('/userReport/master-user-report-export', 'generateMasterUserReportExport')->name('admin.master-user-report.export');
            Route::get('master-user-report-export', 'generateMasterUserReportPdf')->name('admin.master-user-report.pdf');
        });

        //customer report routes
        Route::controller(CustomerReportController::class)->group(function () {
            Route::get('/customerReport/customer-report', 'index')->name('reports.customerReport.customer-report');
            Route::get('/customerReport/master-customer-report-export', 'generateMasterCustomerReportExport')->name('admin.master-customer-report.export');
            Route::get('/customerReport/master-customer-report-pdf', 'generateMasterCustomerReportPdf')->name('admin.master-customer-report.pdf');
        });

        //monthly customer report routes
        Route::controller(MonthlyCustomerReportController::class)->group(function () {
            Route::get('/monthlyCustomerReport/monthly-customer-report', 'index')->name('reports.monthlyCustomerReport.monthly-customer-report');
            Route::get('/monthlyCustomerReport/master-monthly-customer-report-export', 'generateMasterMonthlyCustomerReportExport')->name('admin.master-monthly-customer-report.export');
            Route::get('/monthlyCustomerReport/master-monthly-customer-report-pdf', 'generateMasterMonthlyCustomerReportPdf')->name('admin.master-monthly-customer-report.pdf');
        });

        //log report routes
        Route::controller(LogReportController::class)->group(function () {
            Route::get('/logReport/log-report', 'index')->name('reports.logReport.log-report');
            Route::get('/logReport/log-report-export', 'generateLogReportExport')->name('admin.log-report.export');
            Route::get('/logReport/log-report-pdf', 'generateLogReportPdf')->name('admin.log-report.pdf');

            //log report routes
            Route::get('/backendLogReport/backend-log-report', 'backendlogReport')->name('reports.backendlogReport.log-report');
            Route::get('/backendLogReport/backend-log-report-export', 'generateBackendLogReportExport')->name('admin.backend-log-report.export');
            Route::get('/backendLogReport/backend-log-report-pdf', 'generateBackendLogReportPdf')->name('admin.backend-log-report.pdf');
        });

        //agencies routes
        Route::resource('/agency', AgencyController::class);
        Route::controller(AgencyController::class)->group(function () {
            Route::get('get-currency', 'getCurrency')->name('admin.get_currency');
            Route::post('/admin-agency/checkEmail', 'checkAgencyEmailExist')->name('admin.agency-email.checkExist');
            Route::post('/admin-agency/checkPhone', 'checkAgencyPhoneExist')->name('admin.agency-phone.checkExist');
            Route::post('/admin-agency/checkFax', 'checkAgencyFaxExist')->name('admin.agency-fax.checkExist');
            Route::post('/admin-agency/checkWebURL', 'checkAgencyWebURLExist')->name('admin.agency-webUrl.checkExist');
            Route::post('/admin-operator/checkEmail', 'checkUserEmailExist')->name('admin.user-email.checkExist');
            Route::post('/admin-operator/checkMobile', 'checkUserMobileExist')->name('admin.user-mobile.checkExist');
            Route::post('/admin-agency/checkIATANumber', 'checkIATANumberExist')->name('admin.agency.checkIATANumber');
            Route::get('/delete-agency', 'deleteAgency')->name('admin.agency.delete');
        });

        //setting's routes
        Route::resource('/user', AdminUserController::class);
        Route::controller(AdminUserController::class)->group(function () {
            //admin user's routes
            Route::post('/user/checkEmailAgencyUserExist', 'checkEmailAgencyUserExist')->name('admin.user.checkEmailAgencyUserExist');
            Route::post('/admin-user/checkMobile', 'checkAdminUserExist')->name('admin.user.checkAdminUser');
            Route::get('/deleteUser', 'deleteUser')->name('admin.user.delete');
            Route::get('/admin/user/sendActivationEmail/{id}', 'sendActivationEmail')->name('admin.user.activationEmail');
        });

        //roles and permission
        Route::resource('/role-permission', RolePermissionController::class);
        Route::controller(RolePermissionController::class)->group(function () {
            Route::get('/deleteRollPermission', 'deleteRollPermission')->name('admin.role-permission.delete');
            Route::post('/role-permission/checkExist', 'checkExist')->name('admin.role-permission.checkExist');
            Route::post('/role-permission/fetchModules', 'fetchModules')->name('admin.role-permission.fetchModules');
        });

        //general routes
        Route::resource('/general', GeneralController::class);
        Route::controller(GeneralController::class)->group(function () {
            Route::post('/general/basic', 'basic')->name('general.basic');
            Route::post('/general/maintenance', 'maintenance')->name('general.maintenance');
            Route::post('/general/additional-information', 'additionalInfo')->name('general.additionalInformation');
            Route::post('/general/bank-details', 'bankDetails')->name('general.bankDetails');
            Route::post('/general/mobile', 'mobile')->name('general.mobile');
            Route::post('/general/final-order-discont', 'orderDiscount')->name('general.orderDiscount');
            Route::post('/general/address-information', 'addressInfo')->name('general.addressInformation');
            Route::post('/general/otp-verification', 'OtpVerification')->name('general.otp-phoneVerification');
        });
        //smtp routes
        Route::resource('/smtp', SmtpController::class);
        //sms routes
        Route::resource('/sms', SmsController::class);
        //Hotel Beds API routes
        Route::resource('/hotelbeds-api', HotelBedsApiController::class)->middleware('block.access');
        //Amadeus API routes
        Route::resource('/amadeus-api', AmadeusApiController::class)->middleware('block.access');

        //Language routes
        Route::resource('/language', LanguageController::class);
        Route::controller(LanguageController::class)->group(function () {
            Route::get('/deleteLanguage', 'deleteLanguage')->name('language.delete');
            Route::post('/language/checkCode', 'checkExistCode')->name('admin.language.checkExistCode');
            Route::post('/language/checkExistKey', 'checkExistKey')->name('admin.language.checkExistKey');
            Route::get('/language/translate/b2c/{id}', 'translate')->name('language.translate.b2c');
            Route::get('/languages/translate/create/{id}', 'createLangTranslator')->name('languages.translate.create');
            Route::post('/languages/translate/store', 'storeLangTranslator')->name('languages.translate.store');
            Route::put('/languages/translate/update', 'updateLangTranslator')->name('languages.updateLangTranslator');
            Route::get('/language/translate/b2b/{id}', 'translateB2B')->name('language.translate.b2b');
            Route::put('/languages/translate/update/b2b', 'updateLangTranslatorB2B')->name('languages.updateLangTranslatorB2B');
            Route::get('/language/translate-json/{id}', 'translateJson')->name('language.translate-json');
            Route::get('/getFileContents/{id}', 'getFileContents')->name('language.getFileContents');
            Route::post('/languages/translate/store/json', 'storeLangTranslatorJson')->name('languages.translate.store.json');
            Route::get('export-b2c-translate/{id}', 'exportTranslate')->name('export-b2c-translate');
            Route::get('download-translate-template', 'downloadTemplate')->name('translate.template');
            Route::post('import-translate', 'importTranslate')->name('import-translate');
        });
        //login attempts routes
        Route::resource('/login-attempt', LoginAttemptController::class);

        //password security routes
        Route::resource('/password-security', PasswordSecurityController::class);
        Route::post('/check-password-length', 'PasswordSecurityController@checkPasswordLength')->name('checkPasswordLength');

        //sign in method routes
        Route::resource('/signin-method', SinginMethodController::class);


        //Currency method routes
        Route::resource('/currency', CurrencyController::class);
        Route::controller(CurrencyController::class)->group(function () {
            Route::get('/agency-currency/checkCurrency', 'checkAgencyCurrencyExist')->name('admin.agency-currency.checkExist');
            Route::get('/currencies/exchange-rate', 'exchangeRate')->name('currency.exchange-rate');
            Route::get('/currency-data', 'getAllowCurrency')->name('admin.get-allow_currency');
            Route::get('/check-currency-data', 'checkAllowCurrency')->name('admin.check-allow_currency');
            Route::post('/get-default-currency', 'getDefaultCurrency')->name('admin.get-default_currency');
            Route::post('/get_currencyexchangerate', 'CurrencyController@getCurrencyExchange')->name('admin.get-currency_exchange_rate');
            Route::post('/get_currencyapplymargin', 'getCurrencyApplymargin')->name('admin.get-currency_apply_margin');
            Route::post('/get_currencysingleapplymargin', 'getCurrencysingleApplymargin')->name('admin.get-currency_apply_single_margin');
        });
        //setting's routes
        //admin operational_data Agency-Type Type routes
        Route::resource('agency-type', AgencyTypeController::class);
        Route::get('/deleteAgency', [AgencyTypeController::class, 'deleteAgency'])->name('agency-type.delete');
        Route::post('/agency-type/checkExist', [AgencyTypeController::class, 'checkExist'])->name('agency-type.checkExist');

        //admin operational_data Service Type routes
        Route::resource('service-type', ServiceTypeController::class);
        Route::get('/deleteService', [ServiceTypeController::class, 'deleteService'])->name('service-type.delete');
        Route::post('/service-type/checkExist', [ServiceTypeController::class, 'checkExist'])->name('service-type.checkExist');

        //admin operational_data Suppliers routes
        Route::resource('suppliers', SuppliersController::class);
        Route::get('/deletesupplier', [SuppliersController::class, 'deletesupplier'])->name('suppliers.delete');
        Route::post('suppliers/checkExit', [SuppliersController::class, 'checkExist'])->name('suppliers.checkExist');


        //admin operational_data Payment-Method routes
        Route::resource('paymentmethod', PaymentmethodController::class);
        Route::get('/deletepayment', [PaymentmethodController::class, 'deletePaymentMethod'])->name('paymentmethod.delete');
        Route::post('paymentmethod/checkExit', [PaymentmethodController::class, 'checkExist'])->name('paymentmethod.checkExist');

        //admin operational_data Banks routes
        Route::resource('banks', BankController::class);
        Route::get('/deletebank', [BankController::class, 'deleteBank'])->name('bank.delete');

        //admin operational_data payment-gateway routes
        Route::resource('payment-gateway', PaymentGatewayController::class);
        Route::controller(PaymentGatewayController::class)->group(function () {
            Route::get('/deletePayment', 'deletePayment')->name('payment-gateway.delete');
            Route::post('/payment-gateway/checkName', 'checkExistName')->name('admin.payment-gateway.checkExistName');
            //test hyper pay
            Route::get('/checkout', 'checkout')->name('checkout');
            Route::any('checkout-payment', 'payment')->name('checkout-payment');
            Route::get('checkout-payment-status', 'checkPaymentStatus')->name('checkout-payment-status');
        });
        //admin operational_data Banks routes
        Route::resource('/coupons', CouponController::class);
        Route::post('/checkCouponCodeExist', [CouponController::class, 'checkCouponCodeExist'])->name('checkCouponCodeExist');
        Route::get('/deleteCoupons', [CouponController::class, 'deleteCoupons'])->name('admin.coupons.delete');



        //Markups's routes
        Route::resource('/flight-markups', FlightMarkupsController::class);
        Route::controller(FlightMarkupsController::class)->group(function () {
            //markups(show service-type list) routes
            Route::post('/updateMarkupData/{id}', 'updateMarkupData')->name('update-markups');
            Route::get('/deleteMarkups', 'deleteMarkups')->name('delete.markups');
            Route::get('/markups/manage', 'getListData')->name('markups.service_types');
            Route::post('/markups/storeDefaultMarkup', 'storeDefaultMarkup')->name('default-flight-markups.store');
            Route::get('/markups/default-flights-markups/{id}', 'showDefaultMarkup')->name('default-flight-markups-show.show');
            Route::get('/markups/default-flights-markups-edit/{id}', 'editDefaultMarkup')->name('default-flight-markups-edit.edit');
            Route::post('/markups/default-flights-markups-update/{id}', 'updateDefaultMarkup')->name('update-default-markups');
            Route::get('/deleteDefaultMarkups', 'deleteDefaultMarkups')->name('delete.default-markups');
            Route::get('/markups/created', 'addData')->name('markups.created');
            Route::get('/markups/addDefaultMarkup', 'addDefaultMarkupData')->name('markups.addDefaultMarkup');
            Route::get('/manage/fetch-origin', 'fetchOriginList')->name('markups.fetchOrigin');
            Route::get('/manage/fetch-airlines', 'fetchAirlines')->name('markups.fetchAirlines');
            Route::get('/manage/fetch-supplier', 'fetchSupplier')->name('markups.fetchSupplier');
            Route::get('/markup-logs', 'showMarkupLogs')->name('markups.markup-logs');
            Route::get('/get-markup-logs', 'getMarkupLogs')->name('get-markup-logs');
            Route::post('/markups/storeHotelMarkup', 'FlightMarkupsController@storeHotel')->name('markups.storeHotelMarkup');
            Route::post('/fetch-service-id',  'fetchServiceId')->name('fetchServiceId');
        });
        //Flight Sales Markups's routes
        Route::resource('/flight-sales-markups', FlightSalesMarkupsController::class);
        Route::get('/deleteflightSalesMarkups/{id}', [FlightSalesMarkupsController::class, 'deleteflightSalesMarkup'])->name('flight-sales.markups.delete');
        //Hotel Sales Markups's routes
        Route::resource('/hotel-sales-markups', HotelSalesMarkupsController::class);
        Route::get('/deletehotelSalesMarkups/{id}', [HotelSalesMarkupsController::class, 'deletehotelSalesMarkup'])->name('hotel-sales.markups.delete');

        //admin user's routes
        Route::resource('mail-template', MailTemplateController::class);
        Route::post('/uploadMailFile', [MailTemplateController::class, 'uploadMailFile']);
        //admin operation_Data Service Type routes
        Route::resource('sms-template', SmsTemplateController::class);

        Route::resource('mail-campaign', MailCampaignController::class);
        Route::get('/deleteMailCampaign/{id}', [MailCampaignController::class, 'deleteMailCampaign'])->name('admin.mailcampaign.delete');

        Route::post('/sendMailCampaign/{id}', [MailCampaignController::class, 'sendMailCampaign'])->name('admin.mail-campaign.sendemail');


        Route::resource('airports', AirportsController::class);
        Route::controller(AirportsController::class)->group(function () {
            //admin user's routes
            Route::get('/deleteAirport', 'deleteAirport')->name('admin.airports.delete');
            Route::get('/restoreAirport', 'restoreAirport')->name('admin.airports.restore');
            Route::post('/airports/checkAirportCodeExist', 'checkAirportCodeExist')->name('airports.checkAirportCodeExist');
            Route::post('/airports/checkAirportNameEnExist', 'checkAirportNameEnExist')->name('airports.checkAirportNameEnExist');
            Route::post('/airports/checkAirportNameArExist', 'checkAirportNameArExist')->name('airports.checkAirportNameArExist');
            Route::post('/airports/checkAirportLatitudeExist', 'checkAirportLatitudeExist')->name('airports.checkAirportLatitudeExist');
            Route::post('/airports/checkAirportLongitudeExist', 'checkAirportLongitudeExist')->name('airports.checkAirportLongitudeExist');
            Route::get('/airport/dataforselect2', 'fetchCities')->name('airports.dataforselect2');
            Route::get('/get-country-name', 'fetchCountryName');
            Route::get('/get-city-name/{country_code}', 'fetchCityName');
            Route::get('/get-state-name/{city_id}', 'fetchStateName');
            Route::get('/get-only-city-name', 'fetchOnlyCityName');
            //airport's import routes
            Route::post('importAirport', 'AirportsController@importAirport')->name('import-airport');
        });
        //admin countries routes
        Route::resource('countries', CountryController::class);
        Route::controller(CountryController::class)->group(function () {
            Route::get('/deleteCountry', 'deleteCountry')->name('admin.countries.delete');
            Route::get('/restoreCountry', 'restoreCountry')->name('admin.countries.restore');
            Route::post('/countries/checkCountryNameEnExist', 'checkCountryNameEnExist')->name('countries.checkCountryNameEnExist');
            Route::post('/countries/checkCountryNameArExist', 'checkCountryNameArExist')->name('countries.checkCountryNameArExist');
            Route::post('/countries/checkISOCodeExist', 'checkISOCodeExist')->name('countries.checkISOCodeExist');
            Route::post('/countries/checkISDCodeExist', 'checkISDCodeExist')->name('countries.checkISDCodeExist');
            //country's import routes
            Route::post('importCountry', 'importCountryCsv')->name('import-country');
        });
        //admin states routes
        Route::resource('states', StateController::class);
        Route::controller(StateController::class)->group(function () {
            Route::get('/deleteState', 'deleteState')->name('admin.states.delete');
            Route::get('/restoreState', 'restoreState')->name('admin.states.restore');
            Route::get('/get-states', 'fetchCountryCode');
            Route::get('/get-cities/{country_code}', 'getCities');
            Route::post('/states/checkStateNameEnExist', 'checkStateNameEnExist')->name('states.checkStateNameEnExist');
            Route::post('/states/checkStateNameArExist', 'checkStateNameArExist')->name('states.checkStateNameArExist');
            Route::post('/states/checkISOCodeExist', 'checkISOCodeExist')->name('states.checkISOCodeExist');
            Route::post('/states/checkStateLatitudeExist', 'checkStateLatitudeExist')->name('states.checkStateLatitudeExist');
            Route::post('/states/checkStateLongitudeExist', 'checkStateLongitudeExist')->name('states.checkStateLongitudeExist');
            //states's import routes
            Route::post('importState', 'importState')->name('import-state');
        });
        //admin cities routes
        Route::resource('cities', CityController::class);
        Route::controller(CityController::class)->group(function () {
            Route::get('/deleteCity', 'deleteCity')->name('admin.cities.delete');
            Route::get('/restoreCity', 'restoreCity')->name('admin.cities.restore');
            Route::post('/cities/checkCityNameEnExist', 'checkCityNameEnExist')->name('cities.checkCityNameEnExist');
            Route::post('/cities/checkCityNameArExist', 'checkCityNameArExist')->name('cities.checkCityNameArExist');
            Route::post('/cities/checkISOCodeExist', 'checkISOCodeExist')->name('cities.checkISOCodeExist');
            Route::post('/cities/checkCityLatitudeExist', 'checkCityLatitudeExist')->name('cities.checkCityLatitudeExist');
            Route::post('/cities/checkCityLongitudeExist', 'checkCityLongitudeExist')->name('cities.checkCityLongitudeExist');
            Route::get('/fetchCountryCode', 'fetchCountryCode');
            //city's import routes
            Route::post('importCity', 'importCity')->name('import-city');
            Route::get('/get-all-cities', 'getAllCities');
            Route::get('/get-all-hotels', 'getAllHotels');
        });
        //admin airlines routes
        Route::resource('airlines', AirlineController::class);
        Route::controller(AirlineController::class)->group(function () {
            Route::get('/deleteAirline', 'deleteAirline')->name('admin.airlines.delete');
            Route::get('/restoreAirline', 'restoreAirline')->name('admin.airlines.restore');
            Route::post('/airlines/checkAirlineNameEnExist', 'checkAirlineNameEnExist')->name('airlines.checkAirlineNameEnExist');
            Route::post('/airlines/checkAirlineNameArExist', 'checkAirlineNameArExist')->name('airlines.checkAirlineNameArExist');
            Route::post('/airlines/checkAirlineCodeExist', 'checkAirlineCodeExist')->name('airlines.checkAirlineCodeExist');
            //airline's import routes
            Route::post('importAirline', '=importAirline')->name('import-airline');
        });
        // City Images Resource

        Route::resource('city-images', TopDestinationController::class);

        Route::get('/deleteCityImage/{id}', [TopDestinationController::class, 'deleteCityImage'])->name('admin.deleteCityImage.delete');

        Route::get('/fetch-cities-by-country', [TopDestinationController::class, 'fetchCitiesByCountry']);


        // MarkupSetting
        Route::post('save-markup-settings/{id}', [MarkupSettingController::class, 'applyMarkupToList']);

        // General Settings
        Route::get('/general-settings', [GeneralSettingController::class, 'index'])->name('admin.general-setting');
        Route::post('/save-general-settings', [GeneralSettingController::class, 'store']);

        // Booking Logs
        Route::get('/booking-logs', [BookingLogController::class, 'index'])->name('admin.booking-logs');
        Route::get('/get-booking-logs', [BookingLogController::class, 'getBookingLog'])->name('admin.get-booking-logs');
        // Privacy Policy QR
        // Route::get('/qr-redirect/{code}', [PageController::class, 'handleQrRedirect']);

        // Hotel Recommendation
        Route::resource('/hotel-recommendation', HotelRecommendationController::class);

        Route::get('/delete-recommendation/{id}', 'Admin\HotelRecommendationController@deleteHotelRecommendation')->name('admin.hotel-recommendation.delete');
        Route::get('bookings/{customerId}', [WalletController::class, 'getBookingsByCustomer'])->name('getBookingsByCustomer');
        Route::get('wallet/get-wallet-currency/{booking_id}', [WalletController::class, 'getCurrencyByBookingId'])->name('getWalletCurrencyById');
        Route::resource('/wallet', 'Admin\WalletController');
        Route::get('/deleteWallet', 'Admin\WalletController@deleteWallet')->name('admin.wallet.delete');

        Route::get('export-bookings', function () {
            // return Excel::download(new BookingsExport, 'bookings.xlsx');
            ob_end_clean();
            return Excel::download(new BookingsExport, 'bookings.xlsx', \Maatwebsite\Excel\Excel::XLSX);
        });
        Route::resource('/api-list', ApiController::class);
        Route::get('/api-list/delete/{id}', [ApiController::class, 'deleteApi'])->name('admin.api-list.delete');
        Route::post('/admin/login-as/{customerId}', [AdminLoginAsCustomerController::class, 'generateLoginToken'])->name('admin.generate-login-token');
        Route::get('/admin/login-as-customer-logs', [AdminLoginAsCustomerController::class, 'adminAsCustomerLogList'])->name('admin.log-as-customer-log-list');
        Route::get('/admin/get-login-as-customer-logs', [AdminLoginAsCustomerController::class, 'getAdminAsCustomerLogList'])->name('admin.get-admin-as-customer-log');

        Route::resource('hotel-special-request', HotelSpecialRequestController::class);
        Route::get('/delete-special-request/{id}', [HotelSpecialRequestController::class, 'deleteHotelSpecialRequest'])->name('hotel-special-request.delete');

        Route::get('hotel-facilities-ar/data', [HotelFacilitiesArController::class, 'getData'])->name('hotel-facilities-ar.data');
        Route::resource('hotel-facilities-ar', HotelFacilitiesArController::class);
        Route::get('/delete-hotel-facilites-ar/{id}', [HotelFacilitiesArController::class, 'deleteHotelFacilityAr'])->name('hotel-facilities-ar.delete');

        Route::get('export-hotel-facility-ar', [HotelFacilitiesArController::class, 'exportHotelFacilityExport'])->name('hotel-facilities-ar.export');
        Route::get('/hotel-facilities-ar-template-download', [HotelFacilitiesArController::class, 'downloadTemplate'])->name('hotel-facilities-ar.template');


        Route::post('/hotel-facilities-ar/import', [HotelFacilitiesArController::class, 'import'])->name('hotel-facilities-ar.import');
    });

    Route::get('/amadeus/refresh-token', [AmadeusApiController::class, 'getRefreshToken'])->name('amadeus.refresh-token');
    Route::get('/send-password-expiry', [ProfileController::class, 'ExpiryNotificaton'])->name('send-password-expiry');


    Route::controller(BookingController::class)->prefix('booking')->group(function () {
        Route::get('/cancel-booking/{id}', 'cancelBooking')->name('admin.booking.cancel');
        Route::get('/refund-booking/{id}', 'refundBooking')->name('admin.booking.refund');
        Route::get('/supplier-log/{id}', 'supplierLog')->name('admin.booking.supplier-log');
        Route::get('/supplier-log/{id}', 'supplierLog')->name('admin.booking.supplier-log');
        Route::get('cancel-booking/{id}', 'cancelBooking')->name('admin.booking.cancel');
        Route::get('/{id}/{locale?}', 'downloadInvoice')->name('booking.show');
        Route::get('/show_invoice/{id}/{locale?}', 'show_invoice')->name('admin.booking.show_invoice');
        Route::get('/show_voucher/{id}/{locale?}', 'show')->name('admin.booking.show_voucher');

        Route::get('/download/{id}', 'download')->name('admin.booking.index');

        Route::get('/downloadInvoice/{id}/{locale?}', 'downloadInvoiceOld')->name('admin.booking.show_invoice');
        Route::get('/downloadVoucher/{id}/{locale?}', 'show')->name('admin.booking.downloadVoucher');
        Route::post('/update-status', 'updateBookingStatus')->name('booking.update.status');

        Route::get('/download-flight-ticket/{id}/{locale?}', 'showFlightTicket')->name('admin.booking.download-flight-ticket');
        Route::get('/showFlightTicket/{id}/{locale?}', 'showFlightTicket')->name('admin.booking.showFlightTicket');


        Route::get('/check-translate', function (\Illuminate\Http\Request $request) {
            $tr = new GoogleTranslate(); // Translates to 'en' from auto-detected language by default
            $tr->setSource('en'); // Translate from English
            $tr->setSource(); // Detect language automatically
            $tr->setTarget('ka'); // Translate to Georgian
            return  $tr->translate('Hello World!');
        });
    });
    // For Cron Jobs
    Route::get('/update-trending-search', function () {
        Artisan::call('update-trending-search');
        return Artisan::output();
    });
    Route::get('/cashback-wallet', function () {
        Artisan::call('cashback:to-wallet');
        return Artisan::output();
    });

    Route::get('qr-redirect/{code?}', [PageController::class, 'handleQrRedirect']);


    Route::fallback(function () {
        return view('admin.404');
    });
});
